/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams.swing.monitor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.tams.TamsListener;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.TamsReply;
import jmri.jmrix.tams.TamsSystemConnectionMemo;
import jmri.jmrix.tams.swing.TamsPanelInterface;
import jmri.jmrix.tams.swing.monitor.Bundle;
import jmri.util.StringUtil;

public class TamsMonPane
extends AbstractMonPane
implements TamsListener,
TamsPanelInterface {
    TamsSystemConnectionMemo memo;
    JCheckBox disablePollingCheckBox = new JCheckBox();

    @Override
    public String getHelpTarget() {
        return null;
    }

    @Override
    public String getTitle() {
        return Bundle.getMessage("CommandMonitor");
    }

    @Override
    public void dispose() {
        this.memo.getTrafficController().removeTamsListener(this);
        super.dispose();
    }

    @Override
    public void init() {
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof TamsSystemConnectionMemo) {
            this.initComponents((TamsSystemConnectionMemo)context);
        }
    }

    @Override
    public void initComponents(TamsSystemConnectionMemo memo) {
        this.memo = memo;
        memo.getTrafficController().addTamsListener(this);
        this.disablePollingCheckBox.setSelected(memo.getTrafficController().getPollQueueDisabled());
    }

    @Override
    public void initComponents() {
        super.initComponents();
        JPanel check = new JPanel();
        this.disablePollingCheckBox.setText(Bundle.getMessage("DisablePollingBoxLabel"));
        this.disablePollingCheckBox.setVisible(true);
        this.disablePollingCheckBox.setToolTipText(Bundle.getMessage("DisablePollingToolTip"));
        this.disablePollingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TamsMonPane.this.memo != null) {
                    TamsMonPane.this.memo.getTrafficController().setPollQueueDisabled(TamsMonPane.this.disablePollingCheckBox.isSelected());
                }
            }
        });
        check.add(this.disablePollingCheckBox);
        this.add(check);
    }

    @Override
    public synchronized void message(TamsMessage tm) {
        if (tm.isBinary()) {
            this.logMessage("Binary cmd: ", tm);
        } else {
            this.logMessage("ASCII cmd: ", tm);
        }
    }

    @Override
    public synchronized void reply(TamsReply l) {
        Object raw = "";
        for (int i = 0; i < l.getNumDataElements(); ++i) {
            if (i > 0) {
                raw = (String)raw + " ";
            }
            raw = StringUtil.appendTwoHexFromInt(l.getElement(i) & 0xFF, (String)raw);
        }
        if (l.isUnsolicited()) {
            this.logMessage("msg: ", l);
        } else if (l.isBinary()) {
            this.logMessage("Binary rep: ", l);
        } else {
            this.logMessage("ASCII rep: ", l);
        }
    }
}

