/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tams.swing.packetgen;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jmri.jmrix.tams.TamsMessage;
import jmri.jmrix.tams.swing.TamsPanel;
import jmri.util.StringUtil;
import jmri.util.swing.JmriJOptionPane;

public class PacketGenPanel
extends TamsPanel {
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(20);
    JCheckBox checkBoxBinCmd = new JCheckBox();
    JCheckBox checkBoxReplyType = new JCheckBox();

    @Override
    public void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.jLabel1.setText("Command: ");
        this.jLabel1.setVisible(true);
        this.sendButton.setText("Send");
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText("Send packet");
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText("Enter command");
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.checkBoxBinCmd.setText("Binary");
        this.checkBoxBinCmd.setVisible(true);
        this.checkBoxBinCmd.setToolTipText("Check to enable binary commands");
        this.checkBoxBinCmd.setSelected(false);
        this.add(this.jLabel1);
        this.add(this.packetTextField);
        this.add(this.checkBoxBinCmd);
        this.add(this.sendButton);
        this.sendButton.addActionListener(this::sendButtonActionPerformed);
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.tams.swing.packetgen.PacketGenFrame";
    }

    @Override
    public String getTitle() {
        return "Send Tams command";
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        TamsMessage m;
        String input = this.packetTextField.getText();
        if (this.checkBoxBinCmd.isSelected()) {
            m = this.createPacket(input);
            if (m == null) {
                JmriJOptionPane.showMessageDialog(this, "Enter hexadecimal numbers only", "Tams Binary Command", 0);
                return;
            }
            m.setReplyType('M');
            m.setBinary(true);
            if (m.getElement(1) == 166) {
                m = TamsMessage.setXPwrOff();
            }
            if (m.getElement(1) == 167) {
                m = TamsMessage.setXPwrOn();
            }
        } else {
            m = new TamsMessage(input.length());
            for (int i = 0; i < input.length(); ++i) {
                m.setElement(i, input.charAt(i));
            }
            m.setReplyType('M');
            m.setBinary(false);
            if (m.getElement(1) == 80) {
                m.setReplyType('C');
            }
        }
        if (this.memo != null) {
            this.memo.getTrafficController().sendTamsMessage(m, null);
        }
    }

    TamsMessage createPacket(String s) {
        byte[] b;
        try {
            b = StringUtil.bytesFromHexString(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (b.length == 0) {
            return null;
        }
        TamsMessage m = new TamsMessage(b.length);
        for (int i = 0; i < b.length; ++i) {
            m.setElement(i, b[i]);
        }
        return m;
    }
}

