/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tmcc;

import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.tmcc.SerialMessage;
import jmri.jmrix.tmcc.SerialTrafficController;
import jmri.jmrix.tmcc.TmccSystemConnectionMemo;
import jmri.util.ThreadingUtil;

public class SerialThrottle
extends AbstractThrottle {
    private final DccLocoAddress address;
    private final SerialTrafficController tc;
    private static final long[] SERIAL_FUNCTION_CODES = new long[]{13L, 29L, 28L, 5L, 6L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 9L, 30L, 0L, 3L, 1L, 4L, 7L, 71L, 66L, 40L, 41L, 42L, 43L, 272687405990396L, 16253436L, 272687439544830L, 16253438L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L, 0xF90000L};
    static final int REPEAT_TIME = 150;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialThrottle(TmccSystemConnectionMemo memo, DccLocoAddress address) {
        super(memo, 69);
        this.tc = memo.getTrafficController();
        SerialThrottle serialThrottle = this;
        synchronized (serialThrottle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
        this.speedStepMode = SpeedStepMode.TMCC_32;
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    public void setFunction(int func, boolean value) {
        this.updateFunction(func, value);
        if (func >= 0 && func < SERIAL_FUNCTION_CODES.length) {
            if (SERIAL_FUNCTION_CODES[func] > 65535L) {
                if (SERIAL_FUNCTION_CODES[func] > 0xFFFFFFL) {
                    int first = (int)(SERIAL_FUNCTION_CODES[func] >> 24);
                    int second = (int)(SERIAL_FUNCTION_CODES[func] & 0xFFFFFFL);
                    this.sendOneWordOnce(first + this.address.getNumber() * 512);
                    this.sendOneWordOnce(second + this.address.getNumber() * 512);
                } else {
                    this.sendFnToLayout((int)SERIAL_FUNCTION_CODES[func] + this.address.getNumber() * 512, func);
                }
            } else {
                this.sendFnToLayout((int)SERIAL_FUNCTION_CODES[func] + this.address.getNumber() * 128, func);
            }
        } else {
            super.setFunction(func, value);
        }
    }

    private void sendOneWordOnce(int word) {
        SerialMessage m = new SerialMessage(word);
        this.tc.sendSerialMessage(m, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSpeedSetting(float speed) {
        int value;
        float oldSpeed;
        SerialThrottle serialThrottle = this;
        synchronized (serialThrottle) {
            oldSpeed = this.speedSetting;
            this.speedSetting = speed;
        }
        if (this.speedStepMode == SpeedStepMode.TMCC_200) {
            value = (int)(199.0f * speed);
            if (value > 199) {
                value = 199;
            }
            SerialMessage m = new SerialMessage();
            m.setOpCode(248);
            if (value < 0) {
                m.putAsWord(0 + (this.address.getNumber() << 9) + 0);
            } else {
                m.putAsWord(0 + (this.address.getNumber() << 9) + value);
            }
            this.tc.sendSerialMessage(m, null);
            this.tc.sendSerialMessage(m, null);
        } else {
            value = (int)(32.0f * speed);
            if (value > 31) {
                value = 31;
            }
            SerialMessage m = new SerialMessage();
            if (value < 0) {
                m.putAsWord(96 + this.address.getNumber() * 128 + 0);
            } else {
                m.putAsWord(96 + this.address.getNumber() * 128 + value);
            }
            this.tc.sendSerialMessage(m, null);
            this.tc.sendSerialMessage(m, null);
            this.tc.sendSerialMessage(m, null);
            this.tc.sendSerialMessage(m, null);
        }
        SerialThrottle serialThrottle2 = this;
        synchronized (serialThrottle2) {
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        }
        this.record(speed);
    }

    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        SerialMessage m = new SerialMessage();
        if (forward) {
            m.putAsWord(0 + this.address.getNumber() * 128);
        } else {
            m.putAsWord(3 + this.address.getNumber() * 128);
        }
        this.tc.sendSerialMessage(m, null);
        this.tc.sendSerialMessage(m, null);
        this.tc.sendSerialMessage(m, null);
        this.tc.sendSerialMessage(m, null);
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    protected void sendFnToLayout(int value, int func) {
        this.tc.sendSerialMessage(new SerialMessage(value), null);
        this.tc.sendSerialMessage(new SerialMessage(value), null);
        this.tc.sendSerialMessage(new SerialMessage(value), null);
        this.repeatFunctionSendWhileOn(value, func);
    }

    protected void repeatFunctionSendWhileOn(int value, int func) {
        if (this.getFunction(func)) {
            this.tc.sendSerialMessage(new SerialMessage(value), null);
            ThreadingUtil.runOnLayoutDelayed(() -> this.repeatFunctionSendWhileOn(value, func), 150);
        }
    }

    @Override
    public void setSpeedStepMode(SpeedStepMode mode) {
        if (mode == SpeedStepMode.TMCC_32 || mode == SpeedStepMode.TMCC_200) {
            super.setSpeedStepMode(mode);
        }
    }

    @Override
    public void throttleDispose() {
        this.finishRecord();
    }
}

