/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tmcc;

import java.util.EnumSet;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.tmcc.SerialThrottle;
import jmri.jmrix.tmcc.TmccSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialThrottleManager
extends AbstractThrottleManager {
    private final TmccSystemConnectionMemo _memo;
    private static final Logger log = LoggerFactory.getLogger(SerialThrottleManager.class);

    public SerialThrottleManager(TmccSystemConnectionMemo memo) {
        super(memo);
        this._memo = memo;
        this.userName = "Lionel TMCC";
    }

    @Override
    public void dispose() {
    }

    @Override
    public void requestThrottleSetup(LocoAddress a, boolean control) {
        if (a instanceof DccLocoAddress) {
            DccLocoAddress address = (DccLocoAddress)a;
            log.debug("new TMCC throttle for {}", (Object)address);
            this.notifyThrottleKnown(new SerialThrottle(this._memo, address), address);
        } else {
            log.error("{} is not a DccLocoAddress", (Object)a);
            this.failedThrottleRequest(a, "LocoAddress " + a + " is not a DccLocoAddress");
        }
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return address >= 1;
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return address <= 127;
    }

    @Override
    public boolean addressTypeUnique() {
        return false;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.TMCC_32, SpeedStepMode.TMCC_200);
    }
}

