/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tmcc;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.tmcc.SerialInterface;
import jmri.jmrix.tmcc.SerialListener;
import jmri.jmrix.tmcc.SerialMessage;
import jmri.jmrix.tmcc.SerialReply;
import jmri.jmrix.tmcc.TmccSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTrafficController
extends AbstractMRTrafficController
implements SerialInterface {
    TmccSystemConnectionMemo mMemo = null;
    private static final Logger log = LoggerFactory.getLogger(SerialTrafficController.class);

    public SerialTrafficController(TmccSystemConnectionMemo adaptermemo) {
        this.mMemo = adaptermemo;
        this.mWaitBeforePoll = 25;
        log.debug("creating a new TMCCTrafficController object");
    }

    @Override
    public synchronized void addSerialListener(SerialListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeSerialListener(SerialListener l) {
        this.removeListener(l);
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        log.warn("enterProgMode doesn't make sense for TMCC serial");
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    public TmccSystemConnectionMemo getSystemConnectionMemo() {
        return this.mMemo;
    }

    public void setSystemConnectionMemo(TmccSystemConnectionMemo m) {
        this.mMemo = m;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((SerialListener)client).message((SerialMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply m) {
        ((SerialListener)client).reply((SerialReply)m);
    }

    @Override
    protected synchronized AbstractMRMessage pollMessage() {
        return null;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return null;
    }

    @Override
    public void sendSerialMessage(SerialMessage m, SerialListener reply) {
        this.sendMessage(m, reply);
    }

    @Override
    protected AbstractMRReply newReply() {
        return new SerialReply();
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        log.error("Not using endOfMessage, should not be called");
        return false;
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        byte char1 = this.readByteProtected(istream);
        msg.setElement(0, char1 & 0xFE);
        if ((char1 & 0xFF) != 254 && (char1 & 0xFF) != 248 && (char1 & 0xFF) != 249) {
            log.warn("return short message as 1st byte is {}", (Object)(char1 & 0xFF));
            return;
        }
        char1 = this.readByteProtected(istream);
        msg.setElement(1, char1 & 0xFF);
        char1 = this.readByteProtected(istream);
        msg.setElement(2, char1 & 0xFF);
    }

    @Override
    protected void waitForStartOfReply(DataInputStream istream) throws IOException {
    }

    @Override
    protected int addHeaderToOutput(byte[] msg, AbstractMRMessage m) {
        return 0;
    }

    @Override
    protected void addTrailerToOutput(byte[] msg, int offset, AbstractMRMessage m) {
    }

    @Override
    protected int lengthOfByteStream(AbstractMRMessage m) {
        return 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        block20: {
            log.debug("forwardToPort message: [{}]", (Object)m);
            this.mLastSender = reply;
            AbstractMRTrafficController.XmtNotifier r = new AbstractMRTrafficController.XmtNotifier(m, this.mLastSender, this);
            SwingUtilities.invokeLater(r);
            byte[] msg = new byte[this.lengthOfByteStream(m)];
            int offset = this.addHeaderToOutput(msg, m);
            int len = m.getNumDataElements();
            for (int i = 0; i < len; ++i) {
                msg[i + offset] = (byte)m.getElement(i);
            }
            this.addTrailerToOutput(msg, len + offset, m);
            try {
                if (this.ostream != null) {
                    if (log.isDebugEnabled()) {
                        StringBuilder f = new StringBuilder("");
                        for (int i2 = 0; i2 < msg.length; ++i2) {
                            f.append(Integer.toHexString(0xFF & msg[i2])).append(" ");
                        }
                        log.debug("write message: {}", (Object)f);
                    }
                    while (m.getRetries() >= 0) {
                        if (this.portReadyToSend(this.controller)) {
                            for (int i = 0; i < len; ++i) {
                                this.ostream.write(msg[i]);
                                try {
                                    Runnable i2 = this.xmtRunnable;
                                    synchronized (i2) {
                                        this.xmtRunnable.wait(10L);
                                        continue;
                                    }
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    log.warn("char send wait interrupted");
                                }
                            }
                            break block20;
                        }
                        if (m.getRetries() >= 0) {
                            log.debug("Retry message: {} attempts remaining: {}", (Object)m, (Object)m.getRetries());
                            m.setRetries(m.getRetries() - 1);
                            try {
                                Runnable i = this.xmtRunnable;
                                synchronized (i) {
                                    this.xmtRunnable.wait(m.getTimeout());
                                    continue;
                                }
                            }
                            catch (InterruptedException e) {
                                log.error("retry wait interrupted");
                                continue;
                            }
                        }
                        log.warn("sendMessage: port not ready for data sending: {}", (Object)Arrays.toString(msg));
                    }
                    break block20;
                }
                log.warn("sendMessage: no connection established");
            }
            catch (IOException | RuntimeException e) {
                log.warn("sendMessage: Exception:", (Throwable)e);
            }
        }
    }
}

