/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tmcc;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.Turnout;
import jmri.jmrix.tmcc.Bundle;
import jmri.jmrix.tmcc.SerialListener;
import jmri.jmrix.tmcc.SerialMessage;
import jmri.jmrix.tmcc.SerialReply;
import jmri.jmrix.tmcc.SerialTurnout;
import jmri.jmrix.tmcc.TmccSystemConnectionMemo;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnoutManager
extends AbstractTurnoutManager
implements SerialListener {
    private static final Logger log = LoggerFactory.getLogger(SerialTurnoutManager.class);

    public SerialTurnoutManager(TmccSystemConnectionMemo memo) {
        super(memo);
        memo.getTrafficController().addSerialListener(this);
        log.debug("TMCC TurnoutManager prefix={}", (Object)this.getSystemPrefix());
    }

    @Override
    @Nonnull
    public TmccSystemConnectionMemo getMemo() {
        return (TmccSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String sName = this.validateSystemNameFormat(systemName);
        Turnout t = (Turnout)this.getBySystemName(sName);
        if (t != null) {
            log.debug("Turnout already exists");
            return t;
        }
        log.debug("new SerialTurnout with addr = {}", (Object)systemName.substring(this.getSystemPrefix().length() + 1));
        int addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        t = new SerialTurnout(this.getSystemPrefix(), addr, this.getMemo());
        t.setUserName(userName);
        return t;
    }

    @Override
    public void message(SerialMessage m) {
        log.debug("message received unexpectedly: {}", (Object)m.toString());
    }

    @Override
    public void reply(SerialReply r) {
        log.debug("reply received unexpectedly: {}", (Object)r.toString());
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return this.validateIntegerSystemNameFormat(name, 1, 99, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        Manager.NameValidity validity = super.validSystemNameFormat(systemName);
        if (validity == Manager.NameValidity.VALID) {
            try {
                int num = Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length()));
                if (num < 0 || num > 99) {
                    validity = Manager.NameValidity.INVALID;
                }
            }
            catch (NumberFormatException ex) {
                validity = Manager.NameValidity.INVALID;
            }
        }
        return validity;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

