/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.tmcc.serialmon;

import jmri.jmrix.AbstractMonFrame;
import jmri.jmrix.tmcc.SerialListener;
import jmri.jmrix.tmcc.SerialMessage;
import jmri.jmrix.tmcc.SerialReply;
import jmri.jmrix.tmcc.TmccSystemConnectionMemo;
import jmri.jmrix.tmcc.serialmon.Bundle;

public class SerialMonFrame
extends AbstractMonFrame
implements SerialListener {
    private TmccSystemConnectionMemo _memo = null;

    public SerialMonFrame(TmccSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    protected String title() {
        return Bundle.getMessage("MonitorXTitle", "TMCC");
    }

    @Override
    protected void init() {
        this._memo.getTrafficController().addSerialListener(this);
    }

    @Override
    public void dispose() {
        this._memo.getTrafficController().removeSerialListener(this);
        super.dispose();
    }

    @Override
    public synchronized void message(SerialMessage l) {
        if (l.getNumDataElements() < 3) {
            this.nextLine("Truncated message of length " + l.getNumDataElements() + "\n", l.toString());
        } else {
            this.nextLine("Cmd: " + this.parse(l.getOpCode(), l.getAsWord()) + "\n", l.toString());
        }
    }

    @Override
    public synchronized void reply(SerialReply l) {
        if (l.getNumDataElements() < 2) {
            this.nextLine("Truncated reply of length " + l.getNumDataElements() + ": \"" + l.toString() + "\"\n", l.toString());
        } else {
            this.nextLine("Rep: " + this.parse(l.getOpCode(), l.getAsWord()) + "\n", l.toString());
        }
    }

    String parse(int opCode, int val) {
        if (opCode != 254) {
            return "TMCC 2 msg 0x" + Integer.toHexString(opCode) + " 0x" + Integer.toHexString(val);
        }
        if ((val & 0xC000) == 16384) {
            int A = val / 128 & 0x7F;
            int C = val / 32 & 3;
            int D = val & 0x1F;
            if (C == 0 && D == 0) {
                return "Throw switch " + A + " THROUGH";
            }
            if (C == 0 && D == 31) {
                return "Throw switch " + A + " OUT";
            }
            if (C == 1 && D == 9) {
                return "Switch " + A + " set address";
            }
            if (C == 2) {
                return "Assign switch " + A + " to route " + D + " THROUGH";
            }
            if (C == 3) {
                return "Assign switch " + A + " to route " + D + " OUT";
            }
            return "unrecognized switch command with A=" + A + " C=" + C + " D=" + D;
        }
        if ((val & 0xF000) == 53248) {
            int A = val / 128 & 0x1F;
            int C = val / 32 & 3;
            int D = val & 0x1F;
            return "route command with A=" + A + " C=" + C + " D=" + D;
        }
        if ((val & 0xC000) == 0) {
            int A = val / 128 & 0x7F;
            int C = val / 32 & 3;
            int D = val & 0x1F;
            switch (C) {
                case 0: {
                    if ((D & 0x70) == 16 && (D & 0xF) < 10) {
                        return "engine " + A + " numeric action command " + (D & 0xF);
                    }
                    switch (D) {
                        case 0: {
                            return "engine " + A + " forward direction";
                        }
                        case 1: {
                            return "engine " + A + " toggle direction";
                        }
                        case 3: {
                            return "engine " + A + " reverse direction";
                        }
                        case 7: {
                            return "engine " + A + " brake";
                        }
                        case 4: {
                            return "engine " + A + " boost";
                        }
                        case 5: {
                            return "engine " + A + " open front coupler";
                        }
                        case 6: {
                            return "engine " + A + " open rear coupler";
                        }
                        case 28: {
                            return "engine " + A + " blow horn 1";
                        }
                        case 29: {
                            return "engine " + A + " ring bell";
                        }
                        case 30: {
                            return "engine " + A + " letoff sound";
                        }
                        case 31: {
                            return "engine " + A + " blow horn 2";
                        }
                        case 8: {
                            return "engine " + A + " AUX1 off";
                        }
                        case 9: {
                            return "engine " + A + " AUX1 option 1 (CAB AUX1 button)";
                        }
                        case 10: {
                            return "engine " + A + " AUX1 option 2";
                        }
                        case 11: {
                            return "engine " + A + " AUX1 on";
                        }
                        case 12: {
                            return "engine " + A + " AUX2 off";
                        }
                        case 13: {
                            return "engine " + A + " AUX2 option 1 (CAB AUX2 button)";
                        }
                        case 14: {
                            return "engine " + A + " AUX2 option 2";
                        }
                        case 15: {
                            return "engine " + A + " AUX2 on";
                        }
                    }
                    return "engine " + A + " action command D=" + D;
                }
                case 1: {
                    return "engine " + A + " extended command (C=1) with D=" + D;
                }
                case 2: {
                    return "change engine " + A + " speed (relative) by " + (D - 5);
                }
            }
            return "set engine " + A + " speed (absolute) to " + D;
        }
        if ((val & 0xF800) == 51200) {
            int A = val / 128 & 0xF;
            int C = val / 32 & 3;
            int D = val & 0x1F;
            return "train command with A=" + A + " C=" + C + " D=" + D;
        }
        if ((val & 0xC000) == 32768) {
            int A = val / 128 & 0x7F;
            int C = val / 32 & 3;
            int D = val & 0x1F;
            return "accessory command with A=" + A + " C=" + C + " D=" + D;
        }
        if ((val & 0xF800) == 49152) {
            int A = val / 128 & 0xF;
            int C = val / 32 & 3;
            int D = val & 0x1F;
            return "group command with A=" + A + " C=" + C + " D=" + D;
        }
        return "unexpected command " + Integer.toHexString(val & 0xFF);
    }
}

