/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.xpa;

import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.xpa.XpaMessage;
import jmri.jmrix.xpa.XpaThrottleManager;
import jmri.jmrix.xpa.XpaTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpaThrottle
extends AbstractThrottle {
    private int speedvalue;
    private final int address;
    private final XpaTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(XpaThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XpaThrottle(LocoAddress address, XpaTrafficController t) {
        super(null);
        this.address = address.getNumber();
        this.speedStepMode = SpeedStepMode.INCREMENTAL;
        this.isForward = true;
        XpaThrottle xpaThrottle = this;
        synchronized (xpaThrottle) {
            this.speedSetting = 0.0f;
        }
        this.speedvalue = 0;
        this.tc = t;
        log.debug("XpaThrottle constructor called for address {}", (Object)address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSpeedSetting(float speed) {
        super.setSpeedSetting(speed);
        int value = Math.round(127.0f * speed);
        if (value > 127) {
            value = 127;
        }
        if (speed > 0.0f && value == 0) {
            value = 1;
        }
        if (this.speedvalue != value) {
            XpaMessage m;
            if (value < 0) {
                value = 0;
                m = XpaMessage.getEStopMsg();
                this.tc.sendXpaMessage(m, null);
            } else if (value == 0) {
                m = XpaMessage.getIdleMsg(this.address);
                this.tc.sendXpaMessage(m, null);
            } else if (value > this.speedvalue) {
                int diff = value - this.speedvalue;
                m = XpaMessage.getIncSpeedMsg(this.address, diff);
                this.tc.sendXpaMessage(m, null);
            } else if (value < this.speedvalue) {
                int diff = this.speedvalue - value;
                m = XpaMessage.getDecSpeedMsg(this.address, diff);
                this.tc.sendXpaMessage(m, null);
            }
        }
        XpaThrottle xpaThrottle = this;
        synchronized (xpaThrottle) {
            this.speedSetting = speed;
        }
        this.speedvalue = value;
    }

    @Override
    public void setIsForward(boolean forward) {
        super.setIsForward(forward);
        XpaMessage m = forward ? XpaMessage.getDirForwardMsg(this.address) : XpaMessage.getDirReverseMsg(this.address);
        this.tc.sendXpaMessage(m, null);
    }

    @Override
    public void setFunction(int func, boolean value) {
        if (func >= 0 && func < 13 && this.getFunction(func) != value) {
            this.updateFunction(func, value);
            this.tc.sendXpaMessage(XpaMessage.getFunctionMsg(this.address, 0), null);
        } else {
            super.setFunction(func, value);
        }
    }

    @Override
    public void sendFunctionGroup1() {
    }

    @Override
    public void sendFunctionGroup2() {
    }

    @Override
    public void sendFunctionGroup3() {
    }

    @Override
    public LocoAddress getLocoAddress() {
        return new DccLocoAddress(this.address, XpaThrottleManager.isLongAddress(this.address));
    }

    @Override
    public void throttleDispose() {
        this.finishRecord();
    }
}

