/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.xpa;

import javax.annotation.concurrent.GuardedBy;
import jmri.implementation.AbstractTurnout;
import jmri.jmrix.xpa.XpaMessage;
import jmri.jmrix.xpa.XpaSystemConnectionMemo;
import jmri.jmrix.xpa.XpaTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XpaTurnout
extends AbstractTurnout {
    private final int _number;
    private final XpaTrafficController tc;
    @GuardedBy(value="this")
    protected int _mThrown = 4;
    @GuardedBy(value="this")
    protected int _mClosed = 2;
    private static final Logger log = LoggerFactory.getLogger(XpaTurnout.class);

    public XpaTurnout(int number, XpaSystemConnectionMemo m) {
        super(m.getSystemPrefix() + "T" + number);
        this._number = number;
        this.tc = m.getXpaTrafficController();
    }

    public int getNumber() {
        return this._number;
    }

    @Override
    protected synchronized void forwardCommandChangeToLayout(int newState) {
        XpaMessage m;
        if ((newState & this._mClosed) != 0) {
            if ((newState & this._mThrown) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
                return;
            }
            m = XpaMessage.getSwitchNormalMsg(this._number);
        } else {
            m = XpaMessage.getSwitchReverseMsg(this._number);
        }
        this.tc.sendXpaMessage(m, null);
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        log.debug("Send command to {} Pushbutton PT{}", (Object)(_pushButtonLockout ? "Lock" : "Unlock"), (Object)this._number);
    }

    @Override
    public synchronized void setInverted(boolean inverted) {
        log.debug("Inverting Turnout State for turnout {}", (Object)this.getSystemName());
        if (inverted) {
            this._mThrown = 2;
            this._mClosed = 4;
        } else {
            this._mThrown = 4;
            this._mClosed = 2;
        }
        super.setInverted(inverted);
    }

    @Override
    public boolean canInvert() {
        return true;
    }
}

