/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.xpa;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.NamedBean;
import jmri.Turnout;
import jmri.jmrix.xpa.XpaSystemConnectionMemo;
import jmri.jmrix.xpa.XpaTurnout;
import jmri.managers.AbstractTurnoutManager;

public class XpaTurnoutManager
extends AbstractTurnoutManager {
    public XpaTurnoutManager(XpaSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public XpaSystemConnectionMemo getMemo() {
        return (XpaSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to convert systemName '" + systemName + "' to a Turnout address");
        }
        XpaTurnout t = new XpaTurnout(addr, this.getMemo());
        t.setUserName(userName);
        return t;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateSystemNameFormatOnlyNumeric(name, locale);
    }
}

