/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.xpa.serialdriver;

import java.io.IOException;
import jmri.InstanceManager;
import jmri.PowerManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.purejavacomm.CommPortIdentifier;
import jmri.jmrix.purejavacomm.NoSuchPortException;
import jmri.jmrix.purejavacomm.PortInUseException;
import jmri.jmrix.purejavacomm.SerialPort;
import jmri.jmrix.purejavacomm.UnsupportedCommOperationException;
import jmri.jmrix.xpa.XpaPortController;
import jmri.jmrix.xpa.XpaSystemConnectionMemo;
import jmri.jmrix.xpa.XpaTrafficController;
import jmri.jmrix.xpa.serialdriver.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends XpaPortController {
    SerialPort activeSerialPort = null;
    private Thread sinkThread;
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new XpaSystemConnectionMemo());
        ((XpaSystemConnectionMemo)this.getSystemConnectionMemo()).setXpaTrafficController(new XpaTrafficController());
        this.option1Name = "ModemInitString";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("ModemInitStringLabel"), new String[]{"ATX0E0"}));
        this.manufacturerName = "Lenz";
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.activeSerialPort.setSerialPortParams(9600, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            this.configureLeadsAndFlowControl(this.activeSerialPort, 0);
            log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            SerialDriverAdapter.purgeStream(this.activeSerialPort.getInputStream());
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud, sees  DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "IO Exception while opening port " + portName + ": " + ex;
        }
        return null;
    }

    @Override
    public void configure() {
        XpaSystemConnectionMemo memo = (XpaSystemConnectionMemo)this.getSystemConnectionMemo();
        XpaTrafficController tc = memo.getXpaTrafficController();
        tc.connectPort(this);
        InstanceManager.store(memo.getPowerManager(), PowerManager.class);
        InstanceManager.store(memo.getTurnoutManager(), TurnoutManager.class);
        InstanceManager.store(memo.getThrottleManager(), ThrottleManager.class);
        memo.register();
        tc.startTransmitThread();
        this.sinkThread = new Thread(tc);
        this.sinkThread.start();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"9,600 bps"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{9600};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

