/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo;

import javax.annotation.Nonnull;
import jmri.CommandStation;
import jmri.jmrix.zimo.Mx1Message;

public class Mx1CommandStation
implements CommandStation {
    String systemName;
    String userName;

    public Mx1CommandStation(String systemName, String userName) {
        this.systemName = systemName;
        this.userName = userName;
    }

    public Mx1CommandStation(String systemName) {
        this(systemName, "MX-1");
    }

    public Mx1CommandStation() {
        this("Z", "MX-1");
    }

    @Override
    public boolean sendPacket(@Nonnull byte[] packet, int repeats) {
        return false;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getSystemPrefix() {
        return this.systemName;
    }

    public Mx1Message resetModeMsg() {
        Mx1Message m = new Mx1Message(3);
        m.setElement(0, 83);
        m.setElement(1, 69);
        return m;
    }

    public Mx1Message getReadPagedCVMsg(int cv) {
        Mx1Message m = new Mx1Message(4);
        int cvhigh = (cv & 0xF0) / 16;
        int cvlow = cv & 0xF;
        m.setElement(0, 81);
        m.setElement(1, this.bcdToAsc(cvhigh));
        m.setElement(2, this.bcdToAsc(cvlow));
        return m;
    }

    public Mx1Message getWritePagedCVMsg(int cv, int val) {
        Mx1Message m = new Mx1Message(7);
        int cvHigh = (cv & 0xF0) / 16;
        int cvLow = cv & 0xF;
        int valHigh = (val & 0xF0) / 16;
        int valLow = val & 0xF;
        m.setElement(0, 82);
        m.setElement(1, 78);
        m.setElement(2, this.bcdToAsc(cvHigh));
        m.setElement(3, this.bcdToAsc(cvLow));
        m.setElement(4, this.bcdToAsc(valHigh));
        m.setElement(5, this.bcdToAsc(valLow));
        return m;
    }

    public int bcdToAsc(int hex) {
        switch (hex) {
            case 15: {
                return 70;
            }
            case 14: {
                return 101;
            }
            case 13: {
                return 68;
            }
            case 12: {
                return 67;
            }
            case 11: {
                return 66;
            }
            case 10: {
                return 65;
            }
            case 9: {
                return 57;
            }
            case 8: {
                return 56;
            }
            case 7: {
                return 55;
            }
            case 6: {
                return 54;
            }
            case 5: {
                return 53;
            }
            case 4: {
                return 52;
            }
            case 3: {
                return 51;
            }
            case 2: {
                return 50;
            }
            case 1: {
                return 49;
            }
        }
        return 48;
    }
}

