/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.zimo.Mx1Message;
import jmri.jmrix.zimo.Mx1Programmer;
import jmri.jmrix.zimo.Mx1TrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mx1OpsModeProgrammer
extends Mx1Programmer
implements AddressedProgrammer {
    int mAddress;
    boolean mLongAddr;
    private static final Logger log = LoggerFactory.getLogger(Mx1OpsModeProgrammer.class);

    public Mx1OpsModeProgrammer(int pAddress, boolean pLongAddr, Mx1TrafficController tc) {
        super(tc);
        this.mAddress = pAddress;
        this.mLongAddr = pLongAddr;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.OPSBYTEMODE);
        return ret;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 2;
        this._val = val;
        this._cv = CV;
        this.startShortTimer();
        if (this.getMode() == ProgrammingMode.OPSBYTEMODE) {
            if (!this.tc.getProtocol()) {
                throw new ProgrammerException();
            }
            this.tc.sendMx1Message(Mx1Message.getDecProgCmd(this.mAddress, this._cv, val, true), this);
        }
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("read CV={}", (Object)CV);
        log.error("readCV not available in this protocol");
        throw new ProgrammerException();
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        log.debug("confirm CV={}", (Object)CV);
        log.error("confirmCV not available in this protocol");
        throw new ProgrammerException();
    }

    @Override
    public boolean getCanRead() {
        return false;
    }

    @Override
    public boolean getLongAddress() {
        return this.mLongAddr;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }
}

