/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;
import jmri.jmrix.zimo.Mx1CommandStation;
import jmri.jmrix.zimo.Mx1Listener;
import jmri.jmrix.zimo.Mx1Message;
import jmri.jmrix.zimo.Mx1PortController;
import jmri.jmrix.zimo.Mx1TrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mx1Packetizer
extends Mx1TrafficController {
    LinkedList<byte[]> xmtList = new LinkedList();
    ConcurrentHashMap<Integer, MessageQueued> xmtPackets = new ConcurrentHashMap(16, 0.9f, 1);
    XmtHandler xmtHandler = new XmtHandler();
    RetryHandler retryHandler = new RetryHandler(this);
    RcvHandler rcvHandler = new RcvHandler(this);
    private Mx1PortController controller = null;
    DataInputStream istream = null;
    OutputStream ostream = null;
    private byte[] rcvBuffer = new byte[1];
    byte lastSequence = 0;
    static final int SOH = 1;
    static final int EOT = 23;
    static final int DLE = 16;
    final int[] crc8bit_table = new int[]{0, 94, 188, 226, 97, 63, 221, 131, 194, 156, 126, 32, 163, 253, 31, 65, 157, 195, 33, 127, 252, 162, 64, 30, 95, 1, 227, 189, 62, 96, 130, 220, 35, 125, 159, 193, 66, 28, 254, 160, 225, 191, 93, 3, 128, 222, 60, 98, 190, 224, 2, 92, 223, 129, 99, 61, 124, 34, 192, 158, 29, 67, 161, 255, 70, 24, 250, 164, 39, 121, 155, 197, 132, 218, 56, 102, 229, 187, 89, 7, 219, 133, 103, 57, 186, 228, 6, 88, 25, 71, 165, 251, 120, 38, 196, 154, 101, 59, 217, 135, 4, 90, 184, 230, 167, 249, 27, 69, 198, 152, 122, 36, 248, 166, 68, 26, 153, 199, 37, 123, 58, 100, 134, 216, 91, 5, 231, 185, 140, 210, 48, 110, 237, 179, 81, 15, 78, 16, 242, 172, 47, 113, 147, 205, 17, 79, 173, 243, 112, 46, 204, 146, 211, 141, 111, 49, 178, 236, 14, 80, 175, 241, 19, 77, 206, 144, 114, 44, 109, 51, 209, 143, 12, 82, 176, 238, 50, 108, 142, 208, 83, 13, 239, 177, 240, 174, 76, 18, 145, 207, 45, 115, 202, 148, 118, 40, 171, 245, 23, 73, 8, 86, 180, 234, 105, 55, 213, 139, 87, 9, 235, 181, 54, 104, 138, 212, 149, 203, 41, 119, 244, 170, 72, 22, 233, 183, 85, 11, 136, 214, 52, 106, 43, 117, 151, 201, 74, 20, 246, 168, 116, 42, 200, 150, 21, 75, 169, 247, 182, 232, 10, 84, 215, 137, 107, 53};
    private static final Logger log = LoggerFactory.getLogger(Mx1Packetizer.class);

    public Mx1Packetizer(Mx1CommandStation pCommandStation, boolean prot) {
        super(pCommandStation, prot);
        this.protocol = prot;
    }

    @Override
    public boolean status() {
        return this.ostream != null && this.istream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMx1Message(Mx1Message m, Mx1Listener reply) {
        byte[] msg;
        if (this.protocol) {
            this.processPacketForSending(m);
            msg = m.getRawPacket();
            if (m.replyL1Expected()) {
                this.xmtPackets.put(m.getSequenceNo(), new MessageQueued(m, reply));
            }
        } else {
            int len = m.getNumDataElements();
            m.setElement(len - 1, 13);
            msg = new byte[len];
            for (int i = 0; i < len; ++i) {
                msg[i] = (byte)m.getElement(i);
            }
            if (log.isDebugEnabled()) {
                log.debug("queue outgoing packet: {}", (Object)m.toString());
            }
        }
        this.notifyLater(m, reply);
        XmtHandler xmtHandler = this.xmtHandler;
        synchronized (xmtHandler) {
            this.xmtList.addLast(msg);
            this.xmtHandler.notify();
        }
    }

    byte getNextSequenceNo() {
        this.lastSequence = (byte)(this.lastSequence + 1);
        if ((this.lastSequence & 0xFF) == 255) {
            this.lastSequence = 0;
        }
        return this.lastSequence;
    }

    void processPacketForSending(Mx1Message m) {
        ArrayList<Byte> msgFormat = new ArrayList<Byte>();
        msgFormat.add((byte)1);
        msgFormat.add((byte)1);
        m.setSequenceNo(this.getNextSequenceNo());
        for (int i = 0; i < m.getNumDataElements(); ++i) {
            this.formatByteToPacket((byte)m.getElement(i), msgFormat);
        }
        if (m.getLongMessage()) {
            int crc = this.get16BitCRC(m);
            this.formatByteToPacket((byte)(crc >>> 8 & 0xFF), msgFormat);
            this.formatByteToPacket((byte)(crc & 0xFF), msgFormat);
        } else {
            byte checksum = this.get8BitCRC(m);
            this.formatByteToPacket(checksum, msgFormat);
        }
        msgFormat.add((byte)23);
        byte[] msg = new byte[msgFormat.size()];
        for (int i = 0; i < msgFormat.size(); ++i) {
            msg[i] = msgFormat.get(i);
        }
        m.setRawPacket(msg);
        m.setTimeStamp(System.currentTimeMillis());
    }

    void formatByteToPacket(byte b, ArrayList<Byte> message) {
        if ((b = (byte)(b & 0xFF)) == 1 || b == 23 || b == 16) {
            message.add((byte)16);
            message.add((byte)(b ^ 0x20));
        } else {
            message.add((byte)(b & 0xFF));
        }
    }

    public void connectPort(Mx1PortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.controller = p;
    }

    public void disconnectPort(Mx1PortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected Mx1PortController");
        }
        this.controller = null;
    }

    protected byte readByteProtected(DataInputStream istream) throws IOException {
        int nchars;
        while ((nchars = istream.read(this.rcvBuffer, 0, 1)) <= 0) {
        }
        return this.rcvBuffer[0];
    }

    void notifyLater(Mx1Message m, Mx1Listener reply) {
        final Mx1Message thisMsg = m;
        final Mx1Packetizer thisTc = this;
        final Mx1Listener thisLst = reply;
        Runnable r = new Runnable(){
            Mx1Message msgForLater;
            Mx1Packetizer myTc;
            Mx1Listener myListener;
            {
                this.msgForLater = thisMsg;
                this.myTc = thisTc;
                this.myListener = thisLst;
            }

            @Override
            public void run() {
                this.myTc.notify(this.msgForLater, this.myListener);
            }
        };
        log.debug("schedule notify of incoming packet");
        SwingUtilities.invokeLater(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void isAckReplyRequired(Mx1Message m) {
        if (m.isCRCError()) {
            Mx1Message nack = new Mx1Message(3, true);
            nack.setElement(1, 16);
            nack.setElement(2, 0);
            this.processPacketForSending(nack);
            byte[] msg = nack.getRawPacket();
            this.notify(nack, null);
            XmtHandler xmtHandler = this.xmtHandler;
            synchronized (xmtHandler) {
                this.xmtList.addFirst(msg);
                this.xmtHandler.notify();
            }
            return;
        }
        if ((m.getElement(1) & 0x80) != 128) {
            if ((m.getElement(1) & 0x40) == 64 || (m.getElement(1) & 0x60) == 96) {
                return;
            }
            if ((m.getElement(2) & 0x13) == 19) {
                this.l1AckPacket(m);
            } else if ((m.getElement(1) & 0x20) == 32) {
                this.l2AckPacket(m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void l1AckPacket(Mx1Message m) {
        Mx1Message ack = new Mx1Message(5, true);
        ack.setElement(1, 80);
        ack.setElement(2, m.getElement(2) & 0xFF);
        ack.setElement(3, m.getElement(0) & 0xFF);
        this.processPacketForSending(ack);
        byte[] msg = ack.getRawPacket();
        this.notify(ack, null);
        XmtHandler xmtHandler = this.xmtHandler;
        synchronized (xmtHandler) {
            this.xmtList.addFirst(msg);
            this.xmtHandler.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void l2AckPacket(Mx1Message m) {
        Mx1Message ack = new Mx1Message(5, true);
        ack.setElement(1, 112);
        ack.setElement(2, m.getElement(2) & 0xFF);
        ack.setElement(3, m.getElement(0) & 0xFF);
        this.processPacketForSending(ack);
        byte[] msg = ack.getRawPacket();
        this.notify(ack, null);
        XmtHandler xmtHandler = this.xmtHandler;
        synchronized (xmtHandler) {
            this.xmtList.addFirst(msg);
            this.xmtHandler.notify();
        }
    }

    public void startThreads() {
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available = 10 default = 5 min available = 1", (Object)priority);
        Thread retryThread = new Thread((Runnable)this.retryHandler, "MX1 retry handler");
        retryThread.start();
        int xmtpriority = 9 > priority ? 9 : 10;
        Thread xmtThread = new Thread((Runnable)this.xmtHandler, "MX1 transmit handler");
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        xmtThread.setPriority(9);
        xmtThread.start();
        Thread rcvThread = new Thread((Runnable)this.rcvHandler, "MX1 receive handler");
        rcvThread.setPriority(10);
        rcvThread.start();
    }

    public int get16BitCRC(Mx1Message m) {
        int POLYNOMIAL = 33800;
        int PRESET_VALUE = 0;
        byte[] array = new byte[m.getNumDataElements()];
        for (int i = 0; i < m.getNumDataElements(); ++i) {
            array[i] = (byte)m.getElement(i);
        }
        int current_crc_value = PRESET_VALUE;
        for (int i = 0; i < array.length; ++i) {
            current_crc_value ^= array[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((current_crc_value & 1) != 0) {
                    current_crc_value = current_crc_value >>> 1 ^ POLYNOMIAL;
                    continue;
                }
                current_crc_value >>>= 1;
            }
        }
        return current_crc_value & 0xFFFF;
    }

    byte get8BitCRC(Mx1Message m) {
        int checksum = 255;
        for (int i = 0; i < m.getNumDataElements(); ++i) {
            checksum = this.crc8bit_table[checksum ^ m.getElement(i) & 0xFF];
        }
        return (byte)(checksum & 0xFF);
    }

    static class MessageQueued {
        Mx1Message msg;
        Mx1Listener reply;

        MessageQueued(Mx1Message m, Mx1Listener r) {
            this.msg = m;
            this.reply = r;
        }

        Mx1Message getMessage() {
            return this.msg;
        }

        Mx1Listener getListener() {
            return this.reply;
        }
    }

    class RetryHandler
    implements Runnable {
        Mx1Packetizer trafficController;

        public RetryHandler(Mx1Packetizer lt) {
            this.trafficController = lt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="false postive, guarded by if statement")
        public void run() {
            while (true) {
                if (Mx1Packetizer.this.xmtPackets.isEmpty()) {
                    try {
                        RetryHandler retryHandler = this;
                        synchronized (retryHandler) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException ei) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                Object ei = ((ConcurrentHashMap.KeySetView)Mx1Packetizer.this.xmtPackets.keySet()).iterator();
                while (ei.hasNext()) {
                    int key = (Integer)ei.next();
                    MessageQueued mq = Mx1Packetizer.this.xmtPackets.get(key);
                    Mx1Message m = mq.getMessage();
                    if (m.getRetry() <= 0) {
                        Mx1Packetizer.this.xmtPackets.remove(key);
                        continue;
                    }
                    if (m.getTimeStamp() + 200L >= System.currentTimeMillis()) break;
                    m.setRetries(m.getRetry() - 1);
                    m.setTimeStamp(System.currentTimeMillis());
                    this.trafficController.notify(m, mq.getListener());
                    XmtHandler xmtHandler = Mx1Packetizer.this.xmtHandler;
                    synchronized (xmtHandler) {
                        log.warn("Packet not replied to so will retry");
                        Mx1Packetizer.this.xmtList.addFirst(m.getRawPacket());
                        Mx1Packetizer.this.xmtHandler.notify();
                    }
                }
                if (Mx1Packetizer.this.xmtPackets.isEmpty()) continue;
                try {
                    ei = this;
                    synchronized (ei) {
                        this.wait(200L);
                        continue;
                    }
                }
                catch (InterruptedException ei2) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="while loop controls access")
    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: while (true) {
                try {
                    while (true) {
                        log.debug("check for input");
                        byte[] msg = null;
                        Runnable runnable = this;
                        synchronized (runnable) {
                            msg = Mx1Packetizer.this.xmtList.removeFirst();
                        }
                        try {
                            if (Mx1Packetizer.this.ostream != null) {
                                log.debug("start write to stream");
                                Mx1Packetizer.this.ostream.write(msg);
                                Mx1Packetizer.this.ostream.flush();
                                if (Mx1Packetizer.this.protocol) {
                                    runnable = Mx1Packetizer.this.retryHandler;
                                    synchronized (runnable) {
                                        Mx1Packetizer.this.retryHandler.notify();
                                    }
                                }
                                log.debug("end write to stream");
                                continue block15;
                            }
                            log.warn("send message: no connection established");
                            continue block15;
                        }
                        catch (IOException e2) {
                            log.warn("send message: IOException: {}", (Object)e2.toString());
                            continue;
                        }
                        break;
                    }
                }
                catch (NoSuchElementException e) {
                    log.debug("start wait");
                    try {
                        XmtHandler e2 = this;
                        synchronized (e2) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException ei) {
                        Thread.currentThread().interrupt();
                    }
                    log.debug("end wait");
                    continue;
                }
                break;
            }
        }
    }

    class RcvHandler
    implements Runnable {
        Mx1Packetizer trafficController;

        public RcvHandler(Mx1Packetizer lt) {
            this.trafficController = lt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (Mx1Packetizer.this.protocol) {
                while (true) {
                    try {
                        while (true) {
                            int i;
                            Mx1Message msg;
                            int b22;
                            int firstByte = Mx1Packetizer.this.readByteProtected(Mx1Packetizer.this.istream) & 0xFF;
                            int secondByte = Mx1Packetizer.this.readByteProtected(Mx1Packetizer.this.istream) & 0xFF;
                            while (firstByte != 1 && secondByte != 1) {
                                log.debug("Skipping: {} {}", (Object)Integer.toHexString(firstByte), (Object)Integer.toHexString(secondByte));
                                firstByte = secondByte;
                                secondByte = Mx1Packetizer.this.readByteProtected(Mx1Packetizer.this.istream) & 0xFF;
                            }
                            ArrayList<Integer> message = new ArrayList<Integer>();
                            while ((b22 = Mx1Packetizer.this.readByteProtected(Mx1Packetizer.this.istream) & 0xFF) != 23) {
                                if (b22 == 16) {
                                    b22 = Mx1Packetizer.this.readByteProtected(Mx1Packetizer.this.istream) & 0xFF;
                                    b22 ^= 0x20;
                                }
                                message.add(b22);
                                log.debug("char is: {}", (Object)Integer.toHexString(b22));
                            }
                            RcvHandler b22 = Mx1Packetizer.this.rcvHandler;
                            synchronized (b22) {
                                Mx1Packetizer.this.xmtPackets.remove(message.get(3));
                            }
                            if (((Integer)message.get(1) & 0x80) == 128) {
                                msg = new Mx1Message(message.size() - 2, true);
                                for (i = 0; i < message.size() - 2; ++i) {
                                    msg.setElement(i, (Integer)message.get(i));
                                }
                            } else {
                                msg = new Mx1Message(message.size() - 1, true);
                                for (i = 0; i < message.size() - 1; ++i) {
                                    msg.setElement(i, (Integer)message.get(i));
                                }
                                if ((Integer)message.get(message.size() - 1) != (Mx1Packetizer.this.get8BitCRC(msg) & 0xFF)) {
                                    log.error("Message with invalid CRC received Expecting:{} found:{}", (Object)(Mx1Packetizer.this.get8BitCRC(msg) & 0xFF), message.get(message.size() - 1));
                                    msg.setCRCError();
                                } else {
                                    Mx1Packetizer.this.xmtPackets.remove(message.get(3));
                                }
                            }
                            Mx1Packetizer.this.isAckReplyRequired(msg);
                            final Mx1Message thisMsg = msg;
                            final Mx1Packetizer thisTc = this.trafficController;
                            Runnable r = new Runnable(){
                                Mx1Message msgForLater;
                                Mx1Packetizer myTc;
                                {
                                    this.msgForLater = thisMsg;
                                    this.myTc = thisTc;
                                }

                                @Override
                                public void run() {
                                    this.myTc.notify(this.msgForLater, null);
                                }
                            };
                            log.debug("schedule notify of incoming packet");
                            SwingUtilities.invokeLater(r);
                        }
                    }
                    catch (IOException e) {
                        log.debug("IOException, should only happen with HexFIle", (Throwable)e);
                        Mx1Packetizer.this.disconnectPort(Mx1Packetizer.this.controller);
                        return;
                    }
                    catch (RuntimeException e) {
                        log.warn("run: unexpected exception:", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            while (true) {
                try {
                    while (true) {
                        int opCode = Mx1Packetizer.this.istream.readByte() & 0xFF;
                        log.debug("RcvHandler: Start message with opcode: {}", (Object)Integer.toHexString(opCode));
                        int len = 1;
                        Mx1Message msgn = new Mx1Message(15);
                        msgn.setElement(0, opCode);
                        for (int i = 1; i < 15; ++i) {
                            int b = Mx1Packetizer.this.istream.readByte() & 0xFF;
                            ++len;
                            if (b == 13 || b == 10) {
                                msgn.setElement(i, b);
                                break;
                            }
                            msgn.setElement(i, b);
                        }
                        Mx1Message msg = new Mx1Message(len);
                        for (int i = 0; i < len; ++i) {
                            msg.setElement(i, msgn.getElement(i) & 0xFF);
                        }
                        final Mx1Message thisMsg = msg;
                        final Mx1Packetizer thisTc = this.trafficController;
                        Runnable r = new Runnable(){
                            Mx1Message msgForLater;
                            Mx1Packetizer myTc;
                            {
                                this.msgForLater = thisMsg;
                                this.myTc = thisTc;
                            }

                            @Override
                            public void run() {
                                this.myTc.notify(this.msgForLater, null);
                            }
                        };
                        log.debug("schedule notify of incoming packet");
                        SwingUtilities.invokeLater(r);
                    }
                }
                catch (EOFException e) {
                    log.debug("EOFException, is serial I/O using timeouts?");
                    continue;
                }
                catch (IOException e) {
                    log.debug("IOException, should only happen with HexFile", (Throwable)e);
                    Mx1Packetizer.this.disconnectPort(Mx1Packetizer.this.controller);
                    return;
                }
                catch (RuntimeException e) {
                    log.warn("run: unexpected exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

