/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo;

import jmri.JmriException;
import jmri.jmrix.zimo.Mx1Listener;
import jmri.jmrix.zimo.Mx1Message;
import jmri.jmrix.zimo.Mx1SystemConnectionMemo;
import jmri.jmrix.zimo.Mx1TrafficController;
import jmri.managers.AbstractPowerManager;

public class Mx1PowerManager
extends AbstractPowerManager<Mx1SystemConnectionMemo>
implements Mx1Listener {
    Mx1TrafficController tc = null;

    public Mx1PowerManager(Mx1SystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getMx1TrafficController();
        this.tc.addMx1Listener(-1, this);
    }

    @Override
    public void setPower(int v) throws JmriException {
        int old = this.power;
        this.power = 1;
        if (!this.tc.getProtocol()) {
            Mx1Message m;
            this.checkTC();
            if (v == 2) {
                m = new Mx1Message(3);
                m.setElement(0, 83);
                m.setElement(1, 69);
                this.tc.sendMx1Message(m, this);
            } else if (v == 4) {
                m = new Mx1Message(3);
                m.setElement(0, 83);
                m.setElement(1, 65);
                this.tc.sendMx1Message(m, this);
            }
            m = new Mx1Message(2);
            m.setElement(0, 90);
            this.tc.sendMx1Message(m, this);
        } else {
            if (v == 2) {
                this.tc.sendMx1Message(Mx1Message.setPowerOn(), this);
            } else if (v == 4) {
                this.tc.sendMx1Message(Mx1Message.setPowerOff(), this);
            }
            if (((Mx1SystemConnectionMemo)this.memo).getConnectionType() == 1) {
                this.power = v;
            } else {
                this.tc.sendMx1Message(Mx1Message.getTrackStatus(), this);
            }
        }
        this.firePowerPropertyChange(old, this.power);
    }

    @Override
    public void dispose() throws JmriException {
        this.tc.removeMx1Listener(-1, this);
        this.tc = null;
    }

    private void checkTC() throws JmriException {
        if (this.tc == null) {
            throw new JmriException("attempt to use PowerManager after dispose");
        }
    }

    @Override
    public void message(Mx1Message m) {
        if (!this.tc.getProtocol()) {
            int old = this.power;
            if (m.getElement(0) == 90) {
                this.power = (m.getElement(2) & 2) == 2 ? 2 : 4;
            } else if (m.getMessageType() == 64 && m.getPrimaryMessage() == 2) {
                this.power = (m.getElement(4) & 2) == 2 ? 4 : 2;
            }
            this.firePowerPropertyChange(old, this.power);
        }
    }
}

