/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammer;
import jmri.jmrix.zimo.Mx1Listener;
import jmri.jmrix.zimo.Mx1Message;
import jmri.jmrix.zimo.Mx1TrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mx1Programmer
extends AbstractProgrammer
implements Mx1Listener {
    protected Mx1TrafficController tc;
    int progState = 0;
    boolean firstTime = true;
    static final int NOTPROGRAMMING = 0;
    static final int INQUIRESENT = 2;
    boolean _progRead = false;
    int _val;
    int _cv;
    private ProgListener _usingProgrammer = null;
    private static final Logger log = LoggerFactory.getLogger(Mx1Programmer.class);

    protected Mx1Programmer(Mx1TrafficController _tc) {
        this.tc = _tc;
        this.SHORT_TIMEOUT = 4000;
        log.info("Mx1TrafficController: {}", (Object)this.tc);
        if (this.tc != null) {
            this.tc.addMx1Listener(-1, this);
        }
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.PAGEMODE);
        return ret;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 2;
        this._val = val;
        this._cv = CV;
        this.startShortTimer();
        if (this.getMode() == ProgrammingMode.PAGEMODE) {
            if (!this.tc.getProtocol()) {
                if (this.firstTime) {
                    this.tc.sendMx1Message(this.tc.getCommandStation().resetModeMsg(), this);
                    this.firstTime = false;
                }
                this.tc.sendMx1Message(this.tc.getCommandStation().getWritePagedCVMsg(CV, val), this);
            } else {
                this.tc.sendMx1Message(Mx1Message.getDecProgCmd(0, this._cv, val, true), this);
            }
        }
    }

    @Override
    public void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (log.isDebugEnabled()) {
            log.debug("readCV {} listens {}", (Object)CV, (Object)p);
        }
        this.useProgrammer(p);
        this._progRead = true;
        this.progState = 2;
        this._cv = CV;
        this.startShortTimer();
        if (this.getMode() == ProgrammingMode.PAGEMODE) {
            if (!this.tc.getProtocol()) {
                if (this.firstTime) {
                    this.tc.sendMx1Message(this.tc.getCommandStation().resetModeMsg(), this);
                    this.firstTime = false;
                }
                this.tc.sendMx1Message(this.tc.getCommandStation().getReadPagedCVMsg(CV), this);
            } else {
                this.tc.sendMx1Message(Mx1Message.getDecProgCmd(0, this._cv, -1, true), this);
            }
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isInfoEnabled()) {
                log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    @Override
    public synchronized void message(Mx1Message m) {
        if (this.progState == 0) {
            return;
        }
        if (this.progState == 2) {
            if (log.isDebugEnabled()) {
                log.debug("reply in INQUIRESENT state");
            }
            if (!this.tc.getProtocol()) {
                if (m.getElement(0) == 81 && m.getElement(1) == 78 && m.getElement(2) == 48 && m.getElement(3) == 48) {
                    if (this._progRead) {
                        int highVal = this.ascToBcd(m.getElement(6));
                        highVal = highVal * 16 & 0xF0;
                        int lowVal = this.ascToBcd(m.getElement(7));
                        this._val = highVal | lowVal;
                    }
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 0);
                    this.tc.sendMx1Message(this.tc.getCommandStation().resetModeMsg(), this);
                    return;
                }
                this.progState = 0;
                this.stopTimer();
                this.tc.sendMx1Message(this.tc.getCommandStation().resetModeMsg(), this);
                this.notifyProgListenerEnd(this._val, 2);
                return;
            }
            if (m.getPrimaryMessage() == 19 && m.getMessageType() == 32) {
                if (this._progRead) {
                    this._val = m.getCvValue();
                }
                this.progState = 0;
                this.stopTimer();
                this.notifyProgListenerEnd(this._val, 0);
                return;
            }
        }
    }

    @Override
    protected synchronized void timeout() {
        if (this.progState != 0) {
            if (log.isDebugEnabled()) {
                log.debug("timeout!");
            }
            this.progState = 0;
            if (!this.tc.getProtocol()) {
                this.tc.sendMx1Message(this.tc.getCommandStation().resetModeMsg(), this);
            }
            this.notifyProgListenerEnd(this._val, 128);
        }
    }

    protected void notifyProgListenerEnd(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        }
        ProgListener temp = this._usingProgrammer;
        this._usingProgrammer = null;
        this.notifyProgListenerEnd(temp, value, status);
    }

    public int ascToBcd(int hex) {
        switch (hex) {
            case 70: {
                return 15;
            }
            case 69: {
                return 14;
            }
            case 101: {
                return 14;
            }
            case 68: {
                return 13;
            }
            case 67: {
                return 12;
            }
            case 66: {
                return 11;
            }
            case 65: {
                return 10;
            }
            case 57: {
                return 9;
            }
            case 56: {
                return 8;
            }
            case 55: {
                return 7;
            }
            case 54: {
                return 6;
            }
            case 53: {
                return 5;
            }
            case 52: {
                return 4;
            }
            case 51: {
                return 3;
            }
            case 50: {
                return 2;
            }
            case 49: {
                return 1;
            }
        }
        return 0;
    }
}

