/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo;

import java.util.EnumSet;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.zimo.Mx1SystemConnectionMemo;
import jmri.jmrix.zimo.Mx1Throttle;
import jmri.jmrix.zimo.Mx1TrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mx1ThrottleManager
extends AbstractThrottleManager {
    Mx1TrafficController tc = null;
    String prefix = "";
    private static final Logger log = LoggerFactory.getLogger(Mx1ThrottleManager.class);

    public Mx1ThrottleManager(Mx1SystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getMx1TrafficController();
        this.prefix = memo.getSystemPrefix();
    }

    @Override
    public void requestThrottleSetup(LocoAddress a, boolean control) {
        if (a instanceof DccLocoAddress) {
            DccLocoAddress address = (DccLocoAddress)a;
            log.debug("new Mx1Throttle for {}", (Object)address);
            this.notifyThrottleKnown(new Mx1Throttle((Mx1SystemConnectionMemo)this.adapterMemo, address), address);
        } else {
            log.error("{} is not a DccLocoAddress", (Object)a);
            this.failedThrottleRequest(a, "LocoAddress " + a + " is not a DccLocoAddress");
        }
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return address >= 0 && address <= 10239;
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return address >= 1 && address <= 127;
    }

    @Override
    public boolean addressTypeUnique() {
        return false;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28);
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l) && t instanceof Mx1Throttle) {
            Mx1Throttle nct = (Mx1Throttle)t;
            nct.throttleDispose();
            return true;
        }
        return false;
    }
}

