/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo.mx1;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.zimo.Mx1CommandStation;
import jmri.jmrix.zimo.Mx1Packetizer;
import jmri.jmrix.zimo.Mx1PortController;
import jmri.jmrix.zimo.Mx1SystemConnectionMemo;
import jmri.jmrix.zimo.mx1.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mx1Adapter
extends Mx1PortController {
    protected String[] validSpeeds = new String[]{Bundle.getMessage("Baud1200"), Bundle.getMessage("Baud2400"), Bundle.getMessage("Baud4800"), Bundle.getMessage("Baud9600"), Bundle.getMessage("Baud19200"), Bundle.getMessage("Baud38400")};
    protected int[] validSpeedValues = new int[]{1200, 2400, 4800, 9600, 19200, 38400};
    protected String[] validOption1 = new String[]{Bundle.getMessage("FlowOptionHwRecomm"), Bundle.getMessage("FlowOptionNo")};
    protected String[] validOption2 = new String[]{"3", "5"};
    private static final Logger log = LoggerFactory.getLogger(Mx1Adapter.class);

    public Mx1Adapter() {
        super(new Mx1SystemConnectionMemo());
        this.option1Name = "FlowControl";
        this.options.put(this.option1Name, new AbstractPortController.Option("MX-1 connection uses : ", this.validOption1));
        this.manufacturerName = "Zimo";
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("failed to connect ZIMO MX1 to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting ZIMO MX1 to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        AbstractSerialPortController.FlowControl flow = AbstractSerialPortController.FlowControl.RTSCTS;
        if (this.getOptionState(this.option1Name).equals(this.validOption1[1])) {
            flow = AbstractSerialPortController.FlowControl.NONE;
        }
        this.setFlowControl(this.currentSerialPort, flow);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public boolean okToSend() {
        return this.currentSerialPort.getCTS();
    }

    @Override
    public void configure() {
        Mx1CommandStation cs = new Mx1CommandStation(this.getSystemConnectionMemo().getSystemPrefix(), this.getSystemConnectionMemo().getUserName());
        Mx1Packetizer packets = new Mx1Packetizer(cs, false);
        packets.connectPort(this);
        this.getSystemConnectionMemo().setMx1TrafficController(packets);
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

