/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.zimo.swing.packetgen;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrix.zimo.Mx1Message;
import jmri.jmrix.zimo.Mx1SystemConnectionMemo;
import jmri.jmrix.zimo.Mx1TrafficController;
import jmri.jmrix.zimo.swing.Mx1NamedPaneAction;
import jmri.jmrix.zimo.swing.Mx1Panel;
import jmri.jmrix.zimo.swing.packetgen.Bundle;
import jmri.util.StringUtil;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class Mx1PacketGenPanel
extends Mx1Panel {
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(20);
    private Mx1TrafficController tc = null;

    @Override
    public void initContext(Object context) {
        if (context instanceof Mx1SystemConnectionMemo) {
            this.initComponents((Mx1SystemConnectionMemo)context);
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.zimo.swing.packetgen.Mx1PacketGenPanel";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("MX1_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("Title"));
        return x.toString();
    }

    @Override
    public void initComponents(Mx1SystemConnectionMemo m) {
        this.memo = m;
        this.tc = m.getMx1TrafficController();
        this.jLabel1.setText("Command: ");
        this.jLabel1.setVisible(true);
        this.sendButton.setText("Send");
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText("Send packet");
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText("Enter command");
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.jLabel1);
        this.add(this.packetTextField);
        this.add(this.sendButton);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mx1PacketGenPanel.this.sendButtonActionPerformed(e);
            }
        });
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        this.tc.sendMx1Message(this.createPacket(input), null);
    }

    Mx1Message createPacket(String s) {
        byte[] b;
        try {
            b = StringUtil.bytesFromHexString(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (b.length == 0) {
            return null;
        }
        Mx1Message m = new Mx1Message(b.length);
        for (int i = 0; i < b.length; ++i) {
            m.setElement(i, b[i] & 0xFF);
        }
        return m;
    }

    public static class Default
    extends Mx1NamedPaneAction {
        public Default() {
            super("Open MRC Send Binary Command", new JmriJFrameInterface(), Mx1PacketGenPanel.class.getName(), InstanceManager.getDefault(Mx1SystemConnectionMemo.class));
        }
    }
}

