/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.util.Objects;
import javax.annotation.Nonnull;
import jmri.Audio;
import jmri.AudioException;
import jmri.AudioManager;
import jmri.SystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAudioManager
extends AbstractManager<Audio>
implements AudioManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractAudioManager.class);

    public AbstractAudioManager(SystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public char typeLetter() {
        return 'A';
    }

    @Override
    @Nonnull
    public Audio provideAudio(@Nonnull String name) throws AudioException {
        Audio a = this.getAudio(name);
        if (a != null) {
            return a;
        }
        if (name.startsWith(this.getSystemPrefix() + this.typeLetter())) {
            return this.newAudio(name, null);
        }
        return this.newAudio(this.makeSystemName(name), null);
    }

    @Override
    public Audio getAudio(@Nonnull String name) {
        Audio a = this.getByUserName(name);
        if (a != null) {
            return a;
        }
        return this.getBySystemName(name);
    }

    @Override
    public Audio getBySystemName(@Nonnull String key) {
        return (Audio)this._tsys.get(key);
    }

    @Override
    public Audio getByUserName(@Nonnull String key) {
        if (key == null) {
            return null;
        }
        Audio rv = (Audio)this._tuser.get(key);
        if (rv == null) {
            rv = this.getBySystemName(key);
        }
        return rv;
    }

    @Override
    @Nonnull
    public Audio newAudio(@Nonnull String systemName, String userName) throws AudioException {
        Audio s;
        Objects.requireNonNull(systemName, "SystemName cannot be null. UserName was " + (userName == null ? "null" : userName));
        log.debug("new Audio: {}; {}", (Object)systemName, (Object)userName);
        if (!(systemName.startsWith(this.getSystemPrefix() + this.typeLetter() + "B") || systemName.startsWith(this.getSystemPrefix() + this.typeLetter() + "S") || systemName.startsWith(this.getSystemPrefix() + this.typeLetter() + "L"))) {
            log.error("Invalid system name for Audio: {} needed either {}{}B or {}{}S or {}{}L", new Object[]{systemName, this.getSystemPrefix(), Character.valueOf(this.typeLetter()), this.getSystemPrefix(), Character.valueOf(this.typeLetter()), this.getSystemPrefix(), Character.valueOf(this.typeLetter())});
            throw new AudioException("Invalid system name for Audio: " + systemName + " needed either " + this.getSystemPrefix() + this.typeLetter() + "B or " + this.getSystemPrefix() + this.typeLetter() + "S or " + this.getSystemPrefix() + this.typeLetter() + "L");
        }
        if (userName != null && (s = this.getByUserName(userName)) != null) {
            if (this.getBySystemName(systemName) != s) {
                log.error("inconsistent user ({}) and system name ({}) results; userName related to ({})", new Object[]{userName, systemName, s.getSystemName()});
            }
            log.debug("Found existing Audio ({}). Returning existing (1).", (Object)s.getSystemName());
            return s;
        }
        s = this.getBySystemName(systemName);
        if (s != null) {
            if (s.getUserName() == null && userName != null) {
                s.setUserName(userName);
            } else if (userName != null) {
                log.warn("Found audio via system name ({}) with non-null user name ({})", (Object)systemName, (Object)userName);
            }
            log.debug("Found existing Audio ({}). Returning existing (2).", (Object)s.getSystemName());
            return s;
        }
        log.debug("Existing audio not found. Creating new. ({})", (Object)systemName);
        s = this.createNewAudio(systemName, userName);
        if (s == null) {
            throw new IllegalArgumentException("can't create audio with System Name \"" + systemName + "\"");
        }
        this.register(s);
        return s;
    }

    protected abstract Audio createNewAudio(@Nonnull String var1, String var2) throws AudioException;

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameAudios" : "BeanNameAudio");
    }

    @Override
    public Class<Audio> getNamedBeanClass() {
        return Audio.class;
    }
}

