/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.SortedSet;
import jmri.Block;
import jmri.BlockManager;
import jmri.CabSignal;
import jmri.CabSignalListListener;
import jmri.CabSignalManager;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.LocoAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCabSignalManager
implements CabSignalManager,
Disposable {
    protected HashMap<LocoAddress, CabSignal> signalList = new HashMap();
    protected ArrayList<CabSignalListListener> listListeners = new ArrayList();
    private final ArrayList<Block> _blocksWithListeners = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(AbstractCabSignalManager.class);

    public AbstractCabSignalManager() {
        InstanceManager.getDefault(BlockManager.class).addPropertyChangeListener("beans", this::handleBlockConfigChanged);
    }

    @Override
    public CabSignal getCabSignal(LocoAddress address) {
        if (this._blocksWithListeners.isEmpty()) {
            this.initBlocks();
        }
        if (!this.signalList.containsKey(address)) {
            this.signalList.put(address, this.createCabSignal(address));
            this.notifyCabSignalListChanged();
        }
        return this.signalList.get(address);
    }

    protected abstract CabSignal createCabSignal(LocoAddress var1);

    @Override
    public void delCabSignal(LocoAddress address) {
        if (this.signalList.containsKey(address)) {
            this.signalList.remove(address);
            this.notifyCabSignalListChanged();
        }
    }

    @Override
    public Set<LocoAddress> getCabSignalList() {
        return this.signalList.keySet();
    }

    @Override
    public CabSignal[] getCabSignalArray() {
        return this.signalList.values().toArray(new CabSignal[1]);
    }

    @Override
    public void addCabSignalListListener(CabSignalListListener listener) {
        if (!this.listListeners.contains(listener)) {
            this.listListeners.add(listener);
        }
    }

    @Override
    public void removeCabSignalListListener(CabSignalListListener listener) {
        if (this.listListeners.contains(listener)) {
            this.listListeners.remove(listener);
        }
    }

    @Override
    public void notifyCabSignalListChanged() {
        for (CabSignalListListener l : this.listListeners) {
            l.notifyCabSignalListChanged();
        }
    }

    private void initBlocks() {
        SortedSet blockSet = InstanceManager.getDefault(BlockManager.class).getNamedBeanSet();
        for (Block b : blockSet) {
            b.addPropertyChangeListener(this::handleBlockChange);
            this._blocksWithListeners.add(b);
        }
    }

    private void removeListenerFromBlocks() {
        for (Block b : this._blocksWithListeners) {
            b.removePropertyChangeListener(this::handleBlockChange);
        }
        this._blocksWithListeners.clear();
    }

    private void handleBlockChange(PropertyChangeEvent e) {
        log.debug("property {} new value {} old value {}", new Object[]{e.getPropertyName(), e.getNewValue(), e.getOldValue()});
        if (e.getPropertyName().equals("value") && e.getOldValue() == null && e.getNewValue() != null) {
            for (CabSignal c : this.signalList.values()) {
                if (c.getBlock() != null) continue;
                c.setBlock();
            }
        }
    }

    private void handleBlockConfigChanged(PropertyChangeEvent e) {
        log.debug("blocks changed in blockmanager {}", (Object)e);
        this.removeListenerFromBlocks();
        if (!this.signalList.isEmpty()) {
            this.initBlocks();
        }
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(BlockManager.class).removePropertyChangeListener("beans", this::handleBlockConfigChanged);
        for (CabSignal c : this.signalList.values()) {
            c.dispose();
        }
        this.removeListenerFromBlocks();
    }
}

