/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanPropertyDescriptor;
import jmri.SystemConnectionMemo;
import jmri.beans.VetoableChangeSupport;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManager<E extends NamedBean>
extends VetoableChangeSupport
implements Manager<E>,
PropertyChangeListener,
VetoableChangeListener {
    protected final SystemConnectionMemo memo;
    protected final TreeSet<E> _beans;
    protected final Hashtable<String, E> _tsys = new Hashtable();
    protected final Hashtable<String, E> _tuser = new Hashtable();
    protected final Map<String, Boolean> silencedProperties = new HashMap<String, Boolean>();
    protected final Set<String> silenceableProperties = new HashSet<String>();
    AtomicInteger lastAutoNamedBeanRef = new AtomicInteger(0);
    DecimalFormat paddedNumber = new DecimalFormat("0000");
    private final List<Manager.ManagerDataListener<E>> listeners = new ArrayList<Manager.ManagerDataListener<E>>();
    private boolean muted = false;
    private static final Logger log = LoggerFactory.getLogger(AbstractManager.class);

    public AbstractManager(SystemConnectionMemo memo) {
        this.memo = memo;
        this._beans = new TreeSet(memo.getNamedBeanComparator(this.getNamedBeanClass()));
        this.silenceableProperties.add("beans");
        this.setRegisterSelf();
    }

    final void setRegisterSelf() {
        this.registerSelf();
    }

    public AbstractManager() {
        this(InstanceManager.getDefault(InternalSystemConnectionMemo.class));
    }

    @OverridingMethodsMustInvokeSuper
    protected void registerSelf() {
        log.debug("registerSelf for config of type {}", this.getClass());
        InstanceManager.getOptionalDefault(ConfigureManager.class).ifPresent(cm -> {
            cm.registerConfig(this, this.getXMLOrder());
            log.debug("registering for config of type {}", this.getClass());
        });
    }

    @Override
    @Nonnull
    public SystemConnectionMemo getMemo() {
        return this.memo;
    }

    @Override
    @Nonnull
    public String makeSystemName(@Nonnull String s, boolean logErrors, Locale locale) {
        try {
            return Manager.super.makeSystemName(s, logErrors, locale);
        }
        catch (IllegalArgumentException ex) {
            if (logErrors || log.isTraceEnabled()) {
                log.error("Invalid system name for {}: {}", (Object)this.getBeanTypeHandled(), (Object)ex.getMessage());
            }
            throw ex;
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void dispose() {
        InstanceManager.getOptionalDefault(ConfigureManager.class).ifPresent(cm -> cm.deregister(this));
        this._beans.clear();
        this._tsys.clear();
        this._tuser.clear();
    }

    @Override
    @CheckForNull
    public E getBySystemName(@Nonnull String systemName) {
        return (E)((NamedBean)this._tsys.get(systemName));
    }

    @CheckForNull
    protected E getBySystemName(String systemName, Comparator<String> comparator) {
        for (Map.Entry<String, E> e : this._tsys.entrySet()) {
            if (0 != comparator.compare(e.getKey(), systemName)) continue;
            return (E)((NamedBean)e.getValue());
        }
        return null;
    }

    @Override
    @CheckForNull
    public E getByUserName(@Nonnull String userName) {
        String normalizedUserName = NamedBean.normalizeUserName(userName);
        return (E)(normalizedUserName != null ? (NamedBean)this._tuser.get(normalizedUserName) : null);
    }

    @Override
    @CheckForNull
    public E getNamedBean(@Nonnull String name) {
        E b;
        String normalizedUserName = NamedBean.normalizeUserName(name);
        if (normalizedUserName != null && (b = this.getByUserName(normalizedUserName)) != null) {
            return b;
        }
        return this.getBySystemName(name);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void deleteBean(@Nonnull E bean, @Nonnull String property) throws PropertyVetoException {
        this.fireVetoableChange(property, bean, null);
        if ("DoDelete".equals(property)) {
            this.deregister(bean);
            bean.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @OverridingMethodsMustInvokeSuper
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="String already built for use in exception text")
    public void register(@Nonnull E s) {
        String systemName = s.getSystemName();
        E existingBean = this.getBySystemName(systemName);
        if (existingBean != null) {
            if (s != existingBean) {
                log.error("systemName is already registered: {}", (Object)systemName);
                throw new NamedBean.DuplicateSystemNameException("systemName is already registered: " + systemName);
            }
            log.debug("the named bean is registered twice: {}", (Object)systemName);
        } else if (this._beans.contains(s)) {
            AtomicReference oldSysName = new AtomicReference();
            Comparator c = this.memo.getNamedBeanComparator(this.getNamedBeanClass());
            this._beans.forEach(t -> {
                if (c.compare(s, t) == 0) {
                    oldSysName.set(t.getSystemName());
                }
            });
            if (!systemName.equals(oldSysName.get())) {
                String msg = String.format("systemName is already registered. Current system name: %s. New system name: %s", oldSysName, systemName);
                log.error(msg);
                throw new NamedBean.DuplicateSystemNameException(msg);
            }
        }
        this._beans.add(s);
        this._tsys.put(systemName, s);
        this.registerUserName(s);
        int position = this.getPosition(s);
        this.fireDataListenersAdded(position, position, s);
        if (!this.silencedProperties.getOrDefault("beans", false).booleanValue()) {
            this.fireIndexedPropertyChange("beans", position, null, s);
        }
        this.firePropertyChange("length", null, (Object)this._beans.size());
        s.addPropertyChangeListener(this);
    }

    private int getPosition(E s) {
        if (this._beans.contains(s)) {
            return this._beans.headSet(s, false).size();
        }
        return -1;
    }

    protected void registerUserName(E s) {
        String userName = s.getUserName();
        if (userName == null) {
            return;
        }
        this.handleUserNameUniqueness(s);
        this._tuser.put(userName, s);
    }

    protected void handleUserNameUniqueness(E s) {
        String userName = s.getUserName();
        if (userName != null && this._tuser.get(userName) != null && this._tuser.get(userName) != s) {
            ((NamedBean)this._tuser.get(userName)).setUserName(null);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void deregister(@Nonnull E s) {
        int position = this.getPosition(s);
        s.removePropertyChangeListener(this);
        String systemName = s.getSystemName();
        this._beans.remove(s);
        this._tsys.remove(systemName);
        String userName = s.getUserName();
        if (userName != null) {
            this._tuser.remove(userName);
        }
        this.fireDataListenersRemoved(position, position, s);
        if (!this.silencedProperties.getOrDefault("beans", false).booleanValue()) {
            this.fireIndexedPropertyChange("beans", position, s, null);
        }
        this.firePropertyChange("length", null, (Object)this._beans.size());
    }

    @Override
    @Nonnull
    public List<NamedBeanPropertyDescriptor<?>> getKnownBeanProperties() {
        return new LinkedList();
    }

    protected E getOuterBean(E bean) {
        return bean;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void propertyChange(PropertyChangeEvent e) {
        if ("UserName".equals(e.getPropertyName())) {
            String old = (String)e.getOldValue();
            String now = (String)e.getNewValue();
            try {
                NamedBean t = this.getOuterBean((NamedBean)e.getSource());
                if (old != null) {
                    this._tuser.remove(old);
                }
                if (now != null) {
                    if (this._tuser.get(now) != null && this._tuser.get(now) != t) {
                        ((NamedBean)this._tuser.get(now)).setUserName(null);
                    }
                    this._tuser.put(now, t);
                }
            }
            catch (ClassCastException ex) {
                log.error("Received event of wrong type {}", (Object)e.getSource().getClass().getName(), (Object)ex);
            }
            this.firePropertyChange("DisplayListName", old, now);
        }
    }

    @Override
    @CheckReturnValue
    public int getObjectCount() {
        return this._beans.size();
    }

    @Override
    @Nonnull
    public SortedSet<E> getNamedBeanSet() {
        return Collections.unmodifiableSortedSet(this._beans);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void fireVetoableChange(String p, Object old, Object n) throws PropertyVetoException {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, p, old, n);
        if ("CanDelete".equals(p)) {
            StringBuilder message = new StringBuilder();
            for (VetoableChangeListener vc : this.vetoableChangeSupport.getVetoableChangeListeners()) {
                try {
                    vc.vetoableChange(evt);
                }
                catch (PropertyVetoException e) {
                    if ("DoNotDelete".equals(e.getPropertyChangeEvent().getPropertyName())) {
                        log.info("Do Not Delete : {}", (Object)e.getMessage());
                        throw e;
                    }
                    message.append(e.getMessage()).append("<hr>");
                }
            }
            throw new PropertyVetoException(message.toString(), evt);
        }
        try {
            this.vetoableChangeSupport.fireVetoableChange(evt);
        }
        catch (PropertyVetoException e) {
            log.error("Change vetoed.", (Throwable)e);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            StringBuilder message = new StringBuilder();
            message.append(Bundle.getMessage("VetoFoundIn", this.getBeanTypeHandled())).append("<ul>");
            boolean found = false;
            for (NamedBean nb : this._beans) {
                try {
                    nb.vetoableChange(evt);
                }
                catch (PropertyVetoException e) {
                    if ("DoNotDelete".equals(e.getPropertyChangeEvent().getPropertyName())) {
                        throw e;
                    }
                    found = true;
                    message.append("<li>").append(e.getMessage()).append("</li>");
                }
            }
            message.append("</ul>").append(Bundle.getMessage("VetoWillBeRemovedFrom", this.getBeanTypeHandled()));
            if (found) {
                throw new PropertyVetoException(message.toString(), evt);
            }
        } else {
            for (NamedBean nb : this._beans) {
                nb.vetoableChange(evt);
            }
        }
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        if (this.getSystemNamePrefix().equals(systemName)) {
            return Manager.NameValidity.VALID_AS_PREFIX_ONLY;
        }
        return systemName.startsWith(this.getSystemNamePrefix()) ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    @Nonnull
    public final String getSystemPrefix() {
        return this.memo.getSystemPrefix();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setPropertyChangesSilenced(@Nonnull String propertyName, boolean silenced) {
        if (!this.silenceableProperties.contains(propertyName)) {
            throw new IllegalArgumentException("Property " + propertyName + " cannot be silenced.");
        }
        this.silencedProperties.put(propertyName, silenced);
        if ("beans".equals(propertyName) && !silenced) {
            this.fireIndexedPropertyChange("beans", this._beans.size(), null, null);
        }
    }

    @Override
    public void addDataListener(Manager.ManagerDataListener<E> e) {
        if (e != null) {
            this.listeners.add(e);
        }
    }

    @Override
    public void removeDataListener(Manager.ManagerDataListener<E> e) {
        if (e != null) {
            this.listeners.remove(e);
        }
    }

    @Override
    public void setDataListenerMute(boolean m) {
        if (this.muted && !m) {
            Manager.ManagerDataEvent<Object> e = new Manager.ManagerDataEvent<Object>(this, 0, 0, this.getObjectCount() - 1, null);
            this.listeners.forEach(listener -> listener.contentsChanged(e));
        }
        this.muted = m;
    }

    protected void fireDataListenersAdded(int start, int end, E changedBean) {
        if (this.muted) {
            return;
        }
        Manager.ManagerDataEvent e = new Manager.ManagerDataEvent(this, 1, start, end, changedBean);
        this.listeners.forEach(m -> m.intervalAdded(e));
    }

    protected void fireDataListenersRemoved(int start, int end, E changedBean) {
        if (this.muted) {
            return;
        }
        Manager.ManagerDataEvent e = new Manager.ManagerDataEvent(this, 2, start, end, changedBean);
        this.listeners.forEach(m -> m.intervalRemoved(e));
    }

    public void updateAutoNumber(String systemName) {
        String autoPrefix = this.getSubSystemNamePrefix() + ":AUTO:";
        if (systemName.startsWith(autoPrefix)) {
            try {
                int autoNumber = Integer.parseInt(systemName.substring(autoPrefix.length()));
                this.lastAutoNamedBeanRef.accumulateAndGet(autoNumber, Math::max);
            }
            catch (NumberFormatException e) {
                log.warn("Auto generated SystemName {} is not in the correct format", (Object)systemName);
            }
        }
    }

    public String getAutoSystemName() {
        int nextAutoBlockRef = this.lastAutoNamedBeanRef.incrementAndGet();
        StringBuilder b = new StringBuilder(this.getSubSystemNamePrefix() + ":AUTO:");
        String nextNumber = this.paddedNumber.format(nextAutoBlockRef);
        b.append(nextNumber);
        return b.toString();
    }

    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        return prefix + this.typeLetter() + curAddress;
    }

    protected String checkNumeric(@Nonnull String curAddress) throws JmriException {
        try {
            Integer.parseInt(curAddress);
        }
        catch (NumberFormatException ex) {
            throw new JmriException("Hardware Address passed " + curAddress + " should be a number");
        }
        return curAddress;
    }
}

