/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.SystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMemoryManager
extends AbstractManager<Memory>
implements MemoryManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractMemoryManager.class);

    public AbstractMemoryManager(SystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public int getXMLOrder() {
        return 50;
    }

    @Override
    public char typeLetter() {
        return 'M';
    }

    @Override
    @Nonnull
    public Memory provideMemory(@Nonnull String sName) throws IllegalArgumentException {
        Memory m = this.getMemory(sName);
        if (m != null) {
            return m;
        }
        if (sName.startsWith(this.getSystemNamePrefix())) {
            return this.newMemory(sName, null);
        }
        return this.newMemory(this.makeSystemName(sName), null);
    }

    @Override
    @CheckForNull
    public Memory getMemory(@Nonnull String name) {
        Memory t = (Memory)this.getByUserName(name);
        if (t != null) {
            return t;
        }
        return (Memory)this.getBySystemName(name);
    }

    @Override
    @Nonnull
    public Memory newMemory(@Nonnull String systemName, @CheckForNull String userName) throws IllegalArgumentException {
        Memory m;
        log.debug("new Memory: {}; {}", (Object)systemName, (Object)(userName == null ? "null" : userName));
        Objects.requireNonNull(systemName, "SystemName cannot be null. UserName was " + (userName == null ? "null" : userName));
        if (userName != null && (m = (Memory)this.getByUserName(userName)) != null) {
            if (this.getBySystemName(systemName) != m) {
                log.error("inconsistent user ({}) and system name ({}) results; userName related to ({})", new Object[]{userName, systemName, m.getSystemName()});
            }
            return m;
        }
        m = (Memory)this.getBySystemName(systemName);
        if (m != null) {
            if (userName != null) {
                if (m.getUserName() != null && !userName.equals(m.getUserName())) {
                    log.warn("newMemory request for system name \"{}\" user name \"{}\" found memory with existing user name \"{}\"", new Object[]{systemName, userName, m.getUserName()});
                } else {
                    m.setUserName(userName);
                }
            }
            return m;
        }
        m = this.createNewMemory(systemName, userName);
        this.register(m);
        this.updateAutoNumber(systemName);
        return m;
    }

    @Override
    @Nonnull
    public Memory newMemory(@CheckForNull String userName) throws IllegalArgumentException {
        return this.newMemory(this.getAutoSystemName(), userName);
    }

    @Nonnull
    protected abstract Memory createNewMemory(@Nonnull String var1, @CheckForNull String var2) throws IllegalArgumentException;

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameMemories" : "BeanNameMemory");
    }

    @Override
    public Class<Memory> getNamedBeanClass() {
        return Memory.class;
    }

    @Override
    @Nonnull
    public Memory provide(@Nonnull String name) throws IllegalArgumentException {
        return this.provideMemory(name);
    }
}

