/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.SystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReporterManager
extends AbstractManager<Reporter>
implements ReporterManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractReporterManager.class);

    public AbstractReporterManager(SystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public int getXMLOrder() {
        return 40;
    }

    @Override
    public char typeLetter() {
        return 'R';
    }

    @Override
    @Nonnull
    public Reporter provideReporter(@Nonnull String sName) throws IllegalArgumentException {
        Reporter r = this.getReporter(sName);
        return r == null ? this.newReporter(this.makeSystemName(sName, true), null) : r;
    }

    @Override
    @CheckForNull
    public Reporter getReporter(@Nonnull String name) {
        Reporter r = (Reporter)this.getByUserName(name);
        return r == null ? (Reporter)this.getBySystemName(name) : r;
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameReporters" : "BeanNameReporter");
    }

    @Override
    public Class<Reporter> getNamedBeanClass() {
        return Reporter.class;
    }

    @Override
    @CheckForNull
    public Reporter getByDisplayName(@Nonnull String key) {
        return this.getReporter(key);
    }

    @Override
    @Nonnull
    public Reporter newReporter(@Nonnull String systemName, @CheckForNull String userName) throws IllegalArgumentException {
        Reporter r;
        Objects.requireNonNull(systemName, "SystemName cannot be null. UserName was " + (userName == null ? "null" : userName));
        log.debug("new Reporter: {} {}", (Object)systemName, (Object)userName);
        if (!systemName.startsWith(this.getSystemNamePrefix()) || systemName.length() <= this.getSystemNamePrefix().length()) {
            log.error("Invalid system name for reporter: {} needed {}{}", new Object[]{systemName, this.getSystemPrefix(), Character.valueOf(this.typeLetter())});
            throw new IllegalArgumentException("Invalid system name for turnout: " + systemName + " needed " + this.getSystemNamePrefix());
        }
        if (userName != null && (r = (Reporter)this.getByUserName(userName)) != null) {
            if (this.getBySystemName(systemName) != r) {
                log.error("inconsistent user ({}) and system name ({}) results; userName related to ({})", new Object[]{userName, systemName, r.getSystemName()});
            }
            return r;
        }
        r = (Reporter)this.getBySystemName(systemName);
        if (r != null) {
            if (r.getUserName() == null && userName != null) {
                r.setUserName(userName);
            } else if (userName != null) {
                log.warn("Found reporter via system name ({}}) with non-null user name ({}})", (Object)systemName, (Object)userName);
            }
            return r;
        }
        r = this.createNewReporter(systemName, userName);
        if (this.getBySystemName(systemName) == null) {
            this.register(r);
        }
        return r;
    }

    @Nonnull
    protected abstract Reporter createNewReporter(@Nonnull String var1, String var2) throws IllegalArgumentException;

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("EnterNumber1to9999ToolTip");
    }
}

