/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.util.Enumeration;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSensorManager
extends AbstractManager<Sensor>
implements SensorManager {
    static final Matcher numberMatcher = Pattern.compile("\\d++").matcher("");
    protected long sensorDebounceGoingActive = 0L;
    protected long sensorDebounceGoingInActive = 0L;
    private static final Logger log = LoggerFactory.getLogger(AbstractSensorManager.class);

    public AbstractSensorManager(SystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public int getXMLOrder() {
        return 10;
    }

    @Override
    public char typeLetter() {
        return 'S';
    }

    @Override
    @Nonnull
    public Sensor provideSensor(@Nonnull String name) {
        Sensor t = this.getSensor(name);
        if (t == null) {
            t = this.newSensor(this.makeSystemName(name), null);
        }
        return t;
    }

    @Override
    public Sensor getSensor(@Nonnull String name) {
        Sensor t = (Sensor)this.getByUserName(name);
        if (t != null) {
            return t;
        }
        return this.getBySystemName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNumber(@Nonnull String s) {
        Matcher matcher = numberMatcher;
        synchronized (matcher) {
            return numberMatcher.reset(s).matches();
        }
    }

    @Override
    public Sensor getBySystemName(@Nonnull String key) {
        if (this.isNumber(key)) {
            key = this.makeSystemName(key);
        }
        return (Sensor)this._tsys.get(key);
    }

    @Override
    @Nonnull
    public Sensor newSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        Sensor s;
        log.debug(" newSensor(\"{}\", \"{}\")", (Object)systemName, (Object)(userName == null ? "null" : userName));
        Objects.requireNonNull(systemName, "SystemName cannot be null. UserName was " + (userName == null ? "null" : userName));
        systemName = this.validateSystemNameFormat(systemName);
        if (userName != null && (s = (Sensor)this.getByUserName(userName)) != null) {
            if (this.getBySystemName(systemName) != s) {
                log.error("inconsistent user ({}) and system name ({}) results; userName related to ({})", new Object[]{userName, systemName, s.getSystemName()});
            }
            return s;
        }
        s = this.getBySystemName(systemName);
        if (s != null) {
            if (s.getUserName() == null && userName != null) {
                s.setUserName(userName);
            } else if (userName != null) {
                log.warn("Found sensor via system name ({}) with non-null user name ({}). Sensor \"{}({})\" cannot be used.", new Object[]{systemName, s.getUserName(), systemName, userName});
            }
            return s;
        }
        s = this.createNewSensor(systemName, userName);
        this.register(s);
        return s;
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameSensors" : "BeanNameSensor");
    }

    @Override
    public Class<Sensor> getNamedBeanClass() {
        return Sensor.class;
    }

    @Nonnull
    protected abstract Sensor createNewSensor(@Nonnull String var1, String var2) throws IllegalArgumentException;

    @Override
    public void updateAll() {
        int i = 0;
        for (Sensor nb : this.getNamedBeanSet()) {
            ThreadingUtil.runOnLayoutDelayed(nb::requestUpdateFromLayout, i * this.getMemo().getOutputInterval());
            ++i;
        }
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        return prefix + this.typeLetter() + this.checkNumeric(curAddress);
    }

    @Override
    public long getDefaultSensorDebounceGoingActive() {
        return this.sensorDebounceGoingActive;
    }

    @Override
    public long getDefaultSensorDebounceGoingInActive() {
        return this.sensorDebounceGoingInActive;
    }

    @Override
    public void setDefaultSensorDebounceGoingActive(long time) {
        if (time == this.sensorDebounceGoingActive) {
            return;
        }
        this.sensorDebounceGoingActive = time;
        Enumeration en = this._tsys.keys();
        while (en.hasMoreElements()) {
            Sensor sen = (Sensor)this._tsys.get(en.nextElement());
            if (!sen.getUseDefaultTimerSettings()) continue;
            sen.setSensorDebounceGoingActiveTimer(time);
        }
    }

    @Override
    public void setDefaultSensorDebounceGoingInActive(long time) {
        if (time == this.sensorDebounceGoingInActive) {
            return;
        }
        this.sensorDebounceGoingInActive = time;
        Enumeration en = this._tsys.keys();
        while (en.hasMoreElements()) {
            Sensor sen = (Sensor)this._tsys.get(en.nextElement());
            if (!sen.getUseDefaultTimerSettings()) continue;
            sen.setSensorDebounceGoingInActiveTimer(time);
        }
    }

    @Override
    public boolean isPullResistanceConfigurable() {
        return false;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("EnterNumber1to9999ToolTip");
    }
}

