/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.TurnoutManager;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;

public class AbstractSignalHeadManager
extends AbstractManager<SignalHead>
implements SignalHeadManager {
    public AbstractSignalHeadManager(InternalSystemConnectionMemo memo) {
        super(memo);
        this.init();
    }

    final void init() {
        InstanceManager.getDefault(TurnoutManager.class).addVetoableChangeListener(this);
    }

    @Override
    public int getXMLOrder() {
        return 70;
    }

    @Override
    public char typeLetter() {
        return 'H';
    }

    @Override
    @CheckForNull
    public SignalHead getSignalHead(@Nonnull String name) {
        Objects.requireNonNull(name, "SignalHead name cannot be null.");
        if (name.trim().length() == 0) {
            return null;
        }
        SignalHead t = (SignalHead)this.getByUserName(name);
        if (t != null) {
            return t;
        }
        return (SignalHead)this.getBySystemName(name);
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameSignalHeads" : "BeanNameSignalHead");
    }

    @Override
    public Class<SignalHead> getNamedBeanClass() {
        return SignalHead.class;
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(TurnoutManager.class).removeVetoableChangeListener(this);
        super.dispose();
    }
}

