/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.util.Objects;
import javax.annotation.Nonnull;
import jmri.StringIO;
import jmri.StringIOManager;
import jmri.SystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStringIOManager
extends AbstractManager<StringIO>
implements StringIOManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractStringIOManager.class);

    public AbstractStringIOManager(SystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public int getXMLOrder() {
        return 220;
    }

    @Override
    @Nonnull
    public StringIO provideStringIO(@Nonnull String name) {
        StringIO t = this.getStringIO(name);
        if (t == null) {
            t = this.newStringIO(this.makeSystemName(name), null);
        }
        return t;
    }

    @Override
    public StringIO getStringIO(@Nonnull String name) {
        StringIO t = (StringIO)this.getByUserName(name);
        if (t != null) {
            return t;
        }
        return (StringIO)this.getBySystemName(name);
    }

    @Override
    @Nonnull
    public final StringIO newStringIO(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        StringIO s;
        log.debug(" newStringIO(\"{}\", \"{}\")", (Object)systemName, (Object)(userName == null ? "null" : userName));
        Objects.requireNonNull(systemName, "SystemName cannot be null. UserName was " + (userName == null ? "null" : userName));
        systemName = this.validateSystemNameFormat(systemName);
        if (userName != null && (s = (StringIO)this.getByUserName(userName)) != null) {
            if (this.getBySystemName(systemName) != s) {
                log.error("inconsistent user ({}) and system name ({}) results; userName related to ({})", new Object[]{userName, systemName, s.getSystemName()});
            }
            return s;
        }
        s = (StringIO)this.getBySystemName(systemName);
        if (s != null) {
            if (s.getUserName() == null && userName != null) {
                s.setUserName(userName);
            } else if (userName != null) {
                log.warn("Found StringIO via system name ({}) with non-null user name ({}). StringIO \"{}({})\" cannot be used.", new Object[]{systemName, s.getUserName(), systemName, userName});
            }
            return s;
        }
        s = this.createNewStringIO(systemName, userName);
        this.register(s);
        return s;
    }

    @Override
    public char typeLetter() {
        return 'C';
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameStringIOs" : "BeanNameStringIO");
    }

    @Override
    public Class<StringIO> getNamedBeanClass() {
        return StringIO.class;
    }

    @Nonnull
    protected abstract StringIO createNewStringIO(@Nonnull String var1, String var2) throws IllegalArgumentException;

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("EnterStringToolTip");
    }
}

