/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.beans.PropertyChangeListener;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SensorManager;
import jmri.SystemConnectionMemo;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.TurnoutOperationManager;
import jmri.implementation.SignalSpeedMap;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTurnoutManager
extends AbstractManager<Turnout>
implements TurnoutManager {
    final PropertyChangeListener pcl = e -> {
        if (e.getPropertyName().equals("OutputInterval")) {
            this.handleIntervalChange((Integer)e.getNewValue());
        }
    };
    private String defaultClosedSpeed = "Normal";
    private String defaultThrownSpeed = "Restricted";
    private int turnoutInterval = this.memo.getOutputInterval();
    private LocalDateTime waitUntil = LocalDateTime.now();
    private static final Logger log = LoggerFactory.getLogger(AbstractTurnoutManager.class);

    public AbstractTurnoutManager(SystemConnectionMemo memo) {
        super(memo);
        InstanceManager.getDefault(TurnoutOperationManager.class);
        this.init();
    }

    final void init() {
        InstanceManager.getDefault(SensorManager.class).addVetoableChangeListener(this);
        this.memo.addPropertyChangeListener(this.pcl);
    }

    @Override
    public int getXMLOrder() {
        return 20;
    }

    @Override
    public char typeLetter() {
        return 'T';
    }

    @Override
    @Nonnull
    public Turnout provideTurnout(@Nonnull String name) {
        log.debug("provide turnout {}", (Object)name);
        Turnout result = this.getTurnout(name);
        return result == null ? this.newTurnout(this.makeSystemName(name, true), null) : result;
    }

    @Override
    @CheckForNull
    public Turnout getTurnout(@Nonnull String name) {
        Turnout result = (Turnout)this.getByUserName(name);
        if (result == null) {
            result = (Turnout)this.getBySystemName(name);
        }
        return result;
    }

    @Override
    @Nonnull
    public Turnout newTurnout(@Nonnull String systemName, @CheckForNull String userName) throws IllegalArgumentException {
        Turnout t;
        Objects.requireNonNull(systemName, "SystemName cannot be null. UserName was " + (userName == null ? "null" : userName));
        log.debug("newTurnout: {};{}", (Object)systemName, (Object)userName);
        if (!systemName.startsWith(this.getSystemNamePrefix()) || systemName.length() <= this.getSystemNamePrefix().length()) {
            log.error("Invalid system name for Turnout: {} needed {}{} followed by a suffix", new Object[]{systemName, this.getSystemPrefix(), Character.valueOf(this.typeLetter())});
            throw new IllegalArgumentException("Invalid system name for Turnout: " + systemName + " needed " + this.getSystemNamePrefix());
        }
        if (userName != null && (t = (Turnout)this.getByUserName(userName)) != null) {
            if (this.getBySystemName(systemName) != t) {
                log.error("inconsistent user ({}) and system name ({}) results; userName related to ({})", new Object[]{userName, systemName, t.getSystemName()});
            }
            return t;
        }
        t = (Turnout)this.getBySystemName(systemName);
        if (t != null) {
            if (t.getUserName() == null && userName != null) {
                t.setUserName(userName);
            } else if (userName != null) {
                log.warn("Found turnout via system name ({}) with non-null user name ({}). Turnout \"{} ({})\" cannot be used.", new Object[]{systemName, t.getUserName(), systemName, userName});
            }
            return t;
        }
        t = this.createNewTurnout(systemName, userName);
        if (this.getBySystemName(t.getSystemName()) == null) {
            this.register(t);
        }
        try {
            t.setStraightSpeed("Global");
        }
        catch (JmriException ex) {
            log.error("Turnout : {} : {}", (Object)t, (Object)ex.getMessage());
        }
        try {
            t.setDivergingSpeed("Global");
        }
        catch (JmriException ex) {
            log.error("Turnout : {} : {}", (Object)t, (Object)ex.getMessage());
        }
        return t;
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameTurnouts" : "BeanNameTurnout");
    }

    @Override
    public Class<Turnout> getNamedBeanClass() {
        return Turnout.class;
    }

    @Override
    @Nonnull
    public String getClosedText() {
        return Bundle.getMessage("TurnoutStateClosed");
    }

    @Override
    @Nonnull
    public String getThrownText() {
        return Bundle.getMessage("TurnoutStateThrown");
    }

    @Override
    public int askNumControlBits(@Nonnull String systemName) {
        return 1;
    }

    @Override
    public boolean isNumControlBitsSupported(@Nonnull String systemName) {
        return false;
    }

    @Override
    public int askControlType(@Nonnull String systemName) {
        return 0;
    }

    @Override
    public boolean isControlTypeSupported(@Nonnull String systemName) {
        return false;
    }

    @Nonnull
    protected abstract Turnout createNewTurnout(@Nonnull String var1, String var2) throws IllegalArgumentException;

    @Override
    @Nonnull
    public String[] getValidOperationTypes() {
        if (InstanceManager.getNullableDefault(CommandStation.class) != null) {
            return new String[]{"Sensor", "Raw", "NoFeedback"};
        }
        return new String[]{"Sensor", "NoFeedback"};
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        return prefix + this.typeLetter() + this.checkNumeric(curAddress);
    }

    @Override
    public void setDefaultClosedSpeed(@Nonnull String speed) throws JmriException {
        Objects.requireNonNull(speed, "Value of requested turnout default closed speed can not be null");
        if (this.defaultClosedSpeed.equals(speed)) {
            return;
        }
        if (speed.contains("Block")) {
            speed = "Block";
            if (this.defaultClosedSpeed.equals(speed)) {
                return;
            }
        } else {
            try {
                Float.parseFloat(speed);
            }
            catch (NumberFormatException nx) {
                try {
                    InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(speed);
                }
                catch (IllegalArgumentException ex) {
                    throw new JmriException("Value of requested turnout default closed speed is not valid. " + ex.getMessage());
                }
            }
        }
        String oldSpeed = this.defaultClosedSpeed;
        this.defaultClosedSpeed = speed;
        this.firePropertyChange("DefaultTurnoutClosedSpeedChange", oldSpeed, speed);
    }

    @Override
    public void setDefaultThrownSpeed(@Nonnull String speed) throws JmriException {
        Objects.requireNonNull(speed, "Value of requested turnout default thrown speed can not be null");
        if (this.defaultThrownSpeed.equals(speed)) {
            return;
        }
        if (speed.contains("Block")) {
            speed = "Block";
            if (this.defaultThrownSpeed.equals(speed)) {
                return;
            }
        } else {
            try {
                Float.parseFloat(speed);
            }
            catch (NumberFormatException nx) {
                try {
                    InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(speed);
                }
                catch (IllegalArgumentException ex) {
                    throw new JmriException("Value of requested turnout default thrown speed is not valid. " + ex.getMessage());
                }
            }
        }
        String oldSpeed = this.defaultThrownSpeed;
        this.defaultThrownSpeed = speed;
        this.firePropertyChange("DefaultTurnoutThrownSpeedChange", oldSpeed, speed);
    }

    @Override
    public String getDefaultThrownSpeed() {
        return this.defaultThrownSpeed;
    }

    @Override
    public String getDefaultClosedSpeed() {
        return this.defaultClosedSpeed;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("EnterNumber1to9999ToolTip");
    }

    private void handleIntervalChange(int newVal) {
        this.turnoutInterval = newVal;
        log.debug("in memo turnoutInterval changed to {}", (Object)this.turnoutInterval);
    }

    @Override
    public int getOutputInterval() {
        return this.turnoutInterval;
    }

    @Override
    public void setOutputInterval(int newInterval) {
        this.memo.setOutputInterval(newInterval);
        this.turnoutInterval = newInterval;
        log.debug("turnoutInterval set to: {}", (Object)newInterval);
    }

    @Override
    @Nonnull
    public LocalDateTime outputIntervalEnds() {
        log.debug("outputIntervalEnds called in AbstractTurnoutManager");
        this.waitUntil = this.waitUntil.isAfter(LocalDateTime.now()) ? this.waitUntil.plus(this.turnoutInterval, ChronoUnit.MILLIS) : LocalDateTime.now().plus(this.turnoutInterval, ChronoUnit.MILLIS);
        return this.waitUntil;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void dispose() {
        this.memo.removePropertyChangeListener(this.pcl);
        InstanceManager.getDefault(SensorManager.class).removeVetoableChangeListener(this);
        super.dispose();
    }
}

