/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import javax.annotation.Nonnull;
import jmri.BlockManager;
import jmri.ConditionalManager;
import jmri.InstanceManager;
import jmri.Logix;
import jmri.LogixManager;
import jmri.SignalHeadManager;
import jmri.SignalMastManager;
import jmri.implementation.DefaultLogix;
import jmri.jmrit.beantable.LRouteTableAction;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogixManager
extends AbstractManager<Logix>
implements LogixManager {
    boolean loadDisabled = false;
    private static final Logger log = LoggerFactory.getLogger(DefaultLogixManager.class);

    public DefaultLogixManager(InternalSystemConnectionMemo memo) {
        super(memo);
        InstanceManager.turnoutManagerInstance().addVetoableChangeListener(this);
        InstanceManager.sensorManagerInstance().addVetoableChangeListener(this);
        InstanceManager.memoryManagerInstance().addVetoableChangeListener(this);
        InstanceManager.getDefault(SignalHeadManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(SignalMastManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(BlockManager.class).addVetoableChangeListener(this);
        InstanceManager.lightManagerInstance().addVetoableChangeListener(this);
        InstanceManager.getDefault(ConditionalManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(WarrantManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(OBlockManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(EntryExitPairs.class).addVetoableChangeListener(this);
    }

    @Override
    public int getXMLOrder() {
        return 230;
    }

    @Override
    public char typeLetter() {
        return 'X';
    }

    @Override
    public Logix createNewLogix(String systemName, String userName) {
        Logix x;
        if (userName != null && !userName.equals("") && (x = (Logix)this.getByUserName(userName)) != null) {
            return null;
        }
        x = (Logix)this.getBySystemName(systemName);
        if (x != null) {
            return null;
        }
        x = new DefaultLogix(systemName, userName);
        this.register(x);
        this.updateAutoNumber(systemName);
        return x;
    }

    @Override
    public Logix createNewLogix(String userName) {
        return this.createNewLogix(this.getAutoSystemName(), userName);
    }

    @Override
    public void deleteLogix(Logix x) {
        this.deregister(x);
        x.dispose();
    }

    @Override
    public void activateAllLogixs() {
        Logix x2 = (Logix)this.getBySystemName(LRouteTableAction.getLogixInitializer());
        if (x2 != null) {
            x2.activateLogix();
            x2.setGuiNames();
        }
        for (Logix x2 : this.getNamedBeanSet()) {
            if (x2.getSystemName().equals(LRouteTableAction.getLogixInitializer())) continue;
            if (this.loadDisabled) {
                log.warn("load disabled set - will not activate logic for: {}", (Object)x2.getDisplayName());
                x2.setEnabled(false);
            }
            if (x2.getEnabled()) {
                x2.activateLogix();
            }
            x2.setGuiNames();
        }
        this.loadDisabled = false;
    }

    @Override
    public Logix getLogix(String name) {
        Logix x = (Logix)this.getByUserName(name);
        if (x != null) {
            return x;
        }
        return (Logix)this.getBySystemName(name);
    }

    @Override
    public void setLoadDisabled(boolean s) {
        this.loadDisabled = s;
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameLogixes" : "BeanNameLogix");
    }

    @Override
    public Class<Logix> getNamedBeanClass() {
        return Logix.class;
    }
}

