/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.BlockManager;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Path;
import jmri.Section;
import jmri.SectionManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.DefaultSection;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.ConnectivityUtil;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockConnectivityTools;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSectionManager
extends AbstractManager<Section>
implements SectionManager {
    private List<Block> blockList;
    private static final Logger log = LoggerFactory.getLogger(DefaultSectionManager.class);

    public DefaultSectionManager() {
        this.addListeners();
    }

    final void addListeners() {
        InstanceManager.getDefault(SensorManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(BlockManager.class).addVetoableChangeListener(this);
    }

    @Override
    public int getXMLOrder() {
        return 130;
    }

    @Override
    public char typeLetter() {
        return 'Y';
    }

    @Override
    public Class<Section> getNamedBeanClass() {
        return Section.class;
    }

    @Override
    @Nonnull
    public Section createNewSection(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        Section y;
        Objects.requireNonNull(systemName, "SystemName cannot be null. UserName was " + (userName == null ? "null" : userName));
        if (systemName.isEmpty()) {
            throw new IllegalArgumentException("Section System Name Empty");
        }
        String sysName = systemName;
        if (!sysName.startsWith(this.getSystemNamePrefix())) {
            sysName = this.makeSystemName(sysName);
        }
        if (userName != null && !userName.isEmpty() && (y = (Section)this.getByUserName(userName)) != null) {
            throw new IllegalArgumentException("Section Already Exists with UserName " + userName);
        }
        y = (Section)this.getBySystemName(sysName);
        if (y != null) {
            throw new IllegalArgumentException("Section Already Exists with SystemName " + sysName);
        }
        y = new DefaultSection(sysName, userName);
        this.register(y);
        this.updateAutoNumber(systemName);
        return y;
    }

    @Override
    @Nonnull
    public Section createNewSection(String userName) throws IllegalArgumentException {
        return this.createNewSection(this.getAutoSystemName(), userName);
    }

    @Override
    public void deleteSection(Section y) {
        this.deregister(y);
        y.dispose();
    }

    @Override
    @CheckForNull
    public Section getSection(String name) {
        Section y = (Section)this.getByUserName(name);
        if (y != null) {
            return y;
        }
        return (Section)this.getBySystemName(name);
    }

    @Override
    public int validateAllSections() {
        SortedSet set = this.getNamedBeanSet();
        int numSections = 0;
        int numErrors = 0;
        if (set.size() <= 0) {
            return -2;
        }
        for (Section section : set) {
            String s = section.validate();
            if (!s.isEmpty()) {
                log.error("Validate result for section {}: {}", (Object)section.getDisplayName(), (Object)s);
                ++numErrors;
            }
            ++numSections;
        }
        log.debug("Validated {} Sections - {} errors or warnings.", (Object)numSections, (Object)numErrors);
        return numErrors;
    }

    @Override
    public int setupDirectionSensors() {
        SortedSet set = this.getNamedBeanSet();
        int numSections = 0;
        int numErrors = 0;
        if (set.size() <= 0) {
            return -2;
        }
        for (Section section : set) {
            int errors = section.placeDirectionSensors();
            numErrors += errors;
            ++numSections;
        }
        log.debug("Checked direction sensors for {} Sections - {} errors or warnings.", (Object)numSections, (Object)numErrors);
        return numErrors;
    }

    @Override
    public int removeDirectionSensorsFromSSL() {
        SortedSet set = this.getNamedBeanSet();
        if (set.size() <= 0) {
            return -2;
        }
        int numErrors = 0;
        ArrayList<String> sensorList = new ArrayList<String>();
        for (Section s : set) {
            String name = s.getReverseBlockingSensorName();
            if (name != null && !name.isEmpty()) {
                sensorList.add(name);
            }
            if ((name = s.getForwardBlockingSensorName()) == null || name.isEmpty()) continue;
            sensorList.add(name);
        }
        EditorManager editorManager = InstanceManager.getDefault(EditorManager.class);
        SignalHeadManager shManager = InstanceManager.getDefault(SignalHeadManager.class);
        for (LayoutEditor panel : editorManager.getAll(LayoutEditor.class)) {
            ConnectivityUtil cUtil = panel.getConnectivityUtil();
            for (SignalHead sh : shManager.getNamedBeanSet()) {
                if (cUtil.removeSensorsFromSignalHeadLogic(sensorList, sh)) continue;
                ++numErrors;
            }
        }
        return numErrors;
    }

    @Override
    public void initializeBlockingSensors() {
        for (Section s : this.getNamedBeanSet()) {
            try {
                Sensor sensor = s.getForwardBlockingSensor();
                if (sensor != null) {
                    sensor.setState(2);
                }
                if ((sensor = s.getReverseBlockingSensor()) == null) continue;
                sensor.setState(2);
            }
            catch (JmriException reason) {
                log.error("Exception when initializing blocking Sensors for Section {}", (Object)s.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME));
            }
        }
    }

    @Override
    public void generateBlockSections() {
        LayoutBlockManager layoutBlockManager = InstanceManager.getDefault(LayoutBlockManager.class);
        for (LayoutBlock layoutBlock : layoutBlockManager.getNamedBeanSet()) {
            if (layoutBlock.getNumberOfThroughPaths() != 0 || this.blockSectionExists(layoutBlock)) continue;
            this.createBlockSection(layoutBlock);
        }
    }

    private boolean blockSectionExists(LayoutBlock layoutBlock) {
        for (Section section : this.getNamedBeanSet()) {
            if (section.getNumBlocks() <= 0 || section.getSectionType() == Section.SIGNALMASTLOGIC || !layoutBlock.getBlock().equals(section.getBlockList().get(0))) continue;
            return true;
        }
        return false;
    }

    private void createBlockSection(LayoutBlock layoutBlock) {
        Section section;
        this.blockList = new ArrayList<Block>();
        Block block = layoutBlock.getBlock();
        this.createSectionBlockList(block);
        if (this.blockList.isEmpty()) {
            log.error("No blocks found for layout block '{}'", (Object)layoutBlock.getDisplayName());
            return;
        }
        Object sectionName = this.blockList.get(0).getDisplayName();
        if (this.blockList.size() > 1) {
            sectionName = (String)sectionName + ":::" + this.blockList.get(this.blockList.size() - 1).getDisplayName();
        }
        try {
            section = this.createNewSection((String)sectionName);
        }
        catch (IllegalArgumentException ex) {
            log.error("Could not create Section for layout block '{}'", (Object)layoutBlock.getDisplayName());
            return;
        }
        this.blockList.forEach(blk -> section.addBlock((Block)blk));
        Block lastBlock = this.blockList.get(this.blockList.size() - 1);
        AbstractNamedBean nextBlock = null;
        String pathDirection = "";
        for (Path path : lastBlock.getPaths()) {
            Block checkBlock = path.getBlock();
            if (this.blockList.contains(checkBlock)) continue;
            nextBlock = checkBlock;
            pathDirection = Path.decodeDirection(path.getFromBlockDirection());
            break;
        }
        if (nextBlock == null) {
            log.error("Unable to find a next block after block '{}'", (Object)lastBlock.getDisplayName());
            return;
        }
        log.debug("last = {}, next = {}", (Object)lastBlock.getDisplayName(), (Object)nextBlock.getDisplayName());
        EntryPoint ep = new EntryPoint(lastBlock, (Block)nextBlock, pathDirection);
        ep.setTypeReverse();
        section.addToReverseList(ep);
    }

    private void createSectionBlockList(@Nonnull Block block) {
        Block nextBlock;
        this.blockList.add(block);
        if (this.blockList.size() < 100 && (nextBlock = this.getNextBlock(block)) != null) {
            this.createSectionBlockList(nextBlock);
        }
    }

    @CheckForNull
    private Block getNextBlock(@Nonnull Block block) {
        LayoutBlockManager lbmManager = InstanceManager.getDefault(LayoutBlockManager.class);
        SignalMastLogicManager smlManager = InstanceManager.getDefault(SignalMastLogicManager.class);
        LayoutBlock layoutBlock = lbmManager.getLayoutBlock(block);
        if (layoutBlock == null) {
            return null;
        }
        for (SignalMastLogic sml : smlManager.getSignalMastLogicList()) {
            if (!sml.getFacingBlock().equals(layoutBlock)) continue;
            return null;
        }
        Block nextBlock = null;
        switch (layoutBlock.getNumberOfNeighbours()) {
            case 0: {
                log.debug("No neighbors for layout block '{}'", (Object)layoutBlock.getDisplayName());
                break;
            }
            case 1: {
                nextBlock = layoutBlock.getNeighbourAtIndex(0);
                break;
            }
            case 2: {
                nextBlock = layoutBlock.getNeighbourAtIndex(0);
                if (!this.blockList.contains(nextBlock)) break;
                nextBlock = layoutBlock.getNeighbourAtIndex(1);
                break;
            }
            default: {
                log.debug("More than 2 neighbors for layout block '{}'", (Object)layoutBlock.getDisplayName());
                nextBlock = this.getNextConnectedBlock(layoutBlock);
            }
        }
        return nextBlock;
    }

    @CheckForNull
    private Block getNextConnectedBlock(LayoutBlock currentBlock) {
        LayoutBlock facingBlock;
        LayoutBlockManager lbmManager = InstanceManager.getDefault(LayoutBlockManager.class);
        LayoutBlockConnectivityTools lbTools = lbmManager.getLayoutBlockConnectivityTools();
        LayoutBlockConnectivityTools.Routing pathMethod = LayoutBlockConnectivityTools.Routing.NONE;
        int index = this.blockList.size() - 2;
        if (index < 0) {
            index = 0;
        }
        if ((facingBlock = lbmManager.getLayoutBlock(this.blockList.get(index))) == null) {
            log.error("The facing block not found for current block '{}'", (Object)currentBlock.getDisplayName());
            return null;
        }
        for (int i = 0; i < currentBlock.getNumberOfNeighbours(); ++i) {
            Block dest = currentBlock.getNeighbourAtIndex(i);
            LayoutBlock destBlock = lbmManager.getLayoutBlock(dest);
            try {
                boolean valid = lbTools.checkValidDest(facingBlock, currentBlock, destBlock, new ArrayList<LayoutBlock>(), pathMethod);
                if (!valid) continue;
                return dest;
            }
            catch (JmriException ex) {
                log.error("getNextConnectedBlock exeption: {}", (Object)ex.getMessage());
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameSections" : "BeanNameSection");
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(SensorManager.class).removeVetoableChangeListener(this);
        InstanceManager.getDefault(BlockManager.class).removeVetoableChangeListener(this);
        super.dispose();
    }
}

