/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jmri.ShutDownManager;
import jmri.ShutDownTask;
import jmri.beans.Bean;
import jmri.configurexml.StoreAndCompare;
import jmri.util.JmriThreadPoolExecutor;
import jmri.util.SystemType;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;

public class DefaultShutDownManager
extends Bean
implements ShutDownManager {
    private static volatile boolean shuttingDown = false;
    private volatile boolean shutDownComplete = false;
    private final Set<Callable<Boolean>> callables = new CopyOnWriteArraySet<Callable<Boolean>>();
    private final Set<EarlyTask> earlyRunnables = new CopyOnWriteArraySet<EarlyTask>();
    private final Set<Runnable> runnables = new CopyOnWriteArraySet<Runnable>();
    protected final Thread shutdownHook = ThreadingUtil.newThread(() -> this.shutdown(0, false));
    int tasksTimeOutMilliSec = 30000;
    private static final String NO_NULL_TASK = "Shutdown task cannot be null.";
    private static final String PROP_SHUTTING_DOWN = "shuttingDown";
    private boolean blockingShutdown = false;
    private static final Logger log = LoggerFactory.getLogger(DefaultShutDownManager.class);

    public DefaultShutDownManager() {
        super(false);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            if (SystemType.isMacOSX() || SystemType.isLinux()) {
                Signal.handle(new Signal("INT"), sig -> this.shutdown());
                Signal.handle(new Signal("HUP"), sig -> this.restart());
            }
            Signal.handle(new Signal("TERM"), sig -> this.shutdown());
        }
        catch (NullPointerException e) {
            log.warn("Failed to add signal handler due to missing signal definition");
        }
    }

    public void setBlockingShutdown(boolean value) {
        this.blockingShutdown = value;
    }

    @Override
    public synchronized void register(ShutDownTask s) {
        Objects.requireNonNull(s, NO_NULL_TASK);
        this.earlyRunnables.add(new EarlyTask(s));
        this.runnables.add(s);
        this.callables.add(s);
        this.addPropertyChangeListener(PROP_SHUTTING_DOWN, s);
    }

    @Override
    public synchronized void register(Callable<Boolean> task) {
        Objects.requireNonNull(task, NO_NULL_TASK);
        this.callables.add(task);
    }

    @Override
    public synchronized void register(Runnable task) {
        Objects.requireNonNull(task, NO_NULL_TASK);
        this.runnables.add(task);
    }

    @Override
    public synchronized void deregister(ShutDownTask s) {
        this.removePropertyChangeListener(PROP_SHUTTING_DOWN, s);
        this.callables.remove(s);
        this.runnables.remove(s);
        for (EarlyTask r : this.earlyRunnables) {
            if (r.task != s) continue;
            this.earlyRunnables.remove(r);
        }
    }

    @Override
    public synchronized void deregister(Callable<Boolean> task) {
        this.callables.remove(task);
    }

    @Override
    public synchronized void deregister(Runnable task) {
        this.runnables.remove(task);
    }

    @Override
    public List<Callable<Boolean>> getCallables() {
        ArrayList<Callable<Boolean>> list = new ArrayList<Callable<Boolean>>();
        list.addAll(this.callables);
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<Runnable> getRunnables() {
        ArrayList<Runnable> list = new ArrayList<Runnable>();
        list.addAll(this.runnables);
        return Collections.unmodifiableList(list);
    }

    @Override
    public void shutdown() {
        this.shutdown(0, true);
    }

    @Override
    public void restart() {
        this.shutdown(100, true);
    }

    @Override
    public void restartOS() {
        this.shutdown(210, true);
    }

    @Override
    public void shutdownOS() {
        this.shutdown(200, true);
    }

    public void shutdown(int status, boolean exit) {
        Runnable shutdownTask = () -> this.doShutdown(status, exit);
        if (!this.blockingShutdown) {
            new Thread(shutdownTask).start();
        } else {
            shutdownTask.run();
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="OK to directly exit standalone main")
    private void doShutdown(int status, boolean exit) {
        log.debug("shutdown called with {} {}", (Object)status, (Object)exit);
        if (!shuttingDown) {
            long start = System.currentTimeMillis();
            log.debug("Shutting down with {} callable and {} runnable tasks", (Object)this.callables.size(), (Object)this.runnables.size());
            this.setShuttingDown(true);
            for (Callable<Boolean> task : this.callables) {
                try {
                    if (!Boolean.FALSE.equals(task.call())) continue;
                    this.setShuttingDown(false);
                    return;
                }
                catch (Exception ex) {
                    log.error("Unable to stop", (Throwable)ex);
                    this.setShuttingDown(false);
                    return;
                }
            }
            boolean abort = ThreadingUtil.runOnGUIwithReturn(() -> StoreAndCompare.checkPermissionToStoreIfNeeded());
            if (abort) {
                log.info("User aborted the shutdown request due to not having permission to store changes");
                this.setShuttingDown(false);
                return;
            }
            this.closeFrames(start);
            this.runShutDownTasks(new HashSet<Runnable>(this.earlyRunnables), "JMRI ShutDown - Early Tasks");
            StoreAndCompare.requestStoreIfNeeded();
            this.runShutDownTasks(this.runnables, "JMRI ShutDown - Main Tasks");
            log.debug("Shutdown took {} milliseconds.", (Object)(System.currentTimeMillis() - start));
            log.info("Normal termination complete");
            if (exit) {
                System.exit(status);
            }
            this.shutDownComplete = true;
        }
    }

    private void closeFrames(long startTime) {
        if (!GraphicsEnvironment.isHeadless()) {
            Arrays.asList(Frame.getFrames()).stream().forEach(frame -> {
                if (frame.isDisplayable()) {
                    log.debug("Closing frame \"{}\", title: \"{}\"", (Object)frame.getName(), (Object)frame.getTitle());
                    long timer = System.currentTimeMillis();
                    frame.dispatchEvent(new WindowEvent((Window)frame, 201));
                    log.debug("Frame \"{}\" took {} milliseconds to close", (Object)frame.getName(), (Object)(System.currentTimeMillis() - timer));
                }
            });
        }
        log.debug("windows completed closing {} milliseconds after starting shutdown", (Object)(System.currentTimeMillis() - startTime));
    }

    private void runShutDownTasks(Set<Runnable> toRun, String threadName) {
        HashSet<Runnable> sDrunnables = new HashSet<Runnable>(toRun);
        if (sDrunnables.isEmpty()) {
            return;
        }
        JmriThreadPoolExecutor executor = new JmriThreadPoolExecutor(sDrunnables.size(), threadName);
        ArrayList complete = new ArrayList();
        long timeoutEnd = System.currentTimeMillis() + (long)this.tasksTimeOutMilliSec;
        sDrunnables.forEach(runnable -> complete.add(executor.submit((Runnable)runnable)));
        executor.shutdown();
        for (Future future : complete) {
            long remainingTime = timeoutEnd - System.currentTimeMillis();
            if (remainingTime <= 0L) {
                log.error("Timeout reached before all tasks were completed {} {}", (Object)threadName, (Object)future);
                break;
            }
            try {
                future.get(remainingTime, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                log.error("{} Task timed out: {}", (Object)threadName, (Object)future);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {}
        }
        executor.shutdownNow();
    }

    @Override
    public boolean isShuttingDown() {
        return shuttingDown;
    }

    public boolean isShutDownComplete() {
        return this.shutDownComplete;
    }

    protected void setShuttingDown(boolean state) {
        boolean old = shuttingDown;
        DefaultShutDownManager.setStaticShuttingDown(state);
        log.debug("Setting shuttingDown to {}", (Object)state);
        if (!state) {
            this.shutDownComplete = false;
        }
        this.firePropertyChange(PROP_SHUTTING_DOWN, old, state);
    }

    static synchronized void setStaticShuttingDown(boolean state) {
        shuttingDown = state;
    }

    private static class EarlyTask
    implements Runnable {
        final ShutDownTask task;

        EarlyTask(ShutDownTask runnableTask) {
            this.task = runnableTask;
        }

        @Override
        public void run() {
            this.task.runEarly();
        }

        public String toString() {
            return this.task.toString();
        }
    }
}

