/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.SignalGroup;
import jmri.SignalGroupManager;
import jmri.implementation.DefaultSignalGroup;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignalGroupManager
extends AbstractManager<SignalGroup>
implements SignalGroupManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultSignalGroupManager.class);

    public DefaultSignalGroupManager(InternalSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    public int getXMLOrder() {
        return 90;
    }

    @Override
    public char typeLetter() {
        return 'G';
    }

    @Override
    @CheckForNull
    public SignalGroup getSignalGroup(@Nonnull String name) {
        SignalGroup t = this.getByUserName(name);
        if (t != null) {
            return t;
        }
        return this.getBySystemName(name);
    }

    @Override
    @CheckForNull
    public SignalGroup getBySystemName(@Nonnull String key) {
        return (SignalGroup)this._tsys.get(key);
    }

    @Override
    @CheckForNull
    public SignalGroup getByUserName(@Nonnull String key) {
        return (SignalGroup)this._tuser.get(key);
    }

    @Override
    @Nonnull
    public SignalGroup provideSignalGroup(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        SignalGroup r;
        log.debug("provideGroup({})", (Object)systemName);
        if (userName != null && (r = this.getByUserName(userName)) != null) {
            return r;
        }
        r = this.getBySystemName(systemName);
        if (r != null) {
            return r;
        }
        r = new DefaultSignalGroup(systemName, userName);
        this.register(r);
        this.updateAutoNumber(systemName);
        return r;
    }

    @Override
    @Nonnull
    public SignalGroup newSignalGroupWithUserName(@Nonnull String userName) {
        return this.provideSignalGroup(this.getAutoSystemName(), userName);
    }

    List<String> getListOfNames() {
        ArrayList<String> retval = new ArrayList<String>();
        File[] files = new File[]{};
        try {
            File signalDir = new File(FileUtil.findURL("xml/signals", FileUtil.Location.INSTALLED).toURI());
            files = signalDir.listFiles();
        }
        catch (NullPointerException | URISyntaxException ex) {
            log.error("No signals are defined.", (Throwable)ex);
        }
        if (files == null) {
            return retval;
        }
        for (File file : files) {
            File aspects;
            if (!file.isDirectory() || !(aspects = new File(file.getPath() + File.separator + "aspects.xml")).exists()) continue;
            log.debug("found system: {}", (Object)file.getName());
            retval.add(file.getName());
        }
        return retval;
    }

    @Override
    public void deleteSignalGroup(SignalGroup s) {
        this.deregister(s);
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameSignalGroups" : "BeanNameSignalGroup");
    }

    @Override
    public Class<SignalGroup> getNamedBeanClass() {
        return SignalGroup.class;
    }
}

