/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.TurnoutManager;
import jmri.implementation.DccSignalMast;
import jmri.implementation.SignalHeadSignalMast;
import jmri.implementation.SignalMastRepeater;
import jmri.implementation.VirtualSignalMast;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.Bundle;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignalMastManager
extends AbstractManager<SignalMast>
implements SignalMastManager {
    private final ArrayList<SignalMastRepeater> repeaterList = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(DefaultSignalMastManager.class);

    public DefaultSignalMastManager(InternalSystemConnectionMemo memo) {
        super(memo);
        this.addListeners();
    }

    final void addListeners() {
        InstanceManager.getDefault(SignalHeadManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(TurnoutManager.class).addVetoableChangeListener(this);
    }

    @Override
    public int getXMLOrder() {
        return 80;
    }

    @Override
    public char typeLetter() {
        return 'F';
    }

    @Override
    @CheckForNull
    public SignalMast getSignalMast(@Nonnull String name) {
        if (Objects.isNull(name) || name.length() == 0) {
            return null;
        }
        SignalMast t = this.getByUserName(name);
        return t != null ? t : this.getBySystemName(name);
    }

    @Override
    @Nonnull
    public SignalMast provideSignalMast(@Nonnull String prefix, @Nonnull String signalSystem, @Nonnull String mastName, @Nonnull String[] heads) throws JmriException {
        StringBuilder name = new StringBuilder(prefix);
        name.append(":");
        name.append(signalSystem);
        name.append(":");
        name.append(mastName);
        for (String s : heads) {
            name.append("(");
            name.append(StringUtil.parenQuote(s));
            name.append(")");
        }
        return this.provideSignalMast(new String(name));
    }

    @Override
    @Nonnull
    public SignalMast provideSignalMast(@Nonnull String name) throws IllegalArgumentException {
        SignalMast m = this.getSignalMast(name);
        if (m == null) {
            if (name.startsWith("IF$shsm")) {
                m = new SignalHeadSignalMast(name);
            } else if (name.startsWith("IF$dsm")) {
                m = new DccSignalMast(name);
            } else if (name.startsWith("IF$vsm")) {
                m = new VirtualSignalMast(name);
            } else {
                log.warn("building stand-in VirtualSignalMast for {}", (Object)name);
                m = new VirtualSignalMast(name);
            }
            this.register(m);
        }
        return m;
    }

    @Override
    @Nonnull
    public SignalMast provideCustomSignalMast(@Nonnull String systemName, Class<? extends SignalMast> mastClass) throws JmriException {
        SignalMast m = this.getBySystemName(systemName);
        if (m != null) {
            if (!mastClass.isInstance(m)) {
                throw new JmriException("Could not create signal mast " + systemName + ", because the system name is already used by a different kind of mast. Expected " + mastClass.getSimpleName() + ", actual " + m.getClass().getSimpleName() + ".");
            }
            return m;
        }
        try {
            m = mastClass.getConstructor(String.class).newInstance(systemName);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new JmriException(e);
        }
        this.register(m);
        return m;
    }

    @Override
    @CheckForNull
    public SignalMast getBySystemName(@Nonnull String key) {
        return (SignalMast)this._tsys.get(key);
    }

    @Override
    @CheckForNull
    public SignalMast getByUserName(@Nonnull String key) {
        return (SignalMast)this._tuser.get(key);
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameSignalMasts" : "BeanNameSignalMast");
    }

    @Override
    public Class<SignalMast> getNamedBeanClass() {
        return SignalMast.class;
    }

    @Nonnull
    public SignalMastRepeater provideRepeater(@Nonnull SignalMast master, @Nonnull SignalMast slave) throws JmriException {
        SignalMastRepeater rp = null;
        for (SignalMastRepeater currentRepeater : this.repeaterList) {
            if (currentRepeater.getMasterMast() == master && currentRepeater.getSlaveMast() == slave) {
                rp = currentRepeater;
                continue;
            }
            if (currentRepeater.getMasterMast() != slave || currentRepeater.getSlaveMast() != master) continue;
            log.error("Signal repeater {}:{} already exists the wrong way", (Object)master, (Object)slave);
            throw new JmriException("Signal mast repeater already exists the wrong way");
        }
        if (rp == null) {
            rp = new SignalMastRepeater(master, slave);
            this.repeaterList.add(rp);
        }
        this.firePropertyChange("repeaterlength", null, null);
        return rp;
    }

    public void addRepeater(SignalMastRepeater rp) throws JmriException {
        for (SignalMastRepeater rpeat : this.repeaterList) {
            if ((rpeat.getMasterMast() != rp.getMasterMast() || rpeat.getSlaveMast() != rp.getSlaveMast()) && (rpeat.getMasterMast() != rp.getSlaveMast() || rpeat.getSlaveMast() != rp.getMasterMast())) continue;
            log.error("Signal repeater already Exists");
            throw new JmriException("Signal mast Repeater already exists");
        }
        this.repeaterList.add(rp);
        this.firePropertyChange("repeaterlength", null, null);
    }

    public void removeRepeater(SignalMastRepeater rp) {
        rp.dispose();
        this.repeaterList.remove(rp);
        this.firePropertyChange("repeaterlength", null, null);
    }

    public List<SignalMastRepeater> getRepeaterList() {
        return new ArrayList<SignalMastRepeater>(this.repeaterList);
    }

    public void initialiseRepeaters() {
        for (SignalMastRepeater smr : this.repeaterList) {
            smr.initialise();
        }
    }

    @Override
    @Nonnull
    public SignalMast provide(String name) throws IllegalArgumentException {
        return this.provideSignalMast(name);
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(SignalHeadManager.class).removeVetoableChangeListener(this);
        InstanceManager.getDefault(TurnoutManager.class).removeVetoableChangeListener(this);
        super.dispose();
    }
}

