/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.Programmer;
import jmri.ProgrammingMode;
import jmri.beans.PropertyChangeSupport;
import jmri.implementation.AbstractInstanceInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferringProgrammerManager
extends PropertyChangeSupport
implements AddressedProgrammerManager,
GlobalProgrammerManager {
    String userName = "<Default>";
    private static final Logger log = LoggerFactory.getLogger(DeferringProgrammerManager.class);

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String toString() {
        return this.getUserName();
    }

    @Override
    public Programmer getGlobalProgrammer() {
        GlobalProgrammerManager gp = InstanceManager.getNullableDefault(GlobalProgrammerManager.class);
        if (gp == null || this.equals(gp)) {
            log.debug("no defaultGlobal ProgrammerManager, getGlobalProgrammer returns null");
            return null;
        }
        Programmer p = gp.getGlobalProgrammer();
        log.debug("getGlobalProgrammer returns default service-mode programmer of type {} from {}", p != null ? p.getClass() : "(null)", gp.getClass());
        return p;
    }

    @Override
    public Programmer reserveGlobalProgrammer() {
        GlobalProgrammerManager gp = InstanceManager.getNullableDefault(GlobalProgrammerManager.class);
        if (gp == null || this.equals(gp)) {
            return null;
        }
        return gp.reserveGlobalProgrammer();
    }

    @Override
    public void releaseGlobalProgrammer(Programmer p) {
        GlobalProgrammerManager gp = InstanceManager.getNullableDefault(GlobalProgrammerManager.class);
        if (gp == null || this.equals(gp)) {
            return;
        }
        gp.releaseGlobalProgrammer(p);
    }

    @Override
    public boolean isGlobalProgrammerAvailable() {
        GlobalProgrammerManager gp = InstanceManager.getNullableDefault(GlobalProgrammerManager.class);
        if (gp == null || this.equals(gp)) {
            return false;
        }
        return InstanceManager.getDefault(GlobalProgrammerManager.class).isGlobalProgrammerAvailable();
    }

    @Override
    public AddressedProgrammer getAddressedProgrammer(boolean pLongAddress, int pAddress) {
        AddressedProgrammerManager ap = InstanceManager.getNullableDefault(AddressedProgrammerManager.class);
        if (ap == null || this.equals(ap)) {
            return null;
        }
        return ap.getAddressedProgrammer(pLongAddress, pAddress);
    }

    @Override
    public AddressedProgrammer reserveAddressedProgrammer(boolean pLongAddress, int pAddress) {
        AddressedProgrammerManager ap = InstanceManager.getNullableDefault(AddressedProgrammerManager.class);
        if (ap == null || this.equals(ap)) {
            return null;
        }
        return ap.reserveAddressedProgrammer(pLongAddress, pAddress);
    }

    @Override
    public void releaseAddressedProgrammer(AddressedProgrammer p) {
        AddressedProgrammerManager ap = InstanceManager.getNullableDefault(AddressedProgrammerManager.class);
        if (ap == null || this.equals(ap)) {
            return;
        }
        ap.releaseAddressedProgrammer(p);
    }

    @Override
    public boolean isAddressedModePossible() {
        AddressedProgrammerManager ap = InstanceManager.getNullableDefault(AddressedProgrammerManager.class);
        if (ap == null || this.equals(ap)) {
            return false;
        }
        return ap.isAddressedModePossible();
    }

    @Override
    public boolean isAddressedModePossible(LocoAddress l) {
        return this.isAddressedModePossible();
    }

    @Override
    public List<ProgrammingMode> getDefaultModes() {
        AddressedProgrammerManager ap = InstanceManager.getNullableDefault(AddressedProgrammerManager.class);
        if (ap == null || this.equals(ap)) {
            return new ArrayList<ProgrammingMode>();
        }
        return InstanceManager.getDefault(AddressedProgrammerManager.class).getDefaultModes();
    }

    public static final class Initializer
    extends AbstractInstanceInitializer {
        @Override
        public <T> Object getDefault(Class<T> type) {
            if (type == AddressedProgrammerManager.class) {
                return new DeferringProgrammerManager();
            }
            if (type == GlobalProgrammerManager.class) {
                return new DeferringProgrammerManager();
            }
            return super.getDefault(type);
        }

        @Override
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(AddressedProgrammerManager.class);
            set.add(GlobalProgrammerManager.class);
            return set;
        }
    }
}

