/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoInitialize;
import jmri.JmriException;
import jmri.UserPreferencesManager;
import jmri.beans.Bean;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.managers.Bundle;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;
import jmri.swing.JmriJTablePersistenceManager;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.jdom.JDOMUtil;
import jmri.util.node.NodeIdentity;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class JmriUserPreferencesManager
extends Bean
implements UserPreferencesManager,
InstanceManagerAutoInitialize {
    public static final String SAVE_ALLOWED = "saveAllowed";
    private static final String CLASSPREFS_NAMESPACE = "http://jmri.org/xml/schema/auxiliary-configuration/class-preferences-4-3-5.xsd";
    private static final String CLASSPREFS_ELEMENT = "classPreferences";
    private static final String COMBOBOX_NAMESPACE = "http://jmri.org/xml/schema/auxiliary-configuration/combobox-4-3-5.xsd";
    private static final String COMBOBOX_ELEMENT = "comboBoxLastValue";
    private static final String CHECKBOX_NAMESPACE = "http://jmri.org/xml/schema/auxiliary-configuration/checkbox-4-21-3.xsd";
    private static final String CHECKBOX_ELEMENT = "checkBoxLastValue";
    private static final String SETTINGS_NAMESPACE = "http://jmri.org/xml/schema/auxiliary-configuration/settings-4-3-5.xsd";
    private static final String SETTINGS_ELEMENT = "settings";
    private static final String WINDOWS_NAMESPACE = "http://jmri.org/xml/schema/auxiliary-configuration/window-details-4-3-5.xsd";
    private static final String WINDOWS_ELEMENT = "windowDetails";
    private static final String REMINDER = "reminder";
    private static final String JMRI_UTIL_JMRI_JFRAME = "jmri.util.JmriJFrame";
    private static final String CLASS = "class";
    private static final String VALUE = "value";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String PROPERTIES = "properties";
    private boolean dirty = false;
    private boolean loading = false;
    private boolean allowSave = false;
    private final ArrayList<String> simplePreferenceList = new ArrayList();
    private final ArrayList<String> sessionPreferenceList = new ArrayList();
    protected final HashMap<String, String> comboBoxLastSelection = new HashMap();
    protected final HashMap<String, Boolean> checkBoxLastSelection = new HashMap();
    private final HashMap<String, WindowLocations> windowDetails = new HashMap();
    private final HashMap<String, ClassPreferences> classPreferenceList = new HashMap();
    private File file;
    private static final Logger log = LoggerFactory.getLogger(JmriUserPreferencesManager.class);

    public JmriUserPreferencesManager() {
        this.setPreferenceItemDetails(this.getClassName(), REMINDER, Bundle.getMessage("HideReminderLocationMessage"));
        this.classPreferenceList.get(this.getClassName()).setDescription(Bundle.getMessage("UserPreferences"));
        this.allowSave = true;
        this.dirty = false;
    }

    @Override
    public synchronized void setSaveAllowed(boolean saveAllowed) {
        boolean old = this.allowSave;
        this.allowSave = saveAllowed;
        if (saveAllowed && this.dirty) {
            this.savePreferences();
        }
        this.firePropertyChange(SAVE_ALLOWED, old, this.allowSave);
    }

    @Override
    public synchronized boolean isSaveAllowed() {
        return this.allowSave;
    }

    @Override
    public Dimension getScreen() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    @Override
    public void setSimplePreferenceState(String name, boolean state) {
        if (state) {
            if (!this.simplePreferenceList.contains(name)) {
                this.simplePreferenceList.add(name);
            }
        } else {
            this.simplePreferenceList.remove(name);
        }
        this.saveSimplePreferenceState();
    }

    @Override
    public boolean getSimplePreferenceState(String name) {
        return this.simplePreferenceList.contains(name);
    }

    @Override
    @Nonnull
    public ArrayList<String> getSimplePreferenceStateList() {
        return new ArrayList<String>(this.simplePreferenceList);
    }

    @Override
    public void setPreferenceState(String strClass, String item, boolean state) {
        if (strClass.equals("jmri.managers.DefaultUserMessagePreferences")) {
            this.setPreferenceState("jmri.managers.JmriUserPreferencesManager", item, state);
            return;
        }
        if (!this.classPreferenceList.containsKey(strClass)) {
            this.classPreferenceList.put(strClass, new ClassPreferences());
            this.setClassDescription(strClass);
        }
        ArrayList<PreferenceList> a = this.classPreferenceList.get(strClass).getPreferenceList();
        boolean found = false;
        for (int i = 0; i < a.size(); ++i) {
            if (!a.get(i).getItem().equals(item)) continue;
            a.get(i).setState(state);
            found = true;
        }
        if (!found) {
            a.add(new PreferenceList(item, state));
        }
        this.displayRememberMsg();
        this.savePreferencesState();
    }

    @Override
    public boolean getPreferenceState(String strClass, String item) {
        if (this.classPreferenceList.containsKey(strClass)) {
            ArrayList<PreferenceList> a = this.classPreferenceList.get(strClass).getPreferenceList();
            for (int i = 0; i < a.size(); ++i) {
                if (!a.get(i).getItem().equals(item)) continue;
                return a.get(i).getState();
            }
        }
        return false;
    }

    @Override
    public final void setPreferenceItemDetails(String strClass, String item, String description) {
        if (!this.classPreferenceList.containsKey(strClass)) {
            this.classPreferenceList.put(strClass, new ClassPreferences());
        }
        ArrayList<PreferenceList> a = this.classPreferenceList.get(strClass).getPreferenceList();
        for (int i = 0; i < a.size(); ++i) {
            if (!a.get(i).getItem().equals(item)) continue;
            a.get(i).setDescription(description);
            return;
        }
        a.add(new PreferenceList(item, description));
    }

    @Override
    @Nonnull
    public ArrayList<String> getPreferenceList(String strClass) {
        if (this.classPreferenceList.containsKey(strClass)) {
            ArrayList<PreferenceList> a = this.classPreferenceList.get(strClass).getPreferenceList();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < a.size(); ++i) {
                list.add(a.get(i).getItem());
            }
            return list;
        }
        return new ArrayList<String>();
    }

    @Override
    @CheckForNull
    public String getPreferenceItemName(String strClass, int n) {
        if (this.classPreferenceList.containsKey(strClass)) {
            return this.classPreferenceList.get(strClass).getPreferenceName(n);
        }
        return null;
    }

    @Override
    @CheckForNull
    public String getPreferenceItemDescription(String strClass, String item) {
        if (this.classPreferenceList.containsKey(strClass)) {
            ArrayList<PreferenceList> a = this.classPreferenceList.get(strClass).getPreferenceList();
            for (int i = 0; i < a.size(); ++i) {
                if (!a.get(i).getItem().equals(item)) continue;
                return a.get(i).getDescription();
            }
        }
        return null;
    }

    @Override
    public void setSessionPreferenceState(String name, boolean state) {
        if (state) {
            if (!this.sessionPreferenceList.contains(name)) {
                this.sessionPreferenceList.add(name);
            }
        } else {
            this.sessionPreferenceList.remove(name);
        }
    }

    @Override
    public boolean getSessionPreferenceState(String name) {
        return this.sessionPreferenceList.contains(name);
    }

    @Override
    public void showInfoMessage(String title, String message, String strClass, String item) {
        this.showInfoMessage(title, message, strClass, item, false, true);
    }

    @Override
    public void showInfoMessage(@CheckForNull Component parentComponent, String title, String message, String strClass, String item) {
        this.showInfoMessage(parentComponent, title, message, strClass, item, false, true);
    }

    @Override
    public void showErrorMessage(String title, String message, String strClass, String item, boolean sessionOnly, boolean alwaysRemember) {
        this.showMessage(null, title, message, strClass, item, sessionOnly, alwaysRemember, 0);
    }

    @Override
    public void showErrorMessage(@CheckForNull Component parentComponent, String title, String message, String strClass, String item, boolean sessionOnly, boolean alwaysRemember) {
        this.showMessage(parentComponent, title, message, strClass, item, sessionOnly, alwaysRemember, 0);
    }

    @Override
    public void showInfoMessage(String title, String message, String strClass, String item, boolean sessionOnly, boolean alwaysRemember) {
        this.showMessage(null, title, message, strClass, item, sessionOnly, alwaysRemember, 1);
    }

    @Override
    public void showInfoMessage(@CheckForNull Component parentComponent, String title, String message, String strClass, String item, boolean sessionOnly, boolean alwaysRemember) {
        this.showMessage(parentComponent, title, message, strClass, item, sessionOnly, alwaysRemember, 1);
    }

    @Override
    public void showWarningMessage(String title, String message, String strClass, String item, boolean sessionOnly, boolean alwaysRemember) {
        this.showMessage(null, title, message, strClass, item, sessionOnly, alwaysRemember, 2);
    }

    @Override
    public void showWarningMessage(@CheckForNull Component parentComponent, String title, String message, String strClass, String item, boolean sessionOnly, boolean alwaysRemember) {
        this.showMessage(parentComponent, title, message, strClass, item, sessionOnly, alwaysRemember, 2);
    }

    protected void showMessage(@CheckForNull Component parentComponent, String title, String message, String strClass, String item, boolean sessionOnly, boolean alwaysRemember, int type) {
        String preference = strClass + "." + item;
        if (this.getSessionPreferenceState(preference)) {
            return;
        }
        if (!this.getPreferenceState(strClass, item)) {
            JPanel container = new JPanel();
            container.setLayout(new BoxLayout(container, 1));
            container.add(new JLabel(message));
            JCheckBox rememberSession = new JCheckBox(Bundle.getMessage("SkipMessageSession"));
            if (sessionOnly) {
                rememberSession.setFont(rememberSession.getFont().deriveFont(10.0f));
                container.add(rememberSession);
            }
            JCheckBox remember = new JCheckBox(Bundle.getMessage("SkipMessageFuture"));
            if (alwaysRemember) {
                remember.setFont(remember.getFont().deriveFont(10.0f));
                container.add(remember);
            }
            JmriJOptionPane.showMessageDialog(parentComponent, container, title, type);
            if (remember.isSelected()) {
                this.setPreferenceState(strClass, item, true);
            }
            if (rememberSession.isSelected()) {
                this.setSessionPreferenceState(preference, true);
            }
        }
    }

    @Override
    @CheckForNull
    public String getComboBoxLastSelection(String comboBoxName) {
        return this.comboBoxLastSelection.get(comboBoxName);
    }

    @Override
    public void setComboBoxLastSelection(String comboBoxName, String lastValue) {
        this.comboBoxLastSelection.put(comboBoxName, lastValue);
        this.setChangeMade(false);
        this.saveComboBoxLastSelections();
    }

    @Override
    public boolean getCheckboxPreferenceState(String name, boolean defaultState) {
        return this.checkBoxLastSelection.getOrDefault(name, defaultState);
    }

    @Override
    public void setCheckboxPreferenceState(String name, boolean state) {
        this.checkBoxLastSelection.put(name, state);
        this.setChangeMade(false);
        this.saveCheckBoxLastSelections();
    }

    public synchronized boolean getChangeMade() {
        return this.dirty;
    }

    public synchronized void setChangeMade(boolean fireUpdate) {
        this.dirty = true;
        if (fireUpdate) {
            this.firePropertyChange("PreferencesUpdated", null, null);
        }
    }

    @Override
    public synchronized void resetChangeMade() {
        this.dirty = false;
    }

    protected boolean isLoading() {
        return this.loading;
    }

    @Override
    public void setLoading() {
        this.loading = true;
    }

    @Override
    public void finishLoading() {
        this.loading = false;
        this.resetChangeMade();
    }

    public void displayRememberMsg() {
        if (this.loading) {
            return;
        }
        this.showInfoMessage(Bundle.getMessage("Reminder"), Bundle.getMessage("ReminderLine"), this.getClassName(), REMINDER);
    }

    @Override
    public Point getWindowLocation(String strClass) {
        if (this.windowDetails.containsKey(strClass)) {
            return this.windowDetails.get(strClass).getLocation();
        }
        return null;
    }

    @Override
    public Dimension getWindowSize(String strClass) {
        if (this.windowDetails.containsKey(strClass)) {
            return this.windowDetails.get(strClass).getSize();
        }
        return null;
    }

    @Override
    public boolean getSaveWindowSize(String strClass) {
        if (this.windowDetails.containsKey(strClass)) {
            return this.windowDetails.get(strClass).getSaveSize();
        }
        return false;
    }

    @Override
    public boolean getSaveWindowLocation(String strClass) {
        if (this.windowDetails.containsKey(strClass)) {
            return this.windowDetails.get(strClass).getSaveLocation();
        }
        return false;
    }

    @Override
    public void setSaveWindowSize(String strClass, boolean b) {
        if (strClass == null || strClass.equals(JMRI_UTIL_JMRI_JFRAME)) {
            return;
        }
        if (!this.windowDetails.containsKey(strClass)) {
            this.windowDetails.put(strClass, new WindowLocations());
        }
        this.windowDetails.get(strClass).setSaveSize(b);
        this.saveWindowDetails();
    }

    @Override
    public void setSaveWindowLocation(String strClass, boolean b) {
        if (strClass == null || strClass.equals(JMRI_UTIL_JMRI_JFRAME)) {
            return;
        }
        if (!this.windowDetails.containsKey(strClass)) {
            this.windowDetails.put(strClass, new WindowLocations());
        }
        this.windowDetails.get(strClass).setSaveLocation(b);
        this.saveWindowDetails();
    }

    @Override
    public void setWindowLocation(String strClass, Point location) {
        if (strClass == null || strClass.equals(JMRI_UTIL_JMRI_JFRAME)) {
            return;
        }
        if (!this.windowDetails.containsKey(strClass)) {
            this.windowDetails.put(strClass, new WindowLocations());
        }
        this.windowDetails.get(strClass).setLocation(location);
        this.saveWindowDetails();
    }

    @Override
    public void setWindowSize(String strClass, Dimension dim) {
        if (strClass == null || strClass.equals(JMRI_UTIL_JMRI_JFRAME)) {
            return;
        }
        if (!this.windowDetails.containsKey(strClass)) {
            this.windowDetails.put(strClass, new WindowLocations());
        }
        this.windowDetails.get(strClass).setSize(dim);
        this.saveWindowDetails();
    }

    @Override
    public ArrayList<String> getWindowList() {
        return new ArrayList<String>(this.windowDetails.keySet());
    }

    @Override
    public void setProperty(String strClass, String key, Object value) {
        if (strClass.equals(JmriJFrame.class.getName())) {
            return;
        }
        if (!this.windowDetails.containsKey(strClass)) {
            this.windowDetails.put(strClass, new WindowLocations());
        }
        this.windowDetails.get(strClass).setProperty(key, value);
        this.saveWindowDetails();
    }

    @Override
    public Object getProperty(String strClass, String key) {
        if (this.windowDetails.containsKey(strClass)) {
            return this.windowDetails.get(strClass).getProperty(key);
        }
        return null;
    }

    @Override
    public Set<String> getPropertyKeys(String strClass) {
        if (this.windowDetails.containsKey(strClass)) {
            return this.windowDetails.get(strClass).getPropertyKeys();
        }
        return null;
    }

    @Override
    public boolean hasProperties(String strClass) {
        return this.windowDetails.containsKey(strClass);
    }

    @Override
    @Nonnull
    public String getClassDescription(String strClass) {
        if (this.classPreferenceList.containsKey(strClass)) {
            return this.classPreferenceList.get(strClass).getDescription();
        }
        return "";
    }

    @Override
    @Nonnull
    public ArrayList<String> getPreferencesClasses() {
        return new ArrayList<String>(this.classPreferenceList.keySet());
    }

    @Override
    public void setClassDescription(String strClass) {
        try {
            boolean classSetFound;
            boolean classDesFound;
            Method method;
            Object t;
            Class<?> cl = Class.forName(strClass);
            try {
                t = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ExceptionInInitializerError | IllegalArgumentException | NoSuchMethodException | NullPointerException | InvocationTargetException ex) {
                log.error("setClassDescription({}) failed in newInstance", (Object)strClass, (Object)ex);
                return;
            }
            String desc = null;
            try {
                method = cl.getDeclaredMethod("getClassDescription", new Class[0]);
                desc = (String)method.invoke(t, new Object[0]);
                classDesFound = true;
            }
            catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | InvocationTargetException ex) {
                log.debug("Unable to call declared method \"getClassDescription\" with exception", ex);
                classDesFound = false;
            }
            if (!classDesFound) {
                try {
                    method = cl.getMethod("getClassDescription", new Class[0]);
                    desc = (String)method.invoke(t, new Object[0]);
                }
                catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | InvocationTargetException ex) {
                    log.debug("Unable to call undeclared method \"getClassDescription\" with exception", ex);
                    classDesFound = false;
                }
            }
            if (classDesFound) {
                if (!this.classPreferenceList.containsKey(strClass)) {
                    this.classPreferenceList.put(strClass, new ClassPreferences(desc));
                } else {
                    this.classPreferenceList.get(strClass).setDescription(desc);
                }
                this.savePreferencesState();
            }
            try {
                method = cl.getDeclaredMethod("setMessagePreferencesDetails", new Class[0]);
                method.invoke(t, new Object[0]);
                classSetFound = true;
            }
            catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | InvocationTargetException ex) {
                log.debug("Unable to call declared method \"setMessagePreferencesDetails\" with exception", ex);
                classSetFound = false;
            }
            if (!classSetFound) {
                try {
                    method = cl.getMethod("setMessagePreferencesDetails", new Class[0]);
                    method.invoke(t, new Object[0]);
                }
                catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | InvocationTargetException ex) {
                    log.debug("Unable to call undeclared method \"setMessagePreferencesDetails\" with exception", ex);
                }
            }
        }
        catch (ClassNotFoundException ex) {
            log.warn("class name \"{}\" cannot be found, perhaps an expected plugin is missing?", (Object)strClass);
        }
        catch (IllegalAccessException ex) {
            log.error("unable to access class \"{}\"", (Object)strClass, (Object)ex);
        }
        catch (InstantiationException ex) {
            log.error("unable to get a class name \"{}\"", (Object)strClass, (Object)ex);
        }
    }

    @Override
    public void setMessageItemDetails(String strClass, String item, String description, HashMap<Integer, String> options, int defaultOption) {
        if (!this.classPreferenceList.containsKey(strClass)) {
            this.classPreferenceList.put(strClass, new ClassPreferences());
        }
        ArrayList<MultipleChoice> a = this.classPreferenceList.get(strClass).getMultipleChoiceList();
        for (int i = 0; i < a.size(); ++i) {
            if (!a.get(i).getItem().equals(item)) continue;
            a.get(i).setMessageItems(description, options, defaultOption);
            return;
        }
        a.add(new MultipleChoice(description, item, options, defaultOption));
    }

    @Override
    public HashMap<Integer, String> getChoiceOptions(String strClass, String item) {
        if (this.classPreferenceList.containsKey(strClass)) {
            ArrayList<MultipleChoice> a = this.classPreferenceList.get(strClass).getMultipleChoiceList();
            for (int i = 0; i < a.size(); ++i) {
                if (!a.get(i).getItem().equals(item)) continue;
                return a.get(i).getOptions();
            }
        }
        return new HashMap<Integer, String>();
    }

    @Override
    public int getMultipleChoiceSize(String strClass) {
        if (this.classPreferenceList.containsKey(strClass)) {
            return this.classPreferenceList.get(strClass).getMultipleChoiceListSize();
        }
        return 0;
    }

    @Override
    public ArrayList<String> getMultipleChoiceList(String strClass) {
        if (this.classPreferenceList.containsKey(strClass)) {
            ArrayList<MultipleChoice> a = this.classPreferenceList.get(strClass).getMultipleChoiceList();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < a.size(); ++i) {
                list.add(a.get(i).getItem());
            }
            return list;
        }
        return new ArrayList<String>();
    }

    @Override
    public String getChoiceName(String strClass, int n) {
        if (this.classPreferenceList.containsKey(strClass)) {
            return this.classPreferenceList.get(strClass).getChoiceName(n);
        }
        return null;
    }

    @Override
    public String getChoiceDescription(String strClass, String item) {
        if (this.classPreferenceList.containsKey(strClass)) {
            ArrayList<MultipleChoice> a = this.classPreferenceList.get(strClass).getMultipleChoiceList();
            for (int i = 0; i < a.size(); ++i) {
                if (!a.get(i).getItem().equals(item)) continue;
                return a.get(i).getOptionDescription();
            }
        }
        return null;
    }

    @Override
    public int getMultipleChoiceOption(String strClass, String item) {
        if (this.classPreferenceList.containsKey(strClass)) {
            ArrayList<MultipleChoice> a = this.classPreferenceList.get(strClass).getMultipleChoiceList();
            for (int i = 0; i < a.size(); ++i) {
                if (!a.get(i).getItem().equals(item)) continue;
                return a.get(i).getValue();
            }
        }
        return 0;
    }

    @Override
    public int getMultipleChoiceDefaultOption(String strClass, String choice) {
        if (this.classPreferenceList.containsKey(strClass)) {
            ArrayList<MultipleChoice> a = this.classPreferenceList.get(strClass).getMultipleChoiceList();
            for (int i = 0; i < a.size(); ++i) {
                if (!a.get(i).getItem().equals(choice)) continue;
                return a.get(i).getDefaultValue();
            }
        }
        return 0;
    }

    @Override
    public void setMultipleChoiceOption(String strClass, String choice, String value) {
        if (!this.classPreferenceList.containsKey(strClass)) {
            this.classPreferenceList.put(strClass, new ClassPreferences());
        }
        this.classPreferenceList.get(strClass).getMultipleChoiceList().stream().filter(mc -> mc.getItem().equals(choice)).forEachOrdered(mc -> mc.setValue(value));
        this.savePreferencesState();
    }

    @Override
    public void setMultipleChoiceOption(String strClass, String choice, int value) {
        if ("jmri.jmrit.beantable.AbstractLogixNGTableAction".equals(strClass)) {
            return;
        }
        if ("jmri.jmrit.logixng.tools.swing.TreeEditor".equals(strClass)) {
            return;
        }
        if (!this.classPreferenceList.containsKey(strClass)) {
            this.classPreferenceList.put(strClass, new ClassPreferences());
        }
        boolean set = false;
        for (MultipleChoice mc : this.classPreferenceList.get(strClass).getMultipleChoiceList()) {
            if (!mc.getItem().equals(choice)) continue;
            mc.setValue(value);
            set = true;
        }
        if (!set) {
            this.classPreferenceList.get(strClass).getMultipleChoiceList().add(new MultipleChoice(choice, value));
            this.setClassDescription(strClass);
        }
        this.displayRememberMsg();
        this.savePreferencesState();
    }

    public String getClassDescription() {
        return "Preference Manager";
    }

    protected final String getClassName() {
        return this.getClass().getName();
    }

    protected final ClassPreferences getClassPreferences(String strClass) {
        return this.classPreferenceList.get(strClass);
    }

    @Override
    public int getPreferencesSize(String strClass) {
        if (this.classPreferenceList.containsKey(strClass)) {
            return this.classPreferenceList.get(strClass).getPreferencesSize();
        }
        return 0;
    }

    public final void readUserPreferences() {
        log.trace("starting readUserPreferences");
        this.allowSave = false;
        this.loading = true;
        File perNodeConfig = null;
        try {
            perNodeConfig = FileUtil.getFile("profile:profile/" + NodeIdentity.storageIdentity() + "/user-interface.xml");
            if (!perNodeConfig.canRead()) {
                perNodeConfig = null;
                log.trace("    sharedConfig can't be read");
            }
        }
        catch (FileNotFoundException ex) {
            log.trace("    FileNotFoundException: sharedConfig does not exist");
        }
        if (perNodeConfig != null) {
            this.file = perNodeConfig;
            log.debug("  start perNodeConfig file: {}", (Object)this.file.getPath());
            this.readComboBoxLastSelections();
            this.readCheckBoxLastSelections();
            this.readPreferencesState();
            this.readSimplePreferenceState();
            this.readWindowDetails();
        } else {
            try {
                this.file = FileUtil.getFile("profile:UserPrefsProfileConfig.xml");
                if (this.file.exists()) {
                    log.debug("start load user pref file: {}", (Object)this.file.getPath());
                    try {
                        InstanceManager.getDefault(ConfigureManager.class).load(this.file, true);
                        this.allowSave = true;
                        this.savePreferences();
                    }
                    catch (JmriException e) {
                        log.error("Unhandled problem loading configuration: {}", (Object)e.getMessage());
                    }
                    catch (NullPointerException e) {
                        log.error("NPE when trying to load user pref {}", (Object)this.file);
                    }
                } else {
                    log.info("No saved user preferences file");
                }
            }
            catch (FileNotFoundException ex) {
                log.debug("UserPrefsProfileConfig.xml does not exist");
            }
        }
        this.loading = false;
        this.allowSave = true;
        log.trace("  ending readUserPreferences");
    }

    private void readComboBoxLastSelections() {
        org.jdom2.Element element = this.readElement(COMBOBOX_ELEMENT, COMBOBOX_NAMESPACE);
        if (element != null) {
            element.getChildren("comboBox").stream().forEach(combo -> this.comboBoxLastSelection.put(combo.getAttributeValue("name"), combo.getAttributeValue("lastSelected")));
        }
    }

    private void saveComboBoxLastSelections() {
        this.setChangeMade(false);
        if (this.allowSave && !this.comboBoxLastSelection.isEmpty()) {
            org.jdom2.Element element = new org.jdom2.Element(COMBOBOX_ELEMENT, COMBOBOX_NAMESPACE);
            this.comboBoxLastSelection.entrySet().stream().filter(cbls -> cbls.getValue() != null && !((String)cbls.getValue()).isEmpty()).map(cbls -> {
                org.jdom2.Element combo = new org.jdom2.Element("comboBox");
                combo.setAttribute("name", (String)cbls.getKey());
                combo.setAttribute("lastSelected", (String)cbls.getValue());
                return combo;
            }).forEach(arg_0 -> ((org.jdom2.Element)element).addContent(arg_0));
            this.saveElement(element);
            this.resetChangeMade();
        }
    }

    private void readCheckBoxLastSelections() {
        org.jdom2.Element element = this.readElement(CHECKBOX_ELEMENT, CHECKBOX_NAMESPACE);
        if (element != null) {
            element.getChildren("checkBox").stream().forEach(checkbox -> this.checkBoxLastSelection.put(checkbox.getAttributeValue("name"), "yes".equals(checkbox.getAttributeValue("lastChecked"))));
        }
    }

    private void saveCheckBoxLastSelections() {
        this.setChangeMade(false);
        if (this.allowSave && !this.checkBoxLastSelection.isEmpty()) {
            org.jdom2.Element element = new org.jdom2.Element(CHECKBOX_ELEMENT, CHECKBOX_NAMESPACE);
            this.checkBoxLastSelection.entrySet().stream().filter(cbls -> cbls.getValue() != null).map(cbls -> {
                org.jdom2.Element checkbox = new org.jdom2.Element("checkBox");
                checkbox.setAttribute("name", (String)cbls.getKey());
                checkbox.setAttribute("lastChecked", (Boolean)cbls.getValue() != false ? "yes" : "no");
                return checkbox;
            }).forEach(arg_0 -> ((org.jdom2.Element)element).addContent(arg_0));
            this.saveElement(element);
            this.resetChangeMade();
        }
    }

    private void readPreferencesState() {
        org.jdom2.Element element = this.readElement(CLASSPREFS_ELEMENT, CLASSPREFS_NAMESPACE);
        if (element != null) {
            element.getChildren("preferences").stream().forEach(preferences -> {
                String clazz = preferences.getAttributeValue(CLASS);
                log.debug("Reading class preferences for \"{}\"", (Object)clazz);
                preferences.getChildren("multipleChoice").stream().forEach(mc -> mc.getChildren("option").stream().forEach(option -> {
                    int value = 0;
                    try {
                        value = option.getAttribute(VALUE).getIntValue();
                    }
                    catch (DataConversionException ex) {
                        log.error("failed to convert positional attribute");
                    }
                    this.setMultipleChoiceOption(clazz, option.getAttributeValue("item"), value);
                }));
                preferences.getChildren("reminderPrompts").stream().forEach(rp -> rp.getChildren(REMINDER).stream().forEach(reminder -> {
                    log.debug("Setting preferences state \"true\" for \"{}\", \"{}\"", (Object)clazz, (Object)reminder.getText());
                    this.setPreferenceState(clazz, reminder.getText(), true);
                }));
            });
        }
    }

    private void savePreferencesState() {
        this.setChangeMade(true);
        if (this.allowSave) {
            org.jdom2.Element element = new org.jdom2.Element(CLASSPREFS_ELEMENT, CLASSPREFS_NAMESPACE);
            this.classPreferenceList.keySet().stream().forEach(name -> {
                ClassPreferences cp = this.classPreferenceList.get(name);
                if (!cp.multipleChoiceList.isEmpty() || !cp.preferenceList.isEmpty()) {
                    org.jdom2.Element clazz = new org.jdom2.Element("preferences");
                    clazz.setAttribute(CLASS, name);
                    if (!cp.multipleChoiceList.isEmpty()) {
                        org.jdom2.Element choices = new org.jdom2.Element("multipleChoice");
                        cp.multipleChoiceList.stream().filter(mc -> mc.getDefaultValue() != mc.getValue()).forEach(mc -> choices.addContent((Content)new org.jdom2.Element("option").setAttribute("item", mc.getItem()).setAttribute(VALUE, Integer.toString(mc.getValue()))));
                        if (!choices.getChildren().isEmpty()) {
                            clazz.addContent((Content)choices);
                        }
                    }
                    if (!cp.preferenceList.isEmpty()) {
                        org.jdom2.Element reminders = new org.jdom2.Element("reminderPrompts");
                        cp.preferenceList.stream().filter(pl -> pl.getState()).forEach(pl -> reminders.addContent((Content)new org.jdom2.Element(REMINDER).addContent(pl.getItem())));
                        if (!reminders.getChildren().isEmpty()) {
                            clazz.addContent((Content)reminders);
                        }
                    }
                    element.addContent((Content)clazz);
                }
            });
            if (!element.getChildren().isEmpty()) {
                this.saveElement(element);
            }
        }
    }

    private void readSimplePreferenceState() {
        org.jdom2.Element element = this.readElement(SETTINGS_ELEMENT, SETTINGS_NAMESPACE);
        if (element != null) {
            element.getChildren("setting").stream().forEach(setting -> this.simplePreferenceList.add(setting.getText()));
        }
    }

    private void saveSimplePreferenceState() {
        this.setChangeMade(false);
        if (this.allowSave) {
            org.jdom2.Element element = new org.jdom2.Element(SETTINGS_ELEMENT, SETTINGS_NAMESPACE);
            this.getSimplePreferenceStateList().stream().forEach(setting -> element.addContent((Content)new org.jdom2.Element("setting").addContent(setting)));
            this.saveElement(element);
            this.resetChangeMade();
        }
    }

    private void readWindowDetails() {
        org.jdom2.Element element = this.readElement(WINDOWS_ELEMENT, WINDOWS_NAMESPACE);
        if (element != null) {
            element.getChildren("window").stream().forEach(window -> {
                String reference = window.getAttributeValue(CLASS);
                log.debug("Reading window details for {}", (Object)reference);
                try {
                    if (window.getAttribute("locX") != null && window.getAttribute("locY") != null) {
                        double x = window.getAttribute("locX").getDoubleValue();
                        double y = window.getAttribute("locY").getDoubleValue();
                        this.setWindowLocation(reference, new Point((int)x, (int)y));
                    }
                    if (window.getAttribute(WIDTH) != null && window.getAttribute(HEIGHT) != null) {
                        double width = window.getAttribute(WIDTH).getDoubleValue();
                        double height = window.getAttribute(HEIGHT).getDoubleValue();
                        this.setWindowSize(reference, new Dimension((int)width, (int)height));
                    }
                }
                catch (DataConversionException ex) {
                    log.error("Unable to read dimensions of window \"{}\"", (Object)reference);
                }
                if (window.getChild(PROPERTIES) != null) {
                    window.getChild(PROPERTIES).getChildren().stream().forEach(property -> {
                        String key = property.getChild("key").getText();
                        try {
                            Class<?> cl = Class.forName(property.getChild(VALUE).getAttributeValue(CLASS));
                            Constructor<?> ctor = cl.getConstructor(String.class);
                            Object value = ctor.newInstance(property.getChild(VALUE).getText());
                            log.debug("Setting property {} for {} to {}", new Object[]{key, reference, value});
                            this.setProperty(reference, key, value);
                        }
                        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                            log.error("Unable to retrieve property \"{}\" for window \"{}\"", (Object)key, (Object)reference);
                        }
                        catch (NullPointerException ex) {
                            log.debug("Property \"{}\" for window \"{}\" is null", (Object)key, (Object)reference);
                        }
                    });
                }
            });
        }
    }

    @SuppressFBWarnings(value={"DMI_ENTRY_SETS_MAY_REUSE_ENTRY_OBJECTS"}, justification="needs to copy the items of the hashmap windowDetails")
    private void saveWindowDetails() {
        this.setChangeMade(false);
        if (this.allowSave && !this.windowDetails.isEmpty()) {
            org.jdom2.Element element = new org.jdom2.Element(WINDOWS_ELEMENT, WINDOWS_NAMESPACE);
            HashSet<Map.Entry<String, WindowLocations>> entries = new HashSet<Map.Entry<String, WindowLocations>>(this.windowDetails.entrySet());
            for (Map.Entry entry : entries) {
                org.jdom2.Element window = new org.jdom2.Element("window");
                window.setAttribute(CLASS, (String)entry.getKey());
                if (((WindowLocations)entry.getValue()).getSaveLocation()) {
                    try {
                        window.setAttribute("locX", Double.toString(((WindowLocations)entry.getValue()).getLocation().getX()));
                        window.setAttribute("locY", Double.toString(((WindowLocations)entry.getValue()).getLocation().getY()));
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (((WindowLocations)entry.getValue()).getSaveSize()) {
                    try {
                        double height = ((WindowLocations)entry.getValue()).getSize().getHeight();
                        double width = ((WindowLocations)entry.getValue()).getSize().getWidth();
                        if (height != 0.0 || width != 0.0) {
                            window.setAttribute(WIDTH, Double.toString(width));
                            window.setAttribute(HEIGHT, Double.toString(height));
                        }
                    }
                    catch (NullPointerException height) {
                        // empty catch block
                    }
                }
                if (!((WindowLocations)entry.getValue()).parameters.isEmpty()) {
                    org.jdom2.Element properties = new org.jdom2.Element(PROPERTIES);
                    ((WindowLocations)entry.getValue()).parameters.entrySet().stream().map(property -> {
                        org.jdom2.Element propertyElement = new org.jdom2.Element("property");
                        propertyElement.addContent((Content)new org.jdom2.Element("key").setText((String)property.getKey()));
                        Object value = property.getValue();
                        if (value != null) {
                            propertyElement.addContent((Content)new org.jdom2.Element(VALUE).setAttribute(CLASS, value.getClass().getName()).setText(value.toString()));
                        }
                        return propertyElement;
                    }).forEach(arg_0 -> ((org.jdom2.Element)properties).addContent(arg_0));
                    window.addContent((Content)properties);
                }
                element.addContent((Content)window);
            }
            this.saveElement(element);
            this.resetChangeMade();
        }
    }

    @CheckForNull
    private org.jdom2.Element readElement(@Nonnull String elementName, @Nonnull String namespace) {
        Element element = ProfileUtils.getUserInterfaceConfiguration(ProfileManager.getDefault().getActiveProfile()).getConfigurationFragment(elementName, namespace, false);
        if (element != null) {
            return JDOMUtil.toJDOMElement(element);
        }
        return null;
    }

    protected void saveElement(@Nonnull org.jdom2.Element element) {
        log.trace("Saving {} element.", (Object)element.getName());
        try {
            ProfileUtils.getUserInterfaceConfiguration(ProfileManager.getDefault().getActiveProfile()).putConfigurationFragment(JDOMUtil.toW3CElement(element), false);
        }
        catch (JDOMException ex) {
            log.error("Unable to save user preferences", (Throwable)ex);
        }
    }

    private void savePreferences() {
        this.saveComboBoxLastSelections();
        this.saveCheckBoxLastSelections();
        this.savePreferencesState();
        this.saveSimplePreferenceState();
        this.saveWindowDetails();
        this.resetChangeMade();
        InstanceManager.getOptionalDefault(JmriJTablePersistenceManager.class).ifPresent(manager -> manager.savePreferences(ProfileManager.getDefault().getActiveProfile()));
    }

    @Override
    public void initialize() {
        this.readUserPreferences();
    }

    public static class Initializer
    extends AbstractInstanceInitializer {
        @Override
        public <T> Object getDefault(Class<T> type) {
            if (type.equals(UserPreferencesManager.class)) {
                return new JmriUserPreferencesManager();
            }
            return super.getDefault(type);
        }

        @Override
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(UserPreferencesManager.class);
            return set;
        }
    }

    protected static final class WindowLocations {
        private Point xyLocation = new Point(0, 0);
        private Dimension size = new Dimension(0, 0);
        private boolean saveSize = false;
        private boolean saveLocation = false;
        final ConcurrentHashMap<String, Object> parameters = new ConcurrentHashMap();

        WindowLocations() {
        }

        Point getLocation() {
            return this.xyLocation;
        }

        Dimension getSize() {
            return this.size;
        }

        void setSaveSize(boolean b) {
            this.saveSize = b;
        }

        void setSaveLocation(boolean b) {
            this.saveLocation = b;
        }

        boolean getSaveSize() {
            return this.saveSize;
        }

        boolean getSaveLocation() {
            return this.saveLocation;
        }

        void setLocation(Point xyLocation) {
            this.xyLocation = xyLocation;
            this.saveLocation = true;
        }

        void setSize(Dimension size) {
            this.size = size;
            this.saveSize = true;
        }

        void setProperty(@Nonnull String key, @CheckForNull Object value) {
            if (value == null) {
                this.parameters.remove(key);
            } else {
                this.parameters.put(key, value);
            }
        }

        @CheckForNull
        Object getProperty(String key) {
            return this.parameters.get(key);
        }

        Set<String> getPropertyKeys() {
            return this.parameters.keySet();
        }
    }

    protected static final class PreferenceList {
        boolean set = false;
        String item = "";
        String description = "";

        PreferenceList(String item) {
            this.item = item;
        }

        PreferenceList(String item, boolean state) {
            this.item = item;
            this.set = state;
        }

        PreferenceList(String item, String description) {
            this.description = description;
            this.item = item;
        }

        void setDescription(String desc) {
            this.description = desc;
        }

        String getDescription() {
            return this.description;
        }

        boolean getState() {
            return this.set;
        }

        void setState(boolean state) {
            this.set = state;
        }

        String getItem() {
            return this.item;
        }
    }

    protected static final class MultipleChoice {
        HashMap<Integer, String> options;
        String optionDescription;
        String item;
        int value = -1;
        int defaultOption = -1;

        MultipleChoice(String description, String item, HashMap<Integer, String> options, int defaultOption) {
            this.item = item;
            this.setMessageItems(description, options, defaultOption);
        }

        MultipleChoice(String item, int value) {
            this.item = item;
            this.value = value;
        }

        void setValue(int value) {
            this.value = value;
        }

        void setValue(String value) {
            this.options.keySet().stream().filter(o -> this.options.get(o).equals(value)).forEachOrdered(o -> {
                this.value = o;
            });
        }

        void setMessageItems(String description, HashMap<Integer, String> options, int defaultOption) {
            this.optionDescription = description;
            this.options = options;
            this.defaultOption = defaultOption;
            if (this.value == -1) {
                this.value = defaultOption;
            }
        }

        int getValue() {
            return this.value;
        }

        int getDefaultValue() {
            return this.defaultOption;
        }

        String getItem() {
            return this.item;
        }

        String getOptionDescription() {
            return this.optionDescription;
        }

        HashMap<Integer, String> getOptions() {
            return this.options;
        }
    }

    protected static final class ClassPreferences {
        String classDescription;
        ArrayList<MultipleChoice> multipleChoiceList = new ArrayList();
        ArrayList<PreferenceList> preferenceList = new ArrayList();

        ClassPreferences() {
        }

        ClassPreferences(String classDescription) {
            this.classDescription = classDescription;
        }

        String getDescription() {
            return this.classDescription;
        }

        void setDescription(String description) {
            this.classDescription = description;
        }

        ArrayList<PreferenceList> getPreferenceList() {
            return this.preferenceList;
        }

        int getPreferenceListSize() {
            return this.preferenceList.size();
        }

        ArrayList<MultipleChoice> getMultipleChoiceList() {
            return this.multipleChoiceList;
        }

        int getPreferencesSize() {
            return this.multipleChoiceList.size() + this.preferenceList.size();
        }

        public String getPreferenceName(int n) {
            try {
                return this.preferenceList.get(n).getItem();
            }
            catch (IndexOutOfBoundsException ioob) {
                return null;
            }
        }

        int getMultipleChoiceListSize() {
            return this.multipleChoiceList.size();
        }

        public String getChoiceName(int n) {
            try {
                return this.multipleChoiceList.get(n).getItem();
            }
            catch (IndexOutOfBoundsException ioob) {
                return null;
            }
        }
    }
}

