/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammerManager;
import jmri.CommandStation;
import jmri.ConfigureManager;
import jmri.ConsistManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.PowerManager;
import jmri.SystemConnectionMemo;
import jmri.ThrottleManager;
import jmri.jmrix.SystemConnectionMemoManager;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.Bundle;
import jmri.profile.Profile;
import jmri.profile.ProfileUtils;
import jmri.util.prefs.AbstractPreferencesManager;
import jmri.util.prefs.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerDefaultSelector
extends AbstractPreferencesManager {
    public final HashMap<Class<?>, String> defaults = new HashMap();
    private PropertyChangeListener memoListener;
    private boolean allInternalDefaultsValid = false;
    public static final String ALL_INTERNAL_DEFAULTS = "allInternalDefaults";
    public final Item[] knownManagers = new Item[]{new Item("<html>Throttles</html>", ThrottleManager.class), new Item("<html>Power<br>Control</html>", PowerManager.class), new Item("<html>Command<br>Station</html>", CommandStation.class), new Item("<html>Service<br>Programmer</html>", GlobalProgrammerManager.class), new Item("<html>Ops Mode<br>Programmer</html>", AddressedProgrammerManager.class), new Item("<html>Consists</html>", ConsistManager.class)};
    private static final Logger log = LoggerFactory.getLogger(ManagerDefaultSelector.class);

    public ManagerDefaultSelector() {
        this.memoListener = e -> {
            log.trace("memoListener fired via {}", (Object)e);
            switch (e.getPropertyName()) {
                case "ConnectionNameChanged": {
                    String oldName = (String)e.getOldValue();
                    String newName = (String)e.getNewValue();
                    log.debug("ConnectionNameChanged from \"{}\" to \"{}\"", (Object)oldName, (Object)newName);
                    new HashSet(this.defaults.keySet()).forEach(c -> {
                        String connectionName = this.defaults.get(c);
                        if (connectionName.equals(oldName)) {
                            this.defaults.put((Class<?>)c, newName);
                        }
                    });
                    this.firePropertyChange("Updated", null, null);
                    break;
                }
                case "ConnectionDisabled": {
                    Boolean newState = (Boolean)e.getNewValue();
                    if (!newState.booleanValue()) break;
                    String disabledName = ((SystemConnectionMemo)e.getSource()).getUserName();
                    log.debug("ConnectionDisabled true: \"{}\"", (Object)disabledName);
                    this.removeConnectionAsDefault(disabledName);
                    break;
                }
                default: {
                    log.debug("ignoring notification of \"{}\"", (Object)e.getPropertyName());
                }
            }
        };
        SystemConnectionMemoManager.getDefault().addPropertyChangeListener(e -> {
            log.trace("addPropertyChangeListener fired via {}", (Object)e);
            switch (e.getPropertyName()) {
                case "ConnectionRemoved": {
                    if (!(e.getOldValue() instanceof SystemConnectionMemo)) break;
                    SystemConnectionMemo memo = (SystemConnectionMemo)e.getOldValue();
                    String removedName = ((SystemConnectionMemo)e.getOldValue()).getUserName();
                    log.debug("ConnectionRemoved for \"{}\"", (Object)removedName);
                    this.removeConnectionAsDefault(removedName);
                    memo.removePropertyChangeListener(this.memoListener);
                    break;
                }
                case "ConnectionAdded": {
                    if (!(e.getNewValue() instanceof SystemConnectionMemo)) break;
                    SystemConnectionMemo memo = (SystemConnectionMemo)e.getNewValue();
                    memo.addPropertyChangeListener(this.memoListener);
                    List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
                    if (log.isDebugEnabled()) {
                        log.debug("Start CONNECTION_ADDED processing with {} existing", (Object)list.size());
                        for (int i = 0; i < list.size(); ++i) {
                            log.debug("    System {}: {} (\"{}\")", new Object[]{i, list.get(i), list.get(i).getUserName()});
                        }
                    }
                    if (list.size() == 1 && !(list.get(0) instanceof InternalSystemConnectionMemo) || list.size() == 2 && !(list.get(0) instanceof InternalSystemConnectionMemo) && list.get(1) instanceof InternalSystemConnectionMemo) {
                        log.debug("First real system added, reset defaults");
                        for (Item item : this.knownManagers) {
                            if (!memo.provides(item.managerClass)) continue;
                            this.setDefault(item.managerClass, memo.getUserName());
                        }
                    }
                    new HashSet(this.defaults.keySet()).forEach(cls -> {
                        String userName = this.defaults.get(cls);
                        if (userName == null && memo.provides((Class<?>)cls)) {
                            this.setDefault((Class<?>)cls, memo.getUserName());
                        }
                    });
                    break;
                }
                default: {
                    log.debug("ignoring notification of \"{}\"", (Object)e.getPropertyName());
                }
            }
        });
        InstanceManager.getList(SystemConnectionMemo.class).forEach(memo -> memo.addPropertyChangeListener(this.memoListener));
    }

    void removeConnectionAsDefault(String removedName) {
        ArrayList tmpArray = new ArrayList();
        this.defaults.keySet().stream().forEach(c -> {
            String connectionName = this.defaults.get(c);
            if (connectionName.equals(removedName)) {
                log.debug("Connection {} has been removed as the default for {}", (Object)removedName, c);
                tmpArray.add(c);
            }
        });
        tmpArray.stream().forEach(tmpArray1 -> this.defaults.remove(tmpArray1));
        this.firePropertyChange("Updated", null, null);
    }

    public String getDefault(Class<?> managerClass) {
        return this.defaults.get(managerClass);
    }

    public void setDefault(Class<?> managerClass, String userName) {
        for (Item item : this.knownManagers) {
            if (!item.managerClass.equals(managerClass)) continue;
            log.debug("   setting default for \"{}\" to \"{}\" by request", managerClass, (Object)userName);
            this.defaults.put(managerClass, userName);
            return;
        }
        log.warn("Ignoring preference for class {} with name {}", managerClass, (Object)userName);
    }

    @CheckForNull
    public InitializationException configure(Profile profile) {
        InitializationException error = null;
        List<SystemConnectionMemo> connList = InstanceManager.getList(SystemConnectionMemo.class);
        log.debug("configure defaults into InstanceManager from {} memos, {} defaults", (Object)connList.size(), (Object)this.defaults.keySet().size());
        HashSet keys = new HashSet(this.defaults.keySet());
        for (Class clazz : keys) {
            String connectionName = this.defaults.get(clazz);
            boolean found = false;
            for (SystemConnectionMemo memo : connList) {
                String testName = memo.getUserName();
                if (testName.equals(connectionName)) {
                    found = true;
                    try {
                        if (!memo.provides(clazz)) break;
                        log.debug("   setting default for \"{}\" to \"{}\" in configure", (Object)clazz, memo.get(clazz));
                        InstanceManager.setDefault(clazz, memo.get(clazz));
                    }
                    catch (NullPointerException ex) {
                        String englishMsg = Bundle.getMessage(Locale.ENGLISH, "ErrorNullDefault", memo.getUserName(), clazz);
                        String localizedMsg = Bundle.getMessage("ErrorNullDefault", memo.getUserName(), clazz);
                        error = new InitializationException(englishMsg, localizedMsg);
                        log.warn("SystemConnectionMemo for {} ({}) provides a null {} instance", new Object[]{memo.getUserName(), memo.getClass(), clazz});
                    }
                    break;
                }
                log.debug("   memo name didn't match: {} vs {}", (Object)testName, (Object)connectionName);
            }
            if (found) continue;
            log.debug("!found, so resetting");
            String currentName = null;
            if (clazz == ThrottleManager.class && InstanceManager.getOptionalDefault(ThrottleManager.class).isPresent()) {
                currentName = InstanceManager.throttleManagerInstance().getUserName();
            } else if (clazz == PowerManager.class && InstanceManager.getOptionalDefault(PowerManager.class).isPresent()) {
                currentName = InstanceManager.getDefault(PowerManager.class).getUserName();
            }
            if (currentName == null) continue;
            log.warn("The configured {} for {} can not be found so will use the default {}", new Object[]{connectionName, clazz, currentName});
            this.defaults.put(clazz, currentName);
        }
        if (!this.isPreferencesValid(profile, connList)) {
            error = new InitializationException(Bundle.getMessage(Locale.ENGLISH, "ManagerDefaultSelector.AllInternal"), Bundle.getMessage("ManagerDefaultSelector.AllInternal"));
        }
        return error;
    }

    @Override
    public void initialize(Profile profile) throws InitializationException {
        if (!this.isInitialized(profile)) {
            Preferences preferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
            Preferences defaultsPreferences = preferences.node("defaults");
            try {
                for (String name : defaultsPreferences.keys()) {
                    String connection = defaultsPreferences.get(name, null);
                    Class<?> cls = this.classForName(name);
                    log.debug("Loading default {} for {}", (Object)connection, (Object)name);
                    if (cls == null) continue;
                    this.defaults.put(cls, connection);
                    log.debug("Loaded default {} for {}", (Object)connection, cls);
                }
                this.allInternalDefaultsValid = preferences.getBoolean(ALL_INTERNAL_DEFAULTS, this.allInternalDefaultsValid);
            }
            catch (BackingStoreException ex) {
                log.info("Unable to read preferences for Default Selector.");
            }
            InitializationException ex = this.configure(profile);
            InstanceManager.getOptionalDefault(ConfigureManager.class).ifPresent(manager -> manager.registerPref(this));
            this.setInitialized(profile, true);
            if (ex != null) {
                this.addInitializationException(profile, ex);
                throw ex;
            }
        }
    }

    @Override
    public void savePreferences(Profile profile) {
        Preferences preferences = ProfileUtils.getPreferences(profile, this.getClass(), true);
        Preferences defaultsPreferences = preferences.node("defaults");
        try {
            this.defaults.keySet().stream().forEach(cls -> defaultsPreferences.put(this.nameForClass((Class<?>)cls), this.defaults.get(cls)));
            preferences.putBoolean(ALL_INTERNAL_DEFAULTS, this.allInternalDefaultsValid);
            preferences.sync();
        }
        catch (BackingStoreException ex) {
            log.error("Unable to save preferences for Default Selector.", (Throwable)ex);
        }
    }

    private boolean isPreferencesValid(Profile profile, List<SystemConnectionMemo> connections) {
        log.trace("isPreferencesValid start");
        if (this.allInternalDefaultsValid) {
            log.trace("allInternalDefaultsValid returns true");
            return true;
        }
        boolean usesExternalConnections = false;
        HashMap<Class, Set> providing = new HashMap<Class, Set>();
        HashSet providers = new HashSet();
        if (connections.size() > 1) {
            connections.stream().filter(memo -> !(memo instanceof InternalSystemConnectionMemo)).forEachOrdered(memo -> {
                for (Item item : this.knownManagers) {
                    if (!memo.provides(item.managerClass)) continue;
                    providers.add(memo);
                    break;
                }
            });
            if (providers.size() >= 1) {
                providers.stream().forEach(memo -> {
                    for (Item item : this.knownManagers) {
                        if (!memo.provides(item.managerClass)) continue;
                        Set provides = providing.getOrDefault(item.managerClass, new HashSet());
                        provides.add(memo);
                        providing.put(item.managerClass, provides);
                    }
                });
                if (log.isDebugEnabled()) {
                    providing.forEach((cls, clsProviders) -> {
                        log.debug("{} default provider is {}, is provided by:", (Object)cls.getName(), (Object)this.defaults.get(cls));
                        clsProviders.forEach(provider -> log.debug("   user name: {}", (Object)provider.getUserName()));
                    });
                }
                for (SystemConnectionMemo memo2 : providers) {
                    if (!providing.keySet().stream().filter(cls -> {
                        Set provides = (Set)providing.get(cls);
                        log.debug("{} is provided by {} out of {} connections", new Object[]{cls.getName(), provides.size(), providers.size()});
                        log.trace("memo stream returns {} due to producers.size() {}", (Object)(provides.size() > 0 ? 1 : 0), (Object)provides.size());
                        return provides.size() > 0;
                    }).anyMatch(cls -> {
                        log.debug("{} has an external default", cls);
                        if (this.defaults.get(cls) == null) {
                            log.trace("memo stream returns true because there's no default defined and an external provider exists");
                            return true;
                        }
                        log.trace("memo stream returns {} due to memo.getUserName() {} and {}", new Object[]{memo2.getUserName().equals(this.defaults.get(cls)), memo2.getUserName(), this.defaults.get(cls)});
                        return memo2.getUserName().equals(this.defaults.get(cls));
                    })) continue;
                    log.trace("setting usesExternalConnections true");
                    usesExternalConnections = true;
                    break;
                }
            }
        }
        log.trace("method end returns {} due to providers.size() {} and usesExternalConnections {}", new Object[]{providers.size() >= 1 ? usesExternalConnections : true, providers.size(), usesExternalConnections});
        return providers.size() >= 1 ? usesExternalConnections : true;
    }

    public boolean isPreferencesValid(Profile profile) {
        return this.isPreferencesValid(profile, InstanceManager.getList(SystemConnectionMemo.class));
    }

    private String nameForClass(@Nonnull Class<?> cls) {
        return cls.getCanonicalName().replace('.', '-');
    }

    private Class<?> classForName(@Nonnull String name) {
        try {
            return Class.forName(name.replace('-', '.'));
        }
        catch (ClassNotFoundException ex) {
            log.error("Could not find class for {}", (Object)name);
            return null;
        }
    }

    public boolean isAllInternalDefaultsValid() {
        return this.allInternalDefaultsValid;
    }

    public void setAllInternalDefaultsValid(boolean isAllInternalDefaultsValid) {
        this.allInternalDefaultsValid = isAllInternalDefaultsValid;
    }

    public static class Item {
        public String typeName;
        public Class<?> managerClass;

        Item(String typeName, Class<?> managerClass) {
            this.typeName = typeName;
            this.managerClass = managerClass;
        }
    }
}

