/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.Reporter;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.AbstractProvidingProxyManager;
import jmri.managers.Bundle;
import jmri.managers.DefaultIdTagManager;

public class ProxyIdTagManager
extends AbstractProvidingProxyManager<IdTag>
implements IdTagManager {
    private boolean stateSaved = false;
    private boolean useFastClock = false;

    @Override
    public int getXMLOrder() {
        return 190;
    }

    @Override
    public void init() {
        if (!this.isInitialised()) {
            this.getDefaultManager().init();
        }
    }

    @Override
    public boolean isInitialised() {
        return this.defaultManager != null && this.getManagerList().stream().allMatch(o -> ((IdTagManager)o).isInitialised());
    }

    @Nonnull
    public IdTagManager getDefaultManager() {
        if (this.defaultManager != this.getInternalManager()) {
            this.defaultManager = this.getInternalManager();
        }
        return (IdTagManager)this.defaultManager;
    }

    @Override
    protected AbstractManager<IdTag> makeInternalManager() {
        DefaultIdTagManager tagMan = new DefaultIdTagManager(InstanceManager.getDefault(InternalSystemConnectionMemo.class));
        InstanceManager.setIdTagManager(tagMan);
        return tagMan;
    }

    @Override
    @CheckForNull
    public IdTag getIdTag(@Nonnull String name) {
        this.init();
        return (IdTag)super.getNamedBean(name);
    }

    @Override
    @Nonnull
    public SortedSet<IdTag> getNamedBeanSet() {
        this.init();
        return super.getNamedBeanSet();
    }

    @Override
    @Nonnull
    protected IdTag makeBean(Manager<IdTag> manager, String systemName, String userName) throws IllegalArgumentException {
        this.init();
        return ((IdTagManager)manager).newIdTag(systemName, userName);
    }

    @Override
    @Nonnull
    public IdTag provide(@Nonnull String name) throws IllegalArgumentException {
        return this.provideIdTag(name);
    }

    @Override
    @Nonnull
    public IdTag provideIdTag(@Nonnull String name) throws IllegalArgumentException {
        this.init();
        return (IdTag)super.provideNamedBean(name);
    }

    @Override
    @Nonnull
    public IdTag newIdTag(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        this.init();
        return (IdTag)this.newNamedBean(systemName, userName);
    }

    @Override
    @CheckForNull
    public IdTag getByTagID(@Nonnull String tagID) {
        this.init();
        return (IdTag)this.getBySystemName(this.makeSystemName(tagID));
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameIdTags" : "BeanNameIdTag");
    }

    @Override
    public Class<IdTag> getNamedBeanClass() {
        return IdTag.class;
    }

    @Override
    public void setStateStored(boolean state) {
        this.stateSaved = state;
        for (Manager mgr : this.getManagerList()) {
            ((IdTagManager)mgr).setStateStored(state);
        }
    }

    @Override
    public boolean isStateStored() {
        this.stateSaved = true;
        for (Manager mgr : this.getManagerList()) {
            if (((IdTagManager)mgr).isStateStored()) continue;
            this.stateSaved = false;
            break;
        }
        return this.stateSaved;
    }

    @Override
    public void setFastClockUsed(boolean fastClock) {
        this.useFastClock = fastClock;
        for (Manager mgr : this.getManagerList()) {
            ((IdTagManager)mgr).setFastClockUsed(fastClock);
        }
    }

    @Override
    public boolean isFastClockUsed() {
        this.useFastClock = true;
        for (Manager mgr : this.getManagerList()) {
            if (((IdTagManager)mgr).isFastClockUsed()) continue;
            this.useFastClock = false;
            break;
        }
        return this.useFastClock;
    }

    @Override
    @Nonnull
    public List<IdTag> getTagsForReporter(@Nonnull Reporter reporter, long threshold) {
        this.init();
        ArrayList<IdTag> out = new ArrayList<IdTag>();
        for (Manager mgr : this.getManagerList()) {
            out.addAll(((IdTagManager)mgr).getTagsForReporter(reporter, threshold));
        }
        return out;
    }
}

