/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.Meter;
import jmri.MeterManager;
import jmri.NamedBean;
import jmri.SystemConnectionMemo;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.AbstractMeterManager;
import jmri.managers.AbstractProxyManager;
import jmri.managers.Bundle;

public class ProxyMeterManager
extends AbstractProxyManager<Meter>
implements MeterManager {
    private boolean muteUpdates = false;
    private final List<Class<? extends Meter>> registerBeans = new ArrayList<Class<? extends Meter>>();
    private final List<Manager<? extends NamedBean>> registerBeanManagers = new ArrayList<Manager<? extends NamedBean>>();

    @Override
    public int getXMLOrder() {
        return 210;
    }

    @Override
    protected AbstractManager<Meter> makeInternalManager() {
        return InstanceManager.getDefault(InternalSystemConnectionMemo.class).getMeterManager();
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameMeters" : "BeanNameMeter");
    }

    @Override
    public Class<Meter> getNamedBeanClass() {
        return Meter.class;
    }

    @Override
    @CheckReturnValue
    @CheckForNull
    public Meter getBySystemName(@Nonnull String systemName) {
        Meter meter = (Meter)super.getBySystemName(systemName);
        if (meter == null) {
            meter = (Meter)this.initInternal().getBySystemName(systemName);
        }
        return meter;
    }

    @Override
    @CheckForNull
    public Meter getByUserName(@Nonnull String userName) {
        Meter meter = (Meter)super.getByUserName(userName);
        if (meter == null) {
            meter = (Meter)this.initInternal().getByUserName(userName);
        }
        return meter;
    }

    @Override
    protected Manager<Meter> createSystemManager(@Nonnull SystemConnectionMemo memo) {
        AbstractMeterManager m = new AbstractMeterManager(memo);
        InstanceManager.setMeterManager(m);
        return m;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (this.muteUpdates) {
            return;
        }
        if ("beans".equals(e.getPropertyName())) {
            for (Class<? extends Meter> clazz : this.registerBeans) {
                Manager<Meter> internalManager;
                if (e.getNewValue() != null && clazz.isAssignableFrom(e.getNewValue().getClass())) {
                    internalManager = this.initInternal();
                    this.muteUpdates = true;
                    internalManager.register((Meter)e.getNewValue());
                    this.muteUpdates = false;
                }
                if (e.getOldValue() == null || !clazz.isAssignableFrom(e.getOldValue().getClass())) continue;
                internalManager = this.initInternal();
                this.muteUpdates = true;
                internalManager.deregister((Meter)e.getOldValue());
                this.muteUpdates = false;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (Manager<? extends NamedBean> manager : this.registerBeanManagers) {
            manager.removePropertyChangeListener("beans", this);
        }
    }
}

