/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers;

import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.StringIO;
import jmri.StringIOManager;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import jmri.managers.AbstractProvidingProxyManager;
import jmri.managers.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyStringIOManager
extends AbstractProvidingProxyManager<StringIO>
implements StringIOManager {
    private static final Logger log = LoggerFactory.getLogger(ProxyStringIOManager.class);

    @Override
    public int getXMLOrder() {
        return 220;
    }

    @Override
    protected AbstractManager<StringIO> makeInternalManager() {
        return InstanceManager.getDefault(InternalSystemConnectionMemo.class).getStringIOManager();
    }

    @Override
    @Nonnull
    protected StringIO makeBean(Manager<StringIO> manager, String systemName, String userName) throws IllegalArgumentException {
        StringIO retval = ((StringIOManager)manager).newStringIO(systemName, userName);
        log.trace("makeBean returns {}", (Object)retval);
        return retval;
    }

    @Override
    public StringIO getStringIO(@Nonnull String name) {
        return (StringIO)super.getNamedBean(name);
    }

    @Override
    @Nonnull
    public StringIO newStringIO(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        return (StringIO)this.newNamedBean(systemName, userName);
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameStringIOs" : "BeanNameStringIO");
    }

    @Override
    @Nonnull
    public StringIO provideStringIO(@Nonnull String sName) throws IllegalArgumentException {
        return (StringIO)super.provideNamedBean(sName);
    }

    @Override
    @Nonnull
    public StringIO provide(@Nonnull String name) throws IllegalArgumentException {
        return this.provideStringIO(name);
    }

    @Override
    public Class<StringIO> getNamedBeanClass() {
        return StringIO.class;
    }
}

