/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.List;
import java.util.SortedSet;
import javax.vecmath.Vector3f;
import jmri.Audio;
import jmri.AudioException;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.audio.AudioFactory;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.audio.AudioSource;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.util.FileUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAudioManagerConfigXML
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(AbstractAudioManagerConfigXML.class);

    @Override
    public Element store(Object o) {
        Element audios = new Element("audio");
        this.setStoreElementClass(audios);
        AudioManager am = (AudioManager)o;
        if (am != null) {
            SortedSet audioList = am.getNamedBeanSet();
            if (audioList.isEmpty()) {
                return null;
            }
            if (am.getNamedBeanSet('S').isEmpty() && am.getNamedBeanSet('B').isEmpty()) {
                return null;
            }
            int vsdObjectCount = 0;
            for (Audio a : audioList) {
                String aName = a.getSystemName();
                log.debug("Check if {} is a VSD object", (Object)aName);
                if (aName.length() < 8 || !aName.substring(3, 8).equalsIgnoreCase("$VSD:")) continue;
                log.debug("...yes");
                ++vsdObjectCount;
            }
            log.debug("Found {} VSD objects of {} objects", (Object)vsdObjectCount, (Object)(am.getNamedBeanSet('S').size() + am.getNamedBeanSet('B').size()));
            if (am.getNamedBeanSet('S').size() + am.getNamedBeanSet('B').size() == vsdObjectCount) {
                log.debug("Only VSD objects - nothing to store");
                return null;
            }
            AudioFactory audioFact = am.getActiveAudioFactory();
            if (audioFact != null) {
                audios.setAttribute("distanceattenuated", audioFact.isDistanceAttenuated() ? "yes" : "no");
            }
            for (Audio a : audioList) {
                String aName = a.getSystemName();
                log.debug("system name is {}", (Object)aName);
                if (aName.length() >= 8 && aName.substring(3, 8).equalsIgnoreCase("$VSD:")) {
                    log.debug("Skipping storage of VSD object {}", (Object)aName);
                    continue;
                }
                Element e = null;
                Element ce = null;
                char type = a.getSubType();
                if (type == 'B') {
                    AudioBuffer ab = (AudioBuffer)a;
                    e = new Element("audiobuffer").setAttribute("systemName", aName);
                    e.addContent((Content)new Element("systemName").addContent(aName));
                    this.storeCommon(ab, e);
                    String url = ab.getURL();
                    ce = new Element("url").addContent(url.isEmpty() ? "" : FileUtil.getPortableFilename(url));
                    e.addContent((Content)ce);
                    ce = new Element("looppoint");
                    ce.setAttribute("start", "" + ab.getStartLoopPoint());
                    ce.setAttribute("end", "" + ab.getEndLoopPoint());
                    e.addContent((Content)ce);
                    ce = new Element("streamed");
                    ce.addContent(ab.isStreamed() ? "yes" : "no");
                    e.addContent((Content)ce);
                } else if (type == 'L') {
                    AudioListener al = (AudioListener)a;
                    e = new Element("audiolistener").setAttribute("systemName", aName);
                    e.addContent((Content)new Element("systemName").addContent(aName));
                    this.storeCommon(al, e);
                    ce = new Element("position");
                    ce.setAttribute("x", "" + al.getPosition().x);
                    ce.setAttribute("y", "" + al.getPosition().y);
                    ce.setAttribute("z", "" + al.getPosition().z);
                    e.addContent((Content)ce);
                    ce = new Element("velocity");
                    ce.setAttribute("x", "" + al.getVelocity().x);
                    ce.setAttribute("y", "" + al.getVelocity().y);
                    ce.setAttribute("z", "" + al.getVelocity().z);
                    e.addContent((Content)ce);
                    ce = new Element("orientation");
                    ce.setAttribute("atX", "" + al.getOrientation((int)1).x);
                    ce.setAttribute("atY", "" + al.getOrientation((int)1).y);
                    ce.setAttribute("atZ", "" + al.getOrientation((int)1).z);
                    ce.setAttribute("upX", "" + al.getOrientation((int)2).x);
                    ce.setAttribute("upY", "" + al.getOrientation((int)2).y);
                    ce.setAttribute("upZ", "" + al.getOrientation((int)2).z);
                    e.addContent((Content)ce);
                    ce = new Element("gain");
                    ce.addContent("" + al.getGain());
                    e.addContent((Content)ce);
                    ce = new Element("metersperunit");
                    ce.addContent("" + al.getMetersPerUnit());
                    e.addContent((Content)ce);
                } else if (type == 'S') {
                    AudioSource as = (AudioSource)a;
                    e = new Element("audiosource").setAttribute("systemName", aName);
                    e.addContent((Content)new Element("systemName").addContent(aName));
                    this.storeCommon(as, e);
                    ce = new Element("position");
                    ce.setAttribute("x", "" + as.getPosition().x);
                    ce.setAttribute("y", "" + as.getPosition().y);
                    ce.setAttribute("z", "" + as.getPosition().z);
                    e.addContent((Content)ce);
                    ce = new Element("velocity");
                    ce.setAttribute("x", "" + as.getVelocity().x);
                    ce.setAttribute("y", "" + as.getVelocity().y);
                    ce.setAttribute("z", "" + as.getVelocity().z);
                    e.addContent((Content)ce);
                    ce = new Element("assignedbuffer");
                    if (as.getAssignedBuffer() != null) {
                        ce.addContent(as.getAssignedBufferName());
                    }
                    e.addContent((Content)ce);
                    ce = new Element("gain");
                    ce.addContent("" + as.getGain());
                    e.addContent((Content)ce);
                    ce = new Element("pitch");
                    ce.addContent("" + as.getPitch());
                    e.addContent((Content)ce);
                    ce = new Element("distances");
                    ce.setAttribute("ref", "" + as.getReferenceDistance());
                    float f = as.getMaximumDistance();
                    ce.setAttribute("max", "" + f);
                    e.addContent((Content)ce);
                    ce = new Element("loops");
                    ce.setAttribute("min", "" + as.getMinLoops());
                    ce.setAttribute("max", "" + as.getMaxLoops());
                    e.addContent((Content)ce);
                    ce = new Element("fadetimes");
                    ce.setAttribute("in", "" + as.getFadeIn());
                    ce.setAttribute("out", "" + as.getFadeOut());
                    e.addContent((Content)ce);
                    ce = new Element("positionrelative");
                    ce.addContent(as.isPositionRelative() ? "yes" : "no");
                    e.addContent((Content)ce);
                }
                log.debug("store Audio {}", (Object)aName);
                audios.addContent((Content)e);
            }
        }
        return audios;
    }

    public abstract void setStoreElementClass(Element var1);

    public void loadAudio(Element audio) {
        String value;
        Element ce;
        String userName;
        String sysName;
        AudioManager am = InstanceManager.getDefault(AudioManager.class);
        int loadedObjects = 0;
        List audioList = audio.getChildren("audiobuffer");
        log.debug("Found {} Audio Buffer objects", (Object)audioList.size());
        for (Element au : audioList) {
            sysName = this.getSystemName(au);
            if (sysName == null) {
                log.warn("unexpected null in systemName {} {}", (Object)au, (Object)au.getAttributes());
                break;
            }
            userName = this.getUserName(au);
            log.debug("create Audio: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
            try {
                AudioBuffer ab = (AudioBuffer)am.newAudio(sysName, userName);
                this.loadCommon(ab, au);
                ce = au.getChild("url");
                if (ce != null) {
                    ab.setURL(ce.getValue());
                }
                if ((ce = au.getChild("looppoint")) != null) {
                    value = ce.getAttributeValue("start");
                    if (value != null) {
                        ab.setStartLoopPoint(Integer.parseInt(value));
                    }
                    if ((value = ce.getAttributeValue("end")) != null) {
                        ab.setEndLoopPoint(Integer.parseInt(value));
                    }
                }
                if ((ce = au.getChild("streamed")) == null) continue;
                ab.setStreamed(ce.getValue().equals("yes"));
            }
            catch (AudioException ex) {
                log.error("Error loading AudioBuffer ({}): ", (Object)sysName, (Object)ex);
            }
        }
        loadedObjects += audioList.size();
        audioList = audio.getChildren("audiosource");
        log.debug("Found {} Audio Source objects", (Object)audioList.size());
        for (Element au : audioList) {
            sysName = this.getSystemName(au);
            if (sysName == null) {
                log.warn("unexpected null in systemName {} {}", (Object)au, (Object)au.getAttributes());
                break;
            }
            userName = this.getUserName(au);
            log.debug("create Audio: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
            try {
                AudioSource as = (AudioSource)am.newAudio(sysName, userName);
                this.loadCommon(as, au);
                ce = au.getChild("position");
                if (ce != null) {
                    as.setPosition(new Vector3f(Float.parseFloat(ce.getAttributeValue("x")), Float.parseFloat(ce.getAttributeValue("y")), Float.parseFloat(ce.getAttributeValue("z"))));
                }
                if ((ce = au.getChild("velocity")) != null) {
                    as.setVelocity(new Vector3f(Float.parseFloat(ce.getAttributeValue("x")), Float.parseFloat(ce.getAttributeValue("y")), Float.parseFloat(ce.getAttributeValue("z"))));
                }
                if ((ce = au.getChild("assignedbuffer")) != null && ce.getValue().length() != 0 && !ce.getValue().equals("null")) {
                    as.setAssignedBuffer(ce.getValue());
                }
                if ((ce = au.getChild("gain")) != null && ce.getValue().length() != 0) {
                    as.setGain(Float.parseFloat(ce.getValue()));
                }
                if ((ce = au.getChild("pitch")) != null && ce.getValue().length() != 0) {
                    as.setPitch(Float.parseFloat(ce.getValue()));
                }
                if ((ce = au.getChild("distances")) != null) {
                    value = ce.getAttributeValue("ref");
                    if (value != null) {
                        as.setReferenceDistance(Float.parseFloat(value));
                    }
                    if ((value = ce.getAttributeValue("max")) != null) {
                        as.setMaximumDistance(Float.parseFloat(value));
                    }
                }
                if ((ce = au.getChild("loops")) != null) {
                    value = ce.getAttributeValue("min");
                    if (value != null) {
                        as.setMinLoops(Integer.parseInt(value));
                    }
                    if ((value = ce.getAttributeValue("max")) != null) {
                        as.setMaxLoops(Integer.parseInt(value));
                    }
                }
                if ((ce = au.getChild("fadetimes")) != null) {
                    value = ce.getAttributeValue("in");
                    if (value != null) {
                        as.setFadeIn(Integer.parseInt(value));
                    }
                    if ((value = ce.getAttributeValue("out")) != null) {
                        as.setFadeOut(Integer.parseInt(value));
                    }
                }
                if ((ce = au.getChild("positionrelative")) == null) continue;
                as.setPositionRelative(ce.getValue().equals("yes"));
            }
            catch (AudioException ex) {
                log.error("Error loading AudioSource ({}): ", (Object)sysName, (Object)ex);
            }
        }
        if ((loadedObjects += audioList.size()) > 0) {
            AudioFactory audioFact;
            Attribute da;
            audioList = audio.getChildren("audiolistener");
            log.debug("Found {} Audio Listener objects", (Object)audioList.size());
            for (Element au : audioList) {
                sysName = this.getSystemName(au);
                if (sysName == null) {
                    log.warn("unexpected null in systemName {} {}", (Object)au, (Object)au.getAttributes());
                    break;
                }
                userName = this.getUserName(au);
                log.debug("create Audio: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
                try {
                    AudioListener al = (AudioListener)am.newAudio(sysName, userName);
                    this.loadCommon(al, au);
                    ce = au.getChild("position");
                    if (ce != null) {
                        al.setPosition(new Vector3f(Float.parseFloat(ce.getAttributeValue("x")), Float.parseFloat(ce.getAttributeValue("y")), Float.parseFloat(ce.getAttributeValue("z"))));
                    }
                    if ((ce = au.getChild("velocity")) != null) {
                        al.setVelocity(new Vector3f(Float.parseFloat(ce.getAttributeValue("x")), Float.parseFloat(ce.getAttributeValue("y")), Float.parseFloat(ce.getAttributeValue("z"))));
                    }
                    if ((ce = au.getChild("orientation")) != null) {
                        al.setOrientation(new Vector3f(Float.parseFloat(ce.getAttributeValue("atX")), Float.parseFloat(ce.getAttributeValue("atY")), Float.parseFloat(ce.getAttributeValue("atZ"))), new Vector3f(Float.parseFloat(ce.getAttributeValue("upX")), Float.parseFloat(ce.getAttributeValue("upY")), Float.parseFloat(ce.getAttributeValue("upZ"))));
                    }
                    if ((ce = au.getChild("gain")) != null) {
                        al.setGain(Float.parseFloat(ce.getValue()));
                    }
                    if ((ce = au.getChild("metersperunit")) == null) continue;
                    al.setMetersPerUnit(Float.parseFloat(ce.getValue()));
                }
                catch (AudioException ex) {
                    log.error("Error loading AudioListener ({}): ", (Object)sysName, (Object)ex);
                }
            }
            if ((da = audio.getAttribute("distanceattenuated")) != null && (audioFact = am.getActiveAudioFactory()) != null) {
                audioFact.setDistanceAttenuated(da.getValue().equals("yes"));
            }
        }
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(AudioManager.class).getXMLOrder();
    }
}

