/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.List;
import java.util.SortedSet;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightControl;
import jmri.LightManager;
import jmri.VariableLight;
import jmri.implementation.DefaultLightControl;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLightManagerConfigXML
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(AbstractLightManagerConfigXML.class);

    @Override
    public Element store(Object o) {
        Element lights = new Element("lights");
        this.setStoreElementClass(lights);
        LightManager lm = (LightManager)o;
        if (lm != null) {
            SortedSet lightList = lm.getNamedBeanSet();
            if (lightList.isEmpty()) {
                return null;
            }
            for (Light lgt : lightList) {
                String lName = lgt.getSystemName();
                log.debug("system name is {}", (Object)lName);
                Element elem = new Element("light");
                elem.addContent((Content)new Element("systemName").addContent(lName));
                this.storeCommon(lgt, elem);
                if (lgt instanceof VariableLight) {
                    elem.setAttribute("minIntensity", "" + ((VariableLight)lgt).getMinIntensity());
                    elem.setAttribute("maxIntensity", "" + ((VariableLight)lgt).getMaxIntensity());
                    elem.setAttribute("transitionTime", "" + ((VariableLight)lgt).getTransitionTime());
                } else {
                    elem.setAttribute("minIntensity", "0.0");
                    elem.setAttribute("maxIntensity", "1.0");
                    elem.setAttribute("transitionTime", "0.0");
                }
                List<LightControl> lcList = lgt.getLightControlList();
                for (LightControl lc : lcList) {
                    if (lc == null) continue;
                    Element lcElem = new Element("lightcontrol");
                    int type = lc.getControlType();
                    lcElem.setAttribute("controlType", "" + type);
                    if (type == 1) {
                        lcElem.setAttribute("controlSensor", lc.getControlSensorName());
                        lcElem.setAttribute("sensorSense", "" + lc.getControlSensorSense());
                    } else if (type == 2) {
                        lcElem.setAttribute("fastClockOnHour", "" + lc.getFastClockOnHour());
                        lcElem.setAttribute("fastClockOnMin", "" + lc.getFastClockOnMin());
                        lcElem.setAttribute("fastClockOffHour", "" + lc.getFastClockOffHour());
                        lcElem.setAttribute("fastClockOffMin", "" + lc.getFastClockOffMin());
                    } else if (type == 3) {
                        lcElem.setAttribute("controlTurnout", lc.getControlTurnoutName());
                        lcElem.setAttribute("turnoutState", "" + lc.getControlTurnoutState());
                    } else if (type == 4) {
                        lcElem.setAttribute("timedControlSensor", lc.getControlTimedOnSensorName());
                        lcElem.setAttribute("duration", "" + lc.getTimedOnDuration());
                    }
                    if (type == 5) {
                        lcElem.setAttribute("controlSensor", lc.getControlSensorName());
                        lcElem.setAttribute("controlSensor2", lc.getControlSensor2Name());
                        lcElem.setAttribute("sensorSense", "" + lc.getControlSensorSense());
                    }
                    elem.addContent((Content)lcElem);
                }
                lights.addContent((Content)elem);
            }
        }
        return lights;
    }

    public abstract void setStoreElementClass(Element var1);

    public boolean loadLights(Element lights) {
        boolean result = true;
        List lightList = lights.getChildren("light");
        log.debug("Found {} lights", (Object)lightList.size());
        LightManager lm = InstanceManager.lightManagerInstance();
        lm.setPropertyChangesSilenced("beans", true);
        for (Element el : lightList) {
            String sysName = this.getSystemName(el);
            if (sysName == null) {
                log.warn("unexpected null in systemName {} {}", (Object)el, (Object)el.getAttributes());
                result = false;
                break;
            }
            String userName = this.getUserName(el);
            this.checkNameNormalization(sysName, userName, lm);
            log.debug("create light: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
            Light lgt = null;
            try {
                lgt = lm.newLight(sysName, userName);
            }
            catch (IllegalArgumentException e) {
                log.error("failed to create Light: {}", (Object)sysName);
                return false;
            }
            this.loadCommon(lgt, el);
            if (lgt instanceof VariableLight) {
                double value = Double.parseDouble(el.getAttribute("minIntensity").getValue());
                ((VariableLight)lgt).setMinIntensity(value);
                value = Double.parseDouble(el.getAttribute("maxIntensity").getValue());
                ((VariableLight)lgt).setMaxIntensity(value);
                value = Double.parseDouble(el.getAttribute("transitionTime").getValue());
                ((VariableLight)lgt).setTransitionTime(value);
            }
            if (el.getAttribute("controlType") != null) {
                int type;
                String temString = el.getAttribute("controlType").getValue();
                try {
                    type = Integer.parseInt(temString);
                }
                catch (NumberFormatException e) {
                    log.error("error when converting control type in legacy Light load support");
                    type = 0;
                }
                if (type != 0) {
                    DefaultLightControl lc = new DefaultLightControl(lgt);
                    lc.setControlType(type);
                    if (type == 1) {
                        lc.setControlSensorName(el.getAttribute("controlSensor").getValue());
                        try {
                            lc.setControlSensorSense(Integer.parseInt(el.getAttribute("sensorSense").getValue()));
                        }
                        catch (NumberFormatException e) {
                            log.error("error when converting control sensor sense in legacy Light load");
                        }
                    } else if (type == 2) {
                        int onHour = 0;
                        int onMin = 0;
                        int offHour = 0;
                        int offMin = 0;
                        try {
                            onHour = Integer.parseInt(el.getAttribute("fastClockOnHour").getValue());
                            onMin = Integer.parseInt(el.getAttribute("fastClockOnMin").getValue());
                            offHour = Integer.parseInt(el.getAttribute("fastClockOffHour").getValue());
                            offMin = Integer.parseInt(el.getAttribute("fastClockOffMin").getValue());
                        }
                        catch (NumberFormatException e) {
                            log.error("error when converting fast clock items in legacy Light load");
                        }
                        lc.setFastClockControlSchedule(onHour, onMin, offHour, offMin);
                    } else if (type == 3) {
                        lc.setControlTurnout(el.getAttribute("controlTurnout").getValue());
                        try {
                            lc.setControlTurnoutState(Integer.parseInt(el.getAttribute("turnoutState").getValue()));
                        }
                        catch (NumberFormatException e) {
                            log.error("error when converting turnout state in legacy Light load");
                        }
                    } else if (type == 4) {
                        lc.setControlTimedOnSensorName(el.getAttribute("timedControlSensor").getValue());
                        try {
                            lc.setTimedOnDuration(Integer.parseInt(el.getAttribute("duration").getValue()));
                        }
                        catch (NumberFormatException e) {
                            log.error("error when converting timed sensor items in legacy Light load");
                        }
                    }
                    lgt.addLightControl(lc);
                }
            }
            List lightControlList = el.getChildren("lightcontrol");
            for (Element elem : lightControlList) {
                boolean noErrors = true;
                DefaultLightControl lc = new DefaultLightControl(lgt);
                String tem = elem.getAttribute("controlType").getValue();
                int type = 0;
                try {
                    type = Integer.parseInt(tem);
                    lc.setControlType(type);
                }
                catch (NumberFormatException e) {
                    log.error("error when converting control type while loading light {}", (Object)sysName);
                    noErrors = false;
                }
                if (type == 1) {
                    lc.setControlSensorName(elem.getAttribute("controlSensor").getValue());
                    try {
                        lc.setControlSensorSense(Integer.parseInt(elem.getAttribute("sensorSense").getValue()));
                    }
                    catch (NumberFormatException e) {
                        log.error("error when converting control sensor sense while loading light {}", (Object)sysName);
                        noErrors = false;
                    }
                } else if (type == 2) {
                    int onHour = 0;
                    int onMin = 0;
                    int offHour = 0;
                    int offMin = 0;
                    try {
                        onHour = Integer.parseInt(elem.getAttribute("fastClockOnHour").getValue());
                        onMin = Integer.parseInt(elem.getAttribute("fastClockOnMin").getValue());
                        offHour = Integer.parseInt(elem.getAttribute("fastClockOffHour").getValue());
                        offMin = Integer.parseInt(elem.getAttribute("fastClockOffMin").getValue());
                        lc.setFastClockControlSchedule(onHour, onMin, offHour, offMin);
                    }
                    catch (NumberFormatException e) {
                        log.error("error when converting fast clock items while loading light {}", (Object)sysName);
                        noErrors = false;
                    }
                } else if (type == 3) {
                    lc.setControlTurnout(elem.getAttribute("controlTurnout").getValue());
                    try {
                        lc.setControlTurnoutState(Integer.parseInt(elem.getAttribute("turnoutState").getValue()));
                    }
                    catch (NumberFormatException e) {
                        log.error("error when converting turnout state while loading light {}", (Object)sysName);
                        noErrors = false;
                    }
                } else if (type == 4) {
                    lc.setControlTimedOnSensorName(elem.getAttribute("timedControlSensor").getValue());
                    try {
                        lc.setTimedOnDuration(Integer.parseInt(elem.getAttribute("duration").getValue()));
                    }
                    catch (NumberFormatException e) {
                        log.error("error when converting timed sensor items while loading light {}", (Object)sysName);
                        noErrors = false;
                    }
                } else if (type == 5) {
                    lc.setControlSensorName(elem.getAttribute("controlSensor").getValue());
                    lc.setControlSensor2Name(elem.getAttribute("controlSensor2").getValue());
                    try {
                        lc.setControlSensorSense(Integer.parseInt(elem.getAttribute("sensorSense").getValue()));
                    }
                    catch (NumberFormatException e) {
                        log.error("error when converting control sensor2 sense while loading light {}", (Object)sysName);
                        noErrors = false;
                    }
                }
                if (!noErrors) continue;
                lgt.addLightControl(lc);
            }
            lgt.activateLight();
        }
        lm.setPropertyChangesSilenced("beans", false);
        return result;
    }

    @Override
    public int loadOrder() {
        return InstanceManager.lightManagerInstance().getXMLOrder();
    }
}

