/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.List;
import java.util.SortedSet;
import jmri.InstanceManager;
import jmri.Meter;
import jmri.MeterManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMeterManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(AbstractMeterManagerXml.class);

    @Override
    public Element store(Object o) {
        Element meters = new Element("meters");
        this.setStoreElementClass(meters);
        MeterManager mm = (MeterManager)o;
        if (mm != null) {
            SortedSet memList = mm.getNamedBeanSet();
            if (memList.isEmpty()) {
                return null;
            }
            for (Meter m : memList) {
                Element elem = this.storeMeter(m);
                meters.addContent((Content)elem);
            }
        }
        return meters;
    }

    protected Element storeMeter(Meter m) {
        String mName = m.getSystemName();
        log.debug("system name is {}", (Object)mName);
        Element elem = new Element("meter");
        elem.addContent((Content)new Element("systemName").addContent(mName));
        this.storeCommon(m, elem);
        return elem;
    }

    public void setStoreElementClass(Element meters) {
        meters.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(Element sharedMeters, Element perNodeMemories) throws JmriConfigureXmlException {
        this.loadMeters(sharedMeters);
        return true;
    }

    public void loadMeters(Element meters) {
        List meterList = meters.getChildren("meter");
        log.debug("Found {} Meter objects", (Object)meterList.size());
        MeterManager mm = InstanceManager.getDefault(MeterManager.class);
        for (Element el : meterList) {
            String sysName = this.getSystemName(el);
            if (sysName == null) {
                log.warn("unexpected null in systemName {}", (Object)el);
                break;
            }
            String userName = this.getUserName(el);
            this.checkNameNormalization(sysName, userName, mm);
            this.loadMeter(sysName, userName, el, mm);
        }
    }

    protected void loadMeter(String sysName, String userName, Element el, MeterManager mm) {
        log.debug("get Meter: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
        Meter m = (Meter)mm.getBySystemName(sysName);
        if (m != null) {
            m.setUserName(userName);
            this.loadCommon(m, el);
        } else {
            log.debug("Meter ({}) does not exists and cannot be created", (Object)sysName);
        }
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(MeterManager.class).getXMLOrder();
    }
}

