/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.XmlAdapter;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNamedBeanManagerConfigXML
extends AbstractXmlAdapter {
    static final String STR_SYSTEM_NAME = "systemName";
    static final String STR_USER_NAME = "userName";
    static final String STR_COMMENT = "comment";
    static final String STR_VALUE = "value";
    static final String STR_CLASS = "class";
    static final String STR_KEY = "key";
    static final String STR_PROPERTY = "property";
    static final String STR_PROPERTIES = "properties";
    private static final Logger log = LoggerFactory.getLogger(AbstractNamedBeanManagerConfigXML.class);

    protected void storeCommon(@Nonnull NamedBean t, Element elem) {
        this.storeUserName(t, elem);
        this.storeComment(t, elem);
        this.storeProperties(t, elem);
    }

    protected void loadCommon(NamedBean t, Element elem) {
        this.loadComment(t, elem);
        this.loadProperties(t, elem);
    }

    void storeComment(@Nonnull NamedBean t, @Nonnull Element elem) {
        if (t.getComment() != null) {
            Element c = new Element(STR_COMMENT);
            c.addContent(t.getComment());
            elem.addContent((Content)c);
        }
    }

    void storeUserName(@Nonnull NamedBean t, @Nonnull Element elem) {
        String uname = t.getUserName();
        if (uname != null && !uname.isEmpty()) {
            elem.addContent((Content)new Element(STR_USER_NAME).addContent(uname));
        }
    }

    protected String getUserName(List<Element> beanList, int i) {
        return this.getUserName(beanList.get(i));
    }

    protected String getUserName(@Nonnull Element elem) {
        if (elem.getChild(STR_USER_NAME) != null) {
            return elem.getChild(STR_USER_NAME).getText();
        }
        if (elem.getAttribute(STR_USER_NAME) != null) {
            return elem.getAttribute(STR_USER_NAME).getValue();
        }
        return null;
    }

    protected String getSystemName(@Nonnull Element elem) {
        if (elem.getChild(STR_SYSTEM_NAME) != null) {
            return elem.getChild(STR_SYSTEM_NAME).getText();
        }
        if (elem.getAttribute(STR_SYSTEM_NAME) != null) {
            return elem.getAttribute(STR_SYSTEM_NAME).getValue();
        }
        return null;
    }

    <T extends NamedBean> void checkNameNormalization(@Nonnull String rawSystemName, @CheckForNull String rawUserName, @Nonnull Manager<T> manager) {
        if (rawUserName != null) {
            String normalizedUserName = NamedBean.normalizeUserName(rawUserName);
            if (!rawUserName.equals(normalizedUserName)) {
                log.warn("Requested user name \"{}\" for system name \"{}\" was normalized to \"{}\"", new Object[]{rawUserName, rawSystemName, normalizedUserName});
            }
            if (normalizedUserName != null) {
                T bean = manager.getByUserName(normalizedUserName);
                if (bean != null && !bean.getSystemName().equals(rawSystemName)) {
                    log.warn("User name \"{}\" already exists as system name \"{}\"", (Object)normalizedUserName, (Object)bean.getSystemName());
                }
            } else {
                log.warn("User name \"{}\" was normalized into null", (Object)rawUserName);
            }
        }
    }

    public <T extends NamedBean> T checkedNamedBeanReference(@CheckForNull String name, @Nonnull T type, @Nonnull Manager<T> m) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return m.getNamedBean(name);
    }

    public <T extends NamedBean> NamedBeanHandle<T> checkedNamedBeanHandle(@CheckForNull String name, @Nonnull T type, @Nonnull Manager<T> m) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        T nb = m.getNamedBean(name);
        if (nb == null) {
            return null;
        }
        return InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, nb);
    }

    public <T extends NamedBean> String checkedNamedBeanName(@CheckForNull String name, T type, @Nonnull Manager<T> m) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        T nb = m.getNamedBean(name);
        if (nb == null) {
            return null;
        }
        return name;
    }

    void loadComment(NamedBean t, List<Element> beanList, int i) {
        this.loadComment(t, beanList.get(i));
    }

    void loadComment(NamedBean t, @Nonnull Element elem) {
        String c = elem.getChildText(STR_COMMENT);
        if (c != null) {
            t.setComment(c);
        }
    }

    String getAttributeString(@Nonnull Element elem, String name) {
        Attribute a = elem.getAttribute(name);
        if (a != null) {
            return a.getValue();
        }
        return null;
    }

    boolean getAttributeBool(@Nonnull Element elem, String name, boolean def) {
        String v = this.getAttributeString(elem, name);
        if (v == null) {
            return def;
        }
        if (def) {
            return !v.equals("false");
        }
        return v.equals("true");
    }

    void storeProperties(@Nonnull NamedBean t, @Nonnull Element elem) {
        Set<String> s = t.getPropertyKeys();
        if (s.isEmpty()) {
            return;
        }
        Element ret = new Element(STR_PROPERTIES);
        elem.addContent((Content)ret);
        s.forEach(key -> {
            Object value = t.getProperty((String)key);
            Element p = new Element(STR_PROPERTY);
            ret.addContent((Content)p);
            p.addContent((Content)new Element(STR_KEY).setText(key));
            if (value != null) {
                p.addContent((Content)new Element(STR_VALUE).setAttribute(STR_CLASS, value.getClass().getName()).setText(value.toString()));
            }
        });
    }

    void loadProperties(NamedBean t, Element elem) {
        Element p = elem.getChild(STR_PROPERTIES);
        if (p == null) {
            return;
        }
        p.getChildren(STR_PROPERTY).forEach(e -> {
            try {
                String key = e.getChild(STR_KEY).getText();
                if (e.getChild(STR_KEY).getAttributeValue(STR_CLASS) != null && !e.getChild(STR_KEY).getAttributeValue(STR_CLASS).isEmpty() && !e.getChild(STR_KEY).getAttributeValue(STR_CLASS).equals("java.lang.String")) {
                    log.warn("NamedBean {} property key of invalid non-String type {} not supported", (Object)t.getSystemName(), (Object)e.getChild(STR_KEY).getAttributeValue(STR_CLASS));
                }
                Object value = null;
                if (e.getChild(STR_VALUE) != null) {
                    Class<?> cl = Class.forName(e.getChild(STR_VALUE).getAttributeValue(STR_CLASS));
                    Constructor<?> ctor = cl.getConstructor(String.class);
                    value = ctor.newInstance(e.getChild(STR_VALUE).getText());
                }
                t.setProperty(key, value);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                log.error("Error loading properties", (Throwable)ex);
            }
        });
    }

    boolean loadInAdapter(List<Element> list, Element perNode) {
        boolean result = true;
        for (Element item : list) {
            String adapterName = item.getAttribute(STR_CLASS).getValue();
            log.debug("load via {}", (Object)adapterName);
            try {
                XmlAdapter adapter = (XmlAdapter)Class.forName(adapterName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                adapter.load(item, perNode);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | JmriConfigureXmlException e) {
                log.error("Exception while loading {}: {}", new Object[]{item.getName(), e, e});
                result = false;
            }
        }
        return result;
    }
}

