/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.List;
import java.util.SortedSet;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractSignalHeadManager;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractSignalHeadManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(AbstractSignalHeadManagerXml.class);

    @Override
    public Element store(Object o) {
        Element signalheads = new Element("signalheads");
        this.setStoreElementClass(signalheads);
        SignalHeadManager shm = (SignalHeadManager)o;
        if (shm != null) {
            SortedSet shList = shm.getNamedBeanSet();
            if (shList.isEmpty()) {
                return null;
            }
            for (SignalHead sh : shList) {
                String shName = sh.getSystemName();
                log.debug("system name is {}", (Object)shName);
                Element e = ConfigXmlManager.elementFromObject(sh);
                if (e == null) continue;
                signalheads.addContent((Content)e);
            }
        }
        return signalheads;
    }

    public void setStoreElementClass(Element turnouts) {
        turnouts.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        this.replaceSignalHeadManager();
        this.loadSignalHeads(shared, perNode);
        return true;
    }

    public void loadSignalHeads(Element shared, Element perNode) {
        InstanceManager.getDefault(SignalHeadManager.class);
        List headClassList = shared.getChildren();
        log.debug("Found {} signal heads", (Object)headClassList.size());
        boolean result = this.loadInAdapter(headClassList, null);
        if (!result) {
            log.warn("error loading signalheads");
        }
    }

    protected void replaceSignalHeadManager() {
        if (InstanceManager.getDefault(SignalHeadManager.class).getClass().getName().equals(AbstractSignalHeadManager.class.getName())) {
            return;
        }
        InstanceManager.getOptionalDefault(SignalHeadManager.class).ifPresent(shm -> InstanceManager.getDefault(ConfigureManager.class).deregister(shm));
        AbstractSignalHeadManager pManager = new AbstractSignalHeadManager(InstanceManager.getDefault(InternalSystemConnectionMemo.class));
        InstanceManager.setDefault(SignalHeadManager.class, pManager);
        InstanceManager.getOptionalDefault(ConfigureManager.class).ifPresent(cm -> cm.registerConfig(pManager, 70));
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(SignalHeadManager.class).getXMLOrder();
    }
}

