/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.List;
import java.util.SortedSet;
import jmri.InstanceManager;
import jmri.StringIO;
import jmri.StringIOManager;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStringIOManagerConfigXML
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(AbstractStringIOManagerConfigXML.class);

    @Override
    public Element store(Object o) {
        log.debug("AbstractStringIOManagerConfigXML store with {}", o);
        Element stringIOs = new Element("stringios");
        this.setStoreElementClass(stringIOs);
        StringIOManager rm = (StringIOManager)o;
        if (rm != null) {
            SortedSet rList = rm.getNamedBeanSet();
            if (rList.isEmpty()) {
                return null;
            }
            for (StringIO r : rList) {
                String rName = r.getSystemName();
                log.debug("system name is {}", (Object)rName);
                Element elem = new Element("stringio");
                elem.addContent((Content)new Element("systemName").addContent(rName));
                this.storeCommon(r, elem);
                log.debug("store StringIO {}", (Object)rName);
                stringIOs.addContent((Content)elem);
            }
        }
        return stringIOs;
    }

    public abstract void setStoreElementClass(Element var1);

    public boolean loadStringIOs(Element stringIOs) {
        boolean result = true;
        List stringIOList = stringIOs.getChildren("stringio");
        log.debug("Found {} StringIOs", (Object)stringIOList.size());
        StringIOManager tm = InstanceManager.getDefault(StringIOManager.class);
        tm.setPropertyChangesSilenced("beans", true);
        for (Element e : stringIOList) {
            String sysName = this.getSystemName(e);
            if (sysName == null) {
                log.warn("unexpected null in systemName {} {}", (Object)e, (Object)e.getAttributes());
                result = false;
                break;
            }
            String userName = this.getUserName(e);
            log.debug("create StringIO: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
            StringIO r = tm.newStringIO(sysName, userName);
            this.loadCommon(r, e);
        }
        tm.setPropertyChangesSilenced("beans", false);
        return result;
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(StringIOManager.class).getXMLOrder();
    }
}

