/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.List;
import java.util.SortedSet;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBeanHandle;
import jmri.Sensor;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.TurnoutOperation;
import jmri.TurnoutOperationManager;
import jmri.configurexml.TurnoutOperationManagerXml;
import jmri.configurexml.turnoutoperations.TurnoutOperationXml;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTurnoutManagerConfigXML
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(AbstractTurnoutManagerConfigXML.class);

    @Override
    public Element store(Object o) {
        Element turnouts = new Element("turnouts");
        this.setStoreElementClass(turnouts);
        TurnoutManager tm = (TurnoutManager)o;
        if (tm != null) {
            TurnoutOperationManagerXml tomx = new TurnoutOperationManagerXml();
            Element opElem = tomx.store(InstanceManager.getDefault(TurnoutOperationManager.class));
            turnouts.addContent((Content)opElem);
            SortedSet tList = tm.getNamedBeanSet();
            if (tList.isEmpty()) {
                return null;
            }
            String defaultclosed = tm.getDefaultClosedSpeed();
            String defaultthrown = tm.getDefaultThrownSpeed();
            turnouts.addContent((Content)new Element("defaultclosedspeed").addContent(defaultclosed));
            turnouts.addContent((Content)new Element("defaultthrownspeed").addContent(defaultthrown));
            for (Turnout t : tList) {
                int iType;
                int iNum;
                String tName = t.getSystemName();
                log.debug("system name is {}", (Object)tName);
                Element elem = new Element("turnout");
                elem.addContent((Content)new Element("systemName").addContent(tName));
                log.debug("store Turnout {}", (Object)tName);
                this.storeCommon(t, elem);
                elem.setAttribute("feedback", t.getFeedbackModeName());
                NamedBeanHandle<Sensor> s = t.getFirstNamedSensor();
                if (s != null) {
                    elem.setAttribute("sensor1", s.getName());
                }
                if ((s = t.getSecondNamedSensor()) != null) {
                    elem.setAttribute("sensor2", s.getName());
                }
                elem.setAttribute("inverted", t.getInverted() ? "true" : "false");
                if (t.canLock(3)) {
                    elem.setAttribute("locked", t.getLocked(3) ? "true" : "false");
                    String lockOpr = t.canLock(1) && t.canLock(2) ? "both" : (t.canLock(1) ? "cab" : (t.canLock(2) ? "pushbutton" : "none"));
                    elem.setAttribute("lockMode", lockOpr);
                    elem.setAttribute("decoder", t.getDecoderName());
                }
                if ((iNum = t.getNumberControlBits()) != 1) {
                    elem.setAttribute("numBits", "" + iNum);
                }
                if ((iType = t.getControlType()) != 0) {
                    elem.setAttribute("controlType", "" + iType);
                }
                String opstr = null;
                TurnoutOperation op = t.getTurnoutOperation();
                if (t.getInhibitOperation()) {
                    opstr = "Off";
                } else if (op == null) {
                    opstr = "Default";
                } else if (op.isNonce()) {
                    TurnoutOperationXml adapter = TurnoutOperationXml.getAdapter(op);
                    if (adapter != null) {
                        Element nonceOpElem = adapter.store(op);
                        elem.addContent((Content)nonceOpElem);
                    }
                } else {
                    opstr = op.getName();
                }
                if (opstr != null) {
                    elem.setAttribute("automate", opstr);
                }
                if (t.getDivergingSpeed() != null && !t.getDivergingSpeed().isEmpty() && !t.getDivergingSpeed().contains("Global")) {
                    elem.addContent((Content)new Element("divergingSpeed").addContent(t.getDivergingSpeed()));
                }
                if (t.getStraightSpeed() != null && !t.getStraightSpeed().isEmpty() && !t.getStraightSpeed().contains("Global")) {
                    elem.addContent((Content)new Element("straightSpeed").addContent(t.getStraightSpeed()));
                }
                turnouts.addContent((Content)elem);
            }
        }
        return turnouts;
    }

    public abstract void setStoreElementClass(Element var1);

    @Override
    public abstract boolean load(Element var1, Element var2);

    public boolean loadTurnouts(Element shared, Element perNode) {
        boolean result = true;
        List operationList = shared.getChildren("operations");
        if (operationList.size() > 1) {
            log.warn("unexpected extra elements found in turnout operations list");
            result = false;
        }
        if (!operationList.isEmpty()) {
            TurnoutOperationManagerXml tomx = new TurnoutOperationManagerXml();
            tomx.load((Element)operationList.get(0), null);
        }
        List turnoutList = shared.getChildren("turnout");
        log.debug("Found {} turnouts", (Object)turnoutList.size());
        TurnoutManager tm = InstanceManager.turnoutManagerInstance();
        tm.setPropertyChangesSilenced("beans", true);
        try {
            String closedSpeed;
            if (shared.getChild("defaultclosedspeed") != null && (closedSpeed = shared.getChild("defaultclosedspeed").getText()) != null && !closedSpeed.isEmpty()) {
                tm.setDefaultClosedSpeed(closedSpeed);
            }
        }
        catch (JmriException ex) {
            log.error("JmriException {}", (Object)ex.getMessage());
        }
        try {
            String thrownSpeed;
            if (shared.getChild("defaultthrownspeed") != null && (thrownSpeed = shared.getChild("defaultthrownspeed").getText()) != null && !thrownSpeed.isEmpty()) {
                tm.setDefaultThrownSpeed(thrownSpeed);
            }
        }
        catch (JmriException ex) {
            log.error("JmriException {}", (Object)ex.getMessage());
        }
        for (Element elem : turnoutList) {
            String speed;
            String sysName = this.getSystemName(elem);
            if (sysName == null) {
                log.error("unexpected null in systemName {}", (Object)elem);
                result = false;
                break;
            }
            String userName = this.getUserName(elem);
            this.checkNameNormalization(sysName, userName, tm);
            log.debug("create turnout: ({})({})", (Object)sysName, (Object)(userName == null ? "<null>" : userName));
            Turnout t = tm.getBySystemName(sysName);
            if (t == null) {
                t = tm.newTurnout(sysName, userName);
            } else if (userName != null) {
                t.setUserName(userName);
            }
            this.loadCommon(t, elem);
            Attribute a = elem.getAttribute("sensor1");
            if (a != null) {
                try {
                    t.provideFirstFeedbackSensor(a.getValue());
                }
                catch (JmriException e) {
                    result = false;
                }
            }
            if ((a = elem.getAttribute("sensor2")) != null) {
                try {
                    t.provideSecondFeedbackSensor(a.getValue());
                }
                catch (JmriException e) {
                    result = false;
                }
            }
            if ((a = elem.getAttribute("feedback")) != null) {
                try {
                    t.setFeedbackMode(a.getValue());
                }
                catch (IllegalArgumentException e) {
                    log.error("Can not set feedback mode: '{}' for turnout: '{}' user name: '{}'", new Object[]{a.getValue(), sysName, userName == null ? "" : userName});
                    result = false;
                }
            }
            t.setInverted(this.getAttributeBool(elem, "inverted", false));
            a = elem.getAttribute("decoder");
            if (a != null) {
                t.setDecoderName(a.getValue());
            }
            if ((a = elem.getAttribute("lockMode")) != null) {
                if (a.getValue().equals("both")) {
                    t.enableLockOperation(3, true);
                }
                if (a.getValue().equals("cab")) {
                    t.enableLockOperation(1, true);
                    t.enableLockOperation(2, false);
                }
                if (a.getValue().equals("pushbutton")) {
                    t.enableLockOperation(2, true);
                    t.enableLockOperation(1, false);
                }
            }
            if ((a = elem.getAttribute("locked")) != null) {
                t.setLocked(3, a.getValue().equals("true"));
            }
            if ((a = elem.getAttribute("numBits")) == null) {
                t.setNumberControlBits(1);
            } else {
                int iNum = Integer.parseInt(a.getValue());
                if (iNum == 1 || iNum == 2) {
                    t.setNumberControlBits(iNum);
                } else {
                    log.warn("illegal number of output bits for control of turnout {}", (Object)sysName);
                    t.setNumberControlBits(1);
                    result = false;
                }
            }
            a = elem.getAttribute("controlType");
            if (a == null) {
                t.setControlType(0);
            } else {
                int iType = Integer.parseInt(a.getValue());
                if (iType >= 0) {
                    t.setControlType(iType);
                } else {
                    log.warn("illegal control type for control of turnout {}", (Object)sysName);
                    t.setControlType(0);
                    result = false;
                }
            }
            List myOpList = elem.getChildren("operation");
            if (!myOpList.isEmpty()) {
                if (myOpList.size() > 1) {
                    log.warn("unexpected extra elements found in turnout-specific operations");
                    result = false;
                }
                TurnoutOperation toper = TurnoutOperationXml.loadOperation((Element)myOpList.get(0));
                t.setTurnoutOperation(toper);
            } else {
                a = elem.getAttribute("automate");
                if (a != null) {
                    String str = a.getValue();
                    if (str.equals("Off")) {
                        t.setInhibitOperation(true);
                    } else if (!str.equals("Default")) {
                        t.setInhibitOperation(false);
                        TurnoutOperation toper = InstanceManager.getDefault(TurnoutOperationManager.class).getOperation(str);
                        t.setTurnoutOperation(toper);
                    } else {
                        t.setInhibitOperation(false);
                    }
                }
            }
            t.setInitialKnownStateFromFeedback();
            try {
                t.setDivergingSpeed("Global");
                if (elem.getChild("divergingSpeed") != null && (speed = elem.getChild("divergingSpeed").getText()) != null && !speed.isEmpty() && !speed.contains("Global")) {
                    t.setDivergingSpeed(speed);
                }
            }
            catch (JmriException ex) {
                log.error("Turnout {} : {}", (Object)t, (Object)ex.getMessage());
            }
            try {
                t.setStraightSpeed("Global");
                if (elem.getChild("straightSpeed") == null || (speed = elem.getChild("straightSpeed").getText()) == null || speed.isEmpty() || speed.contains("Global")) continue;
                t.setStraightSpeed(speed);
            }
            catch (JmriException ex) {
                log.error("Turnout {} : {}", (Object)t, (Object)ex.getMessage());
            }
        }
        tm.setPropertyChangesSilenced("beans", false);
        return result;
    }

    @Override
    public int loadOrder() {
        return InstanceManager.turnoutManagerInstance().getXMLOrder();
    }
}

