/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalManager;
import jmri.ConditionalVariable;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.Logix;
import jmri.implementation.DefaultConditional;
import jmri.implementation.DefaultConditionalAction;
import jmri.jmrit.conditional.ConditionalEditBase;
import jmri.managers.DefaultConditionalManager;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.managers.configurexml.Bundle;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConditionalManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DefaultConditionalManagerXml.class);

    @Override
    public Element store(Object o) {
        Element conditionals = new Element("conditionals");
        this.setStoreElementClass(conditionals);
        ConditionalManager cm = (ConditionalManager)o;
        if (cm != null) {
            SortedSet condList = cm.getNamedBeanSet();
            if (condList.isEmpty()) {
                return null;
            }
            for (Conditional c : condList) {
                String cName = c.getSystemName();
                log.debug("conditional system name is {}", (Object)cName);
                Element elem = new Element("conditional");
                elem.setAttribute("systemName", cName);
                String uName = c.getUserName();
                if (uName != null && !uName.isEmpty()) {
                    elem.setAttribute("userName", uName);
                }
                elem.addContent((Content)new Element("systemName").addContent(cName));
                this.storeCommon(c, elem);
                elem.setAttribute("antecedent", c.getAntecedentExpression());
                elem.setAttribute("logicType", Integer.toString(c.getLogicType().getIntValue()));
                if (c.getTriggerOnChange()) {
                    elem.setAttribute("triggerOnChange", "yes");
                } else {
                    elem.setAttribute("triggerOnChange", "no");
                }
                List<ConditionalVariable> variableList = ((DefaultConditional)c).getStateVariableList();
                for (ConditionalVariable variable : variableList) {
                    Element vElem = new Element("conditionalStateVariable");
                    int oper = variable.getOpern().getIntValue();
                    vElem.setAttribute("operator", Integer.toString(oper));
                    if (variable.isNegated()) {
                        vElem.setAttribute("negated", "yes");
                    } else {
                        vElem.setAttribute("negated", "no");
                    }
                    vElem.setAttribute("type", Integer.toString(variable.getType().getIntValue()));
                    vElem.setAttribute("systemName", variable.getName());
                    vElem.setAttribute("dataString", variable.getDataString());
                    vElem.setAttribute("num1", Integer.toString(variable.getNum1()));
                    vElem.setAttribute("num2", Integer.toString(variable.getNum2()));
                    if (variable.doTriggerActions()) {
                        vElem.setAttribute("triggersCalc", "yes");
                    } else {
                        vElem.setAttribute("triggersCalc", "no");
                    }
                    elem.addContent((Content)vElem);
                }
                List<ConditionalAction> actionList = c.getCopyOfActions();
                for (ConditionalAction action : actionList) {
                    Element aElem = new Element("conditionalAction");
                    aElem.setAttribute("option", Integer.toString(action.getOption()));
                    aElem.setAttribute("type", Integer.toString(action.getType().getIntValue()));
                    aElem.setAttribute("systemName", action.getDeviceName());
                    aElem.setAttribute("data", Integer.toString(action.getActionData()));
                    try {
                        Integer.parseInt(action.getActionString());
                        aElem.setAttribute("delay", action.getActionString());
                    }
                    catch (NumberFormatException nfe) {
                        aElem.setAttribute("delay", "0");
                    }
                    aElem.setAttribute("string", action.getActionString());
                    elem.addContent((Content)aElem);
                }
                conditionals.addContent((Content)elem);
            }
        }
        return conditionals;
    }

    public void setStoreElementClass(Element conditionals) {
        conditionals.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(@Nonnull Element sharedConditionals, Element perNodeConditionals) {
        this.replaceConditionalManager();
        this.loadConditionals(sharedConditionals);
        return true;
    }

    public void loadConditionals(Element conditionals) {
        List conditionalList = conditionals.getChildren("conditional");
        log.debug("Found {} conditionals", (Object)conditionalList.size());
        ConditionalManager cm = InstanceManager.getDefault(ConditionalManager.class);
        String systemNamePrefix = cm.getSystemNamePrefix();
        int namesChanged = 0;
        for (Element condElem : conditionalList) {
            String userName;
            Object sysName = this.getSystemName(condElem);
            if (sysName == null) {
                log.warn("unexpected null in systemName {}", (Object)condElem);
                break;
            }
            if (!((String)sysName).startsWith(systemNamePrefix)) {
                String old = sysName;
                sysName = systemNamePrefix + ":" + (String)sysName;
                log.warn("Converting Conditional system name from {} to {}", (Object)old, sysName);
                ++namesChanged;
            }
            if ((userName = this.getUserName(condElem)) == null) {
                userName = "";
            }
            log.debug("create conditional: ({})({})", sysName, (Object)userName);
            Conditional c = cm.getBySystemName((String)sysName);
            if (c == null) {
                Logix x = cm.getParentLogix((String)sysName);
                if (x == null) {
                    log.warn("Conditional '{}' has no parent Logix", sysName);
                    continue;
                }
                boolean inIndex = false;
                for (int j = 0; j < x.getNumConditionals(); ++j) {
                    String cName = x.getConditionalByNumberOrder(j);
                    if (!((String)sysName).equals(cName)) continue;
                    inIndex = true;
                    break;
                }
                if (!inIndex) {
                    log.warn("Conditional '{}' is not in the Logix index", sysName);
                    continue;
                }
                c = cm.createNewConditional((String)sysName, userName);
            }
            if (c == null) {
                log.error("Conditional '{}' cannot be created", sysName);
                continue;
            }
            this.loadCommon(c, condElem);
            String ant = "";
            int logicType = 1;
            if (condElem.getAttribute("antecedent") != null) {
                String antTemp = condElem.getAttribute("antecedent").getValue();
                ant = ConditionalEditBase.translateAntecedent(antTemp, true);
            }
            if (condElem.getAttribute("logicType") != null) {
                logicType = Integer.parseInt(condElem.getAttribute("logicType").getValue());
            }
            c.setLogicType(Conditional.AntecedentOperator.getOperatorFromIntValue(logicType), ant);
            List conditionalVarList = condElem.getChildren("conditionalStateVariable");
            if (conditionalVarList.size() == 0) {
                log.warn("No state variables found for conditional {}", sysName);
            }
            ArrayList<ConditionalVariable> variableList = new ArrayList<ConditionalVariable>();
            for (Element cvar : conditionalVarList) {
                ConditionalVariable variable = new ConditionalVariable();
                if (cvar.getAttribute("operator") == null) {
                    log.warn("unexpected null in operator {} {}", (Object)cvar, (Object)cvar.getAttributes());
                } else {
                    int oper = Integer.parseInt(cvar.getAttribute("operator").getValue());
                    if (oper == 2) {
                        oper = 4;
                    }
                    if (oper == 3) {
                        oper = 1;
                    }
                    if (oper == 6) {
                        oper = 5;
                    }
                    Conditional.Operator operator = Conditional.Operator.getOperatorFromIntValue(oper);
                    variable.setOpern(operator);
                }
                if (cvar.getAttribute("negated") != null) {
                    variable.setNegation("yes".equals(cvar.getAttribute("negated").getValue()));
                }
                variable.setType(Conditional.Type.getOperatorFromIntValue(Integer.parseInt(cvar.getAttribute("type").getValue())));
                String tempName = cvar.getAttribute("systemName").getValue();
                variable.setName((String)(tempName.equals("RTXINITIALIZER") ? systemNamePrefix + ":" + tempName : tempName));
                if (cvar.getAttribute("dataString") != null) {
                    variable.setDataString(cvar.getAttribute("dataString").getValue());
                }
                if (cvar.getAttribute("num1") != null) {
                    variable.setNum1(Integer.parseInt(cvar.getAttribute("num1").getValue()));
                }
                if (cvar.getAttribute("num2") != null) {
                    variable.setNum2(Integer.parseInt(cvar.getAttribute("num2").getValue()));
                }
                variable.setTriggerActions(true);
                if (cvar.getAttribute("triggersCalc") != null && "no".equals(cvar.getAttribute("triggersCalc").getValue())) {
                    variable.setTriggerActions(false);
                }
                variableList.add(variable);
            }
            c.setStateVariables(variableList);
            List conditionalActionList = condElem.getChildren("conditionalAction");
            List<ConditionalAction> actionList = ((DefaultConditional)c).getActionList();
            for (Element cact : conditionalActionList) {
                DefaultConditionalAction action = new DefaultConditionalAction();
                Attribute attr = cact.getAttribute("option");
                if (attr != null) {
                    action.setOption(Integer.parseInt(attr.getValue()));
                } else {
                    log.warn("unexpected null in option {} {}", (Object)cact, (Object)cact.getAttributes());
                }
                attr = cact.getAttribute("delay");
                if (attr != null) {
                    action.setActionString(attr.getValue());
                }
                if ((attr = cact.getAttribute("type")) != null) {
                    action.setType(Conditional.Action.getOperatorFromIntValue(Integer.parseInt(attr.getValue())));
                } else {
                    log.warn("unexpected null in type {} {}", (Object)cact, (Object)cact.getAttributes());
                }
                attr = cact.getAttribute("systemName");
                if (attr != null) {
                    action.setDeviceName(attr.getValue());
                } else {
                    log.warn("unexpected null in systemName {} {}", (Object)cact, (Object)cact.getAttributes());
                }
                attr = cact.getAttribute("data");
                if (attr != null) {
                    action.setActionData(Integer.parseInt(attr.getValue()));
                } else {
                    log.warn("unexpected null in action data {} {}", (Object)cact, (Object)cact.getAttributes());
                }
                attr = cact.getAttribute("string");
                if (attr != null) {
                    action.setActionString(attr.getValue());
                } else {
                    log.warn("unexpected null in action string {} {}", (Object)cact, (Object)cact.getAttributes());
                }
                if (actionList.contains(action)) continue;
                actionList.add(action);
            }
            c.setAction(actionList);
            boolean triggerOnChange = false;
            if (condElem.getAttribute("triggerOnChange") != null) {
                if ("yes".equals(condElem.getAttribute("triggerOnChange").getValue())) {
                    triggerOnChange = true;
                }
            } else {
                triggerOnChange = true;
            }
            c.setTriggerOnChange(triggerOnChange);
        }
        if (namesChanged > 0) {
            if (!GraphicsEnvironment.isHeadless() && !Boolean.getBoolean("jmri.test.no-dialogs")) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage(namesChanged > 1 ? "ConditionalManager.SystemNamesChanged.Message" : "ConditionalManager.SystemNameChanged.Message", namesChanged), Bundle.getMessage("Manager.SystemNamesChanged.Title", namesChanged, cm.getBeanTypeHandled(namesChanged > 1)), 2);
            }
            log.warn("System names for {} Conditionals changed; this may have operational impacts.", (Object)namesChanged);
        }
    }

    protected void replaceConditionalManager() {
        if (InstanceManager.getDefault(ConditionalManager.class).getClass().getName().equals(DefaultConditionalManager.class.getName())) {
            return;
        }
        if (InstanceManager.getNullableDefault(ConditionalManager.class) != null) {
            InstanceManager.getDefault(ConfigureManager.class).deregister(InstanceManager.getDefault(ConditionalManager.class));
        }
        DefaultConditionalManager pManager = InstanceManager.getDefault(DefaultConditionalManager.class);
        InstanceManager.store(pManager, ConditionalManager.class);
        InstanceManager.setDefault(ConditionalManager.class, pManager);
        InstanceManager.getDefault(ConfigureManager.class).registerConfig(pManager, 240);
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(ConditionalManager.class).getXMLOrder();
    }
}

