/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.awt.GraphicsEnvironment;
import java.util.List;
import java.util.SortedSet;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.Logix;
import jmri.LogixManager;
import jmri.managers.DefaultLogixManager;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.managers.configurexml.Bundle;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLogixManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DefaultLogixManagerXml.class);

    @Override
    public Element store(Object o) {
        Element logixs = new Element("logixs");
        this.setStoreElementClass(logixs);
        LogixManager lxm = (LogixManager)o;
        if (lxm != null) {
            SortedSet logixList = lxm.getNamedBeanSet();
            if (logixList.isEmpty()) {
                return null;
            }
            for (Logix x : logixList) {
                String xName = x.getSystemName();
                log.debug("Logix system name is {}", (Object)xName);
                boolean enabled = x.getEnabled();
                Element elem = new Element("logix");
                elem.addContent((Content)new Element("systemName").addContent(xName));
                String uName = x.getUserName();
                if (uName != null && !uName.isEmpty()) {
                    elem.setAttribute("userName", uName);
                }
                this.storeCommon(x, elem);
                if (enabled) {
                    elem.setAttribute("enabled", "yes");
                } else {
                    elem.setAttribute("enabled", "no");
                }
                int numConditionals = x.getNumConditionals();
                if (numConditionals > 0) {
                    String cSysName = "";
                    Element cElem = null;
                    for (int k = 0; k < numConditionals; ++k) {
                        cSysName = x.getConditionalByNumberOrder(k);
                        cElem = new Element("logixConditional");
                        cElem.setAttribute("systemName", cSysName);
                        cElem.setAttribute("order", Integer.toString(k));
                        elem.addContent((Content)cElem);
                    }
                }
                logixs.addContent((Content)elem);
            }
        }
        return logixs;
    }

    public void setStoreElementClass(Element logixs) {
        logixs.setAttribute("class", this.getClass().getName());
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }

    @Override
    public boolean load(Element sharedLogix, Element perNodeLogix) {
        this.replaceLogixManager();
        this.loadLogixs(sharedLogix);
        return true;
    }

    public void loadLogixs(Element logixs) {
        List logixList = logixs.getChildren("logix");
        log.debug("Found {} Logixs", (Object)logixList.size());
        LogixManager lxm = InstanceManager.getDefault(LogixManager.class);
        String systemNamePrefix = lxm.getSystemNamePrefix();
        int namesChanged = 0;
        block0: for (Element elem : logixList) {
            Logix x;
            String userName;
            Object sysName = this.getSystemName(elem);
            if (sysName == null) {
                log.warn("unexpected null in systemName {}", (Object)elem);
                break;
            }
            if (!((String)sysName).startsWith(systemNamePrefix)) {
                String old = sysName;
                sysName = systemNamePrefix + ":" + (String)sysName;
                log.warn("Converting Logix system name from {} to {}", (Object)old, sysName);
                ++namesChanged;
            }
            log.debug("create logix: ({})({})", sysName, (Object)((userName = this.getUserName(elem)) == null ? "<null>" : userName));
            String yesno = "";
            if (elem.getAttribute("enabled") != null) {
                yesno = elem.getAttribute("enabled").getValue();
            }
            if ((x = lxm.createNewLogix((String)sysName, userName)) == null) continue;
            this.loadCommon(x, elem);
            if (yesno != null && !yesno.equals("")) {
                if (yesno.equals("yes")) {
                    x.setEnabled(true);
                } else if (yesno.equals("no")) {
                    x.setEnabled(false);
                }
            }
            List logixConditionalList = elem.getChildren("logixConditional");
            for (Element lxcond : logixConditionalList) {
                Object cSysName = this.getAttributeString(lxcond, "systemName");
                if (cSysName == null) {
                    log.warn("unexpected null in systemName {} {}", (Object)lxcond, (Object)lxcond.getAttributes());
                    continue block0;
                }
                if (!((String)cSysName).startsWith(systemNamePrefix)) {
                    cSysName = systemNamePrefix + ":" + (String)cSysName;
                }
                int cOrder = Integer.parseInt(lxcond.getAttribute("order").getValue());
                x.addConditional((String)cSysName, cOrder);
            }
        }
        if (namesChanged > 0) {
            if (!GraphicsEnvironment.isHeadless() && !Boolean.getBoolean("jmri.test.no-dialogs")) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage(namesChanged > 1 ? "LogixManager.SystemNamesChanged.Message" : "LogixManager.SystemNameChanged.Message", namesChanged), Bundle.getMessage("Manager.SystemNamesChanged.Title", namesChanged, lxm.getBeanTypeHandled(namesChanged > 1)), 2);
            }
            log.warn("System names for {} Logixs changed; this may have operational impacts.", (Object)namesChanged);
        }
    }

    protected void replaceLogixManager() {
        ConfigureManager cmOD;
        if (InstanceManager.getDefault(LogixManager.class).getClass().getName().equals(DefaultLogixManager.class.getName())) {
            return;
        }
        if (InstanceManager.getNullableDefault(LogixManager.class) != null && (cmOD = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cmOD.deregister(InstanceManager.getDefault(LogixManager.class));
        }
        DefaultLogixManager pManager = InstanceManager.getDefault(DefaultLogixManager.class);
        InstanceManager.store(pManager, LogixManager.class);
        ConfigureManager cmOD2 = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cmOD2 != null) {
            cmOD2.registerConfig(pManager, 230);
        }
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(LogixManager.class).getXMLOrder();
    }
}

