/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.List;
import java.util.SortedSet;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.Turnout;
import jmri.managers.DefaultRouteManager;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.managers.configurexml.Bundle;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRouteManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final String STR_ROUTE = "route";
    private static final String STR_ROUTES = "routes";
    private static final String STR_CONTROL_TURNOUT = "controlTurnout";
    private static final String STR_CONTROL_TURNOUT_FEEDBACK = "controlTurnoutFeedback";
    private static final String STR_CONTROL_TURNOUT_STATE = "controlTurnoutState";
    private static final String STR_CONTROL_LOCK_TURNOUT = "controlLockTurnout";
    private static final String STR_CONTROL_LOCK_TURNOUT_STATE = "controlLockTurnoutState";
    private static final String STR_ACTIVE = "ACTIVE";
    private static final String STR_INACTIVE = "INACTIVE";
    private static final String STR_ON_ACTIVE = "onActive";
    private static final String STR_ON_INACTIVE = "onInactive";
    private static final String STR_ON_CHANGE = "onChange";
    private static final String STR_VETO_ACTIVE = "vetoActive";
    private static final String STR_VETO_INACTIVE = "vetoInactive";
    private static final String STR_THROWN = "THROWN";
    private static final String STR_CLOSED = "CLOSED";
    private static final String STR_CHANGE = "CHANGE";
    private static final String STR_TOGGLE = "TOGGLE";
    private static final String STR_VETO_CLOSED = "VETOCLOSED";
    private static final String STR_VETO_THROWN = "VETOTHROWN";
    private static final String STR_ADDED_DELAY = "addedDelay";
    private static final String STR_ROUTE_LOCKED = "routeLocked";
    private static final String STR_ROUTE_SENSOR = "routeSensor";
    private static final String STR_ROUTE_OUTPUT_SENSOR = "routeOutputSensor";
    private static final String STR_ROUTE_OUTPUT_TURNOUT = "routeOutputTurnout";
    private static final String STR_STATE = "state";
    private static final String STR_MODE = "mode";
    private static final String STR_NAME = "name";
    private static final String STR_ROUTE_SOUND_FILE = "routeSoundFile";
    private static final String STR_ROUTE_SCRIPT_FILE = "routeScriptFile";
    private static final String STR_TURNOUTS_ALIGNED_SENSOR = "turnoutsAlignedSensor";
    private static final Logger log = LoggerFactory.getLogger(DefaultRouteManagerXml.class);

    @Override
    public Element store(Object o) {
        Element routes = new Element(STR_ROUTES);
        this.setStoreElementClass(routes);
        RouteManager rm = (RouteManager)o;
        if (rm != null) {
            SortedSet routeList = rm.getNamedBeanSet();
            if (routeList.isEmpty()) {
                return null;
            }
            for (Route r : routeList) {
                String rSensor;
                String rTurnout;
                int state;
                String rName = r.getSystemName();
                log.debug("system name is {}", (Object)rName);
                String cTurnout = r.getControlTurnout();
                int addedDelay = r.getRouteCommandDelay();
                String cLockTurnout = r.getLockControlTurnout();
                Element elem = new Element(STR_ROUTE);
                elem.addContent((Content)new Element("systemName").addContent(rName));
                String uName = r.getUserName();
                if (uName != null && !uName.isEmpty()) {
                    elem.setAttribute("userName", uName);
                }
                this.storeCommon(r, elem);
                if (cTurnout != null && !cTurnout.isEmpty()) {
                    elem.setAttribute(STR_CONTROL_TURNOUT, cTurnout);
                    state = r.getControlTurnoutState();
                    switch (state) {
                        case 4: {
                            elem.setAttribute(STR_CONTROL_TURNOUT_STATE, STR_THROWN);
                            break;
                        }
                        case 32: {
                            elem.setAttribute(STR_CONTROL_TURNOUT_STATE, STR_CHANGE);
                            break;
                        }
                        case 8: {
                            elem.setAttribute(STR_CONTROL_TURNOUT_STATE, STR_VETO_CLOSED);
                            break;
                        }
                        case 16: {
                            elem.setAttribute(STR_CONTROL_TURNOUT_STATE, STR_VETO_THROWN);
                            break;
                        }
                        default: {
                            elem.setAttribute(STR_CONTROL_TURNOUT_STATE, STR_CLOSED);
                        }
                    }
                    if (r.getControlTurnoutFeedback()) {
                        elem.setAttribute(STR_CONTROL_TURNOUT_FEEDBACK, "true");
                    }
                }
                if (cLockTurnout != null && !cLockTurnout.isEmpty()) {
                    elem.setAttribute(STR_CONTROL_LOCK_TURNOUT, cLockTurnout);
                    state = r.getLockControlTurnoutState();
                    switch (state) {
                        case 4: {
                            elem.setAttribute(STR_CONTROL_LOCK_TURNOUT_STATE, STR_THROWN);
                            break;
                        }
                        case 32: {
                            elem.setAttribute(STR_CONTROL_LOCK_TURNOUT_STATE, STR_CHANGE);
                            break;
                        }
                        default: {
                            elem.setAttribute(STR_CONTROL_LOCK_TURNOUT_STATE, STR_CLOSED);
                        }
                    }
                }
                if (addedDelay > 0) {
                    elem.setAttribute(STR_ADDED_DELAY, Integer.toString(addedDelay));
                }
                if (r.getLocked()) {
                    elem.setAttribute(STR_ROUTE_LOCKED, "True");
                }
                int index = 0;
                while ((rTurnout = r.getOutputTurnoutByIndex(index)) != null) {
                    Element rElem = new Element(STR_ROUTE_OUTPUT_TURNOUT).setAttribute("systemName", rTurnout);
                    String sState = STR_CLOSED;
                    if (r.getOutputTurnoutSetState(rTurnout) == 4) {
                        sState = STR_THROWN;
                    } else if (r.getOutputTurnoutSetState(rTurnout) == 8) {
                        sState = STR_TOGGLE;
                    }
                    rElem.setAttribute(STR_STATE, sState);
                    elem.addContent((Content)rElem);
                    ++index;
                }
                index = 0;
                while ((rSensor = r.getOutputSensorByIndex(index)) != null) {
                    Element rElem = new Element(STR_ROUTE_OUTPUT_SENSOR).setAttribute("systemName", rSensor);
                    String sState = STR_INACTIVE;
                    if (r.getOutputSensorSetState(rSensor) == 2) {
                        sState = STR_ACTIVE;
                    } else if (r.getOutputSensorSetState(rSensor) == 8) {
                        sState = STR_TOGGLE;
                    }
                    rElem.setAttribute(STR_STATE, sState);
                    elem.addContent((Content)rElem);
                    ++index;
                }
                index = 0;
                while ((rSensor = r.getRouteSensorName(index)) != null) {
                    String modeName;
                    Element rsElem = new Element(STR_ROUTE_SENSOR).setAttribute("systemName", rSensor);
                    int mode = r.getRouteSensorMode(index);
                    switch (mode) {
                        case 0: {
                            modeName = STR_ON_ACTIVE;
                            break;
                        }
                        case 1: {
                            modeName = STR_ON_INACTIVE;
                            break;
                        }
                        case 32: {
                            modeName = STR_ON_CHANGE;
                            break;
                        }
                        case 2: {
                            modeName = STR_VETO_ACTIVE;
                            break;
                        }
                        case 3: {
                            modeName = STR_VETO_INACTIVE;
                            break;
                        }
                        default: {
                            modeName = null;
                        }
                    }
                    if (modeName != null) {
                        rsElem.setAttribute(STR_MODE, modeName);
                    }
                    elem.addContent((Content)rsElem);
                    ++index;
                }
                String osn = r.getOutputSoundName();
                if (osn != null && !osn.isEmpty()) {
                    Element rsElem = new Element(STR_ROUTE_SOUND_FILE).setAttribute(STR_NAME, FileUtil.getPortableFilename(new File(osn)));
                    elem.addContent((Content)rsElem);
                }
                if ((osn = r.getOutputScriptName()) != null && !osn.isEmpty()) {
                    Element rsElem = new Element(STR_ROUTE_SCRIPT_FILE).setAttribute(STR_NAME, FileUtil.getPortableFilename(new File(osn)));
                    elem.addContent((Content)rsElem);
                }
                if ((osn = r.getTurnoutsAlignedSensor()) != null && !osn.isEmpty()) {
                    Element rsElem = new Element(STR_TURNOUTS_ALIGNED_SENSOR).setAttribute(STR_NAME, osn);
                    elem.addContent((Content)rsElem);
                }
                log.debug("store Route {}", (Object)rName);
                routes.addContent((Content)elem);
            }
        }
        return routes;
    }

    public void setStoreElementClass(Element routes) {
        routes.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(Element sharedRoutes, Element perNodeRoutes) {
        this.replaceRouteManager();
        this.loadRoutes(sharedRoutes);
        return true;
    }

    public void loadRoutes(Element routes) {
        List routeList = routes.getChildren(STR_ROUTE);
        log.debug("Found {} routes", (Object)routeList.size());
        RouteManager tm = InstanceManager.getDefault(RouteManager.class);
        int namesChanged = 0;
        for (Element el : routeList) {
            Element fileElement;
            List routeTurnoutList;
            Route r;
            String addedDelayTxt;
            String old;
            Object sysName = this.getSystemName(el);
            if (sysName == null) {
                log.warn("unexpected null in systemName {}", (Object)el);
                break;
            }
            if (((String)sysName).startsWith(tm.getSystemPrefix() + "R")) {
                old = sysName;
                sysName = tm.getSystemNamePrefix() + ((String)sysName).substring(tm.getSystemNamePrefix().length());
                log.warn("Converting route system name {} to {}", (Object)old, sysName);
                ++namesChanged;
            }
            if (!((String)sysName).startsWith(tm.getSystemNamePrefix())) {
                old = sysName;
                sysName = tm.getSystemNamePrefix() + (String)sysName;
                log.warn("Converting route system name {} to {}", (Object)old, sysName);
                ++namesChanged;
            }
            String userName = this.getUserName(el);
            String cTurnout = null;
            String cTurnoutState = null;
            boolean cTurnoutFeedback = false;
            String routeLockedTxt = null;
            String cLockTurnout = null;
            String cLockTurnoutState = null;
            int addedDelay = 0;
            if (el.getAttribute(STR_CONTROL_TURNOUT) != null) {
                cTurnout = el.getAttribute(STR_CONTROL_TURNOUT).getValue();
            }
            if (el.getAttribute(STR_CONTROL_TURNOUT_STATE) != null) {
                cTurnoutState = el.getAttribute(STR_CONTROL_TURNOUT_STATE).getValue();
            }
            if (el.getAttribute(STR_CONTROL_TURNOUT_FEEDBACK) != null) {
                cTurnoutFeedback = el.getAttribute(STR_CONTROL_TURNOUT_FEEDBACK).getValue().equals("true");
            }
            if (el.getAttribute(STR_CONTROL_LOCK_TURNOUT) != null) {
                cLockTurnout = el.getAttribute(STR_CONTROL_LOCK_TURNOUT).getValue();
            }
            if (el.getAttribute(STR_CONTROL_LOCK_TURNOUT_STATE) != null) {
                cLockTurnoutState = el.getAttribute(STR_CONTROL_LOCK_TURNOUT_STATE).getValue();
            }
            if (el.getAttribute(STR_ADDED_DELAY) != null && (addedDelayTxt = el.getAttribute(STR_ADDED_DELAY).getValue()) != null) {
                addedDelay = Integer.parseInt(addedDelayTxt);
            }
            if (el.getAttribute(STR_ROUTE_LOCKED) != null) {
                routeLockedTxt = el.getAttribute(STR_ROUTE_LOCKED).getValue();
            }
            log.debug("create route: ({})({})", sysName, (Object)(userName == null ? "<null>" : userName));
            try {
                r = tm.provideRoute((String)sysName, userName);
            }
            catch (IllegalArgumentException ex) {
                log.error("failed to create Route: {}", sysName);
                return;
            }
            this.loadCommon(r, el);
            if (cTurnout != null) {
                r.setControlTurnout(cTurnout);
                if (cTurnoutState != null) {
                    switch (cTurnoutState) {
                        case "THROWN": {
                            r.setControlTurnoutState(4);
                            break;
                        }
                        case "CHANGE": {
                            r.setControlTurnoutState(32);
                            break;
                        }
                        case "VETOCLOSED": {
                            r.setControlTurnoutState(8);
                            break;
                        }
                        case "VETOTHROWN": {
                            r.setControlTurnoutState(16);
                            break;
                        }
                        default: {
                            r.setControlTurnoutState(2);
                            break;
                        }
                    }
                } else {
                    log.error("cTurnoutState was null!");
                }
                r.setControlTurnoutFeedback(cTurnoutFeedback);
            }
            r.setRouteCommandDelay(addedDelay);
            if (routeLockedTxt != null && routeLockedTxt.equals("True")) {
                r.setLocked(true);
            }
            if (cLockTurnout != null) {
                r.setLockControlTurnout(cLockTurnout);
                if (cLockTurnoutState != null) {
                    switch (cLockTurnoutState) {
                        case "THROWN": {
                            r.setLockControlTurnoutState(4);
                            break;
                        }
                        case "CHANGE": {
                            r.setLockControlTurnoutState(32);
                            break;
                        }
                        default: {
                            r.setLockControlTurnoutState(2);
                            break;
                        }
                    }
                } else {
                    log.error("cLockTurnoutState was null!");
                }
            }
            if (!(routeTurnoutList = el.getChildren("routeTurnout")).isEmpty()) {
                for (Element element : routeTurnoutList) {
                    if (element.getAttribute("systemName") == null) {
                        log.warn("unexpected null in route turnout systemName {} {}", (Object)element, (Object)element.getAttributes());
                        break;
                    }
                    String tSysName = element.getAttribute("systemName").getValue();
                    String rState = element.getAttribute(STR_STATE).getValue();
                    int tSetState = 2;
                    if (rState.equals(STR_THROWN)) {
                        tSetState = 4;
                    } else if (rState.equals(STR_TOGGLE)) {
                        tSetState = 8;
                    }
                    r.addOutputTurnout(tSysName, tSetState);
                }
            }
            if (!(routeTurnoutList = el.getChildren(STR_ROUTE_OUTPUT_TURNOUT)).isEmpty()) {
                for (int k = 0; k < routeTurnoutList.size(); ++k) {
                    if (((Element)routeTurnoutList.get(k)).getAttribute("systemName") == null) {
                        log.warn("unexpected null in route turnout systemName {} {}", routeTurnoutList.get(k), (Object)((Element)routeTurnoutList.get(k)).getAttributes());
                        break;
                    }
                    String tSysName = ((Element)routeTurnoutList.get(k)).getAttribute("systemName").getValue();
                    String rState = ((Element)routeTurnoutList.get(k)).getAttribute(STR_STATE).getValue();
                    int tSetState = 2;
                    if (rState.equals(STR_THROWN)) {
                        tSetState = 4;
                    } else if (rState.equals(STR_TOGGLE)) {
                        tSetState = 8;
                    }
                    if (r.isOutputTurnoutIncluded(tSysName)) continue;
                    r.addOutputTurnout(tSysName, tSetState);
                    Turnout t = r.getOutputTurnout(k);
                    if (t == null) {
                        log.error("could not find output Turnout {}", (Object)tSysName);
                        continue;
                    }
                    if (!r.getLocked()) continue;
                    t.setLocked(3, true);
                }
            }
            List routeSensorList = el.getChildren(STR_ROUTE_OUTPUT_SENSOR);
            for (Element sen : routeSensorList) {
                if (sen.getAttribute("systemName") == null) {
                    log.warn("unexpected null in systemName {} {}", (Object)sen, (Object)sen.getAttributes());
                    break;
                }
                String tSysName = sen.getAttribute("systemName").getValue();
                String rState = sen.getAttribute(STR_STATE).getValue();
                int tSetState = 4;
                if (rState.equals(STR_ACTIVE)) {
                    tSetState = 2;
                } else if (rState.equals(STR_TOGGLE)) {
                    tSetState = 8;
                }
                if (r.isOutputSensorIncluded(tSysName)) break;
                r.addOutputSensor(tSysName, tSetState);
            }
            if ((fileElement = el.getChild(STR_ROUTE_SOUND_FILE)) != null) {
                r.setOutputSoundName(FileUtil.getExternalFilename(fileElement.getAttribute(STR_NAME).getValue()));
            }
            if ((fileElement = el.getChild(STR_ROUTE_SCRIPT_FILE)) != null) {
                r.setOutputScriptName(FileUtil.getExternalFilename(fileElement.getAttribute(STR_NAME).getValue()));
            }
            if ((fileElement = el.getChild(STR_TURNOUTS_ALIGNED_SENSOR)) != null) {
                r.setTurnoutsAlignedSensor(fileElement.getAttribute(STR_NAME).getValue());
            }
            routeSensorList = el.getChildren(STR_ROUTE_SENSOR);
            for (Element sen : routeSensorList) {
                String sm;
                if (sen.getAttribute("systemName") == null) {
                    log.warn("unexpected null in systemName {} {}", (Object)sen, (Object)sen.getAttributes());
                    break;
                }
                int mode = 0;
                if (sen.getAttribute(STR_MODE) == null) break;
                switch (sm = sen.getAttribute(STR_MODE).getValue()) {
                    case "onActive": {
                        mode = 0;
                        break;
                    }
                    case "onInactive": {
                        mode = 1;
                        break;
                    }
                    case "onChange": {
                        mode = 32;
                        break;
                    }
                    case "vetoActive": {
                        mode = 2;
                        break;
                    }
                    case "vetoInactive": {
                        mode = 3;
                        break;
                    }
                    default: {
                        log.warn("unexpected sensor mode in route {} was {}", sysName, (Object)sm);
                    }
                }
                r.addSensorToRoute(sen.getAttribute("systemName").getValue(), mode);
            }
            r.activateRoute();
        }
        if (namesChanged > 0) {
            if (!GraphicsEnvironment.isHeadless() && !Boolean.getBoolean("jmri.test.no-dialogs")) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage(namesChanged > 1 ? "RouteManager.SystemNamesChanged.Message" : "RouteManager.SystemNameChanged.Message", namesChanged), Bundle.getMessage("Manager.SystemNamesChanged.Title", namesChanged, tm.getBeanTypeHandled(namesChanged > 1)), 2);
            }
            log.warn("System names for {} Routes changed; this may have operational impacts.", (Object)namesChanged);
        }
    }

    protected void replaceRouteManager() {
        RouteManager current = InstanceManager.getNullableDefault(RouteManager.class);
        if (current != null && current.getClass().getName().equals(DefaultRouteManager.class.getName())) {
            return;
        }
        if (current != null) {
            InstanceManager.getDefault(ConfigureManager.class).deregister(current);
            InstanceManager.deregister(current, RouteManager.class);
        }
        DefaultRouteManager pManager = InstanceManager.getDefault(DefaultRouteManager.class);
        InstanceManager.store(pManager, RouteManager.class);
        InstanceManager.getDefault(ConfigureManager.class).registerConfig(pManager, 160);
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(RouteManager.class).getXMLOrder();
    }
}

