/*
 * Decompiled with CFR 0.152.
 */
package jmri.managers.configurexml;

import java.util.List;
import java.util.SortedSet;
import jmri.InstanceManager;
import jmri.Sensor;
import jmri.SignalGroup;
import jmri.SignalGroupManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Turnout;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import jmri.util.LoggingUtil;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignalGroupManagerXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DefaultSignalGroupManagerXml.class);

    @Override
    public Element store(Object o) {
        Element groups = new Element("signalgroups");
        groups.setAttribute("class", this.getClass().getName());
        SignalGroupManager sgm = (SignalGroupManager)o;
        if (sgm != null) {
            SortedSet sgList = sgm.getNamedBeanSet();
            if (sgList.isEmpty()) {
                return null;
            }
            for (SignalGroup sg : sgList) {
                int x;
                String sgName = sg.getSystemName();
                log.debug("SignalGroup system name is {}", (Object)sgName);
                Element e = new Element("signalgroup");
                e.addContent((Content)new Element("systemName").addContent(sgName));
                this.storeCommon(sg, e);
                groups.addContent((Content)e);
                for (x = 0; x < sg.getNumSignalMastAspects(); ++x) {
                    Element app = new Element("aspect").setAttribute("valid", sg.getSignalMastAspectByIndex(x));
                    e.addContent((Content)app);
                }
                e.setAttribute("signalMast", sg.getSignalMastName());
                for (x = 0; x < sg.getNumHeadItems(); ++x) {
                    this.storeSignalHead(e, sg, x);
                }
            }
        }
        return groups;
    }

    private void storeSignalHead(Element element, SignalGroup _group, int x) {
        int i;
        Element group = new Element("signalHead");
        String name = _group.getHeadItemNameByIndex(x);
        group.setAttribute("name", name);
        group.setAttribute("onAppearance", this.getSignalColour(_group.getHeadOnStateByIndex(x)));
        group.setAttribute("offAppearance", this.getSignalColour(_group.getHeadOffStateByIndex(x)));
        if (_group.getSensorTurnoutOperByIndex(x)) {
            group.setAttribute("sensorTurnoutLogic", "AND");
        } else {
            group.setAttribute("sensorTurnoutLogic", "OR");
        }
        for (i = 0; i < _group.getNumHeadTurnoutsByIndex(x); ++i) {
            this.storeTurnout(group, _group, x, i);
        }
        for (i = 0; i < _group.getNumHeadSensorsByIndex(x); ++i) {
            this.storeSensor(group, _group, x, i);
        }
        element.addContent((Content)group);
    }

    private void storeTurnout(Element element, SignalGroup _group, int x, int turn) {
        Element turnout = new Element("turnout").setAttribute("name", _group.getTurnoutNameByIndex(x, turn));
        turnout.setAttribute("state", "" + _group.getTurnoutStateByIndex(x, turn));
        element.addContent((Content)turnout);
    }

    private void storeSensor(Element element, SignalGroup _group, int x, int sensor) {
        Element Sensor2 = new Element("sensor").setAttribute("name", _group.getSensorNameByIndex(x, sensor));
        Sensor2.setAttribute("state", "" + _group.getSensorStateByIndex(x, sensor));
        element.addContent((Content)Sensor2);
    }

    public void setStoreElementClass(Element signalGroup) {
        signalGroup.setAttribute("class", this.getClass().getName());
    }

    private String getSignalColour(int mAppearance) {
        switch (mAppearance) {
            case 1: {
                return "RED";
            }
            case 2: {
                return "FLASHRED";
            }
            case 4: {
                return "YELLOW";
            }
            case 8: {
                return "FLASHYELLOW";
            }
            case 16: {
                return "GREEN";
            }
            case 32: {
                return "FLASHGREEN";
            }
            case 64: {
                return "LUNAR";
            }
            case 128: {
                return "FLASHLUNAR";
            }
            case 0: {
                return "DARK";
            }
        }
        log.warn("Unexpected appearance: {}", (Object)mAppearance);
        return "DARK";
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        List list = shared.getChildren("signalgroup");
        SignalGroupManager sgm = InstanceManager.getDefault(SignalGroupManager.class);
        for (Element e : list) {
            Object app2;
            String sys = this.getSystemName(e);
            SignalGroup sg = sgm.provideSignalGroup(sys, this.getUserName(e));
            this.loadComment(sg, e);
            String primary = e.getAttribute("signalMast").getValue();
            sg.setSignalMast(primary);
            List appList = e.getChildren("appearance");
            for (Object app2 : appList) {
                String value = app2.getAttribute("valid").getValue();
                LoggingUtil.deprecationWarning(log, "appearance elements in file");
                sg.addSignalMastAspect(value);
            }
            List aspList = e.getChildren("aspect");
            app2 = aspList.iterator();
            while (app2.hasNext()) {
                Element asp = (Element)app2.next();
                String value = asp.getAttribute("valid").getValue();
                sg.addSignalMastAspect(value);
            }
            List signalHeadList = e.getChildren("signalHead");
            for (Element sh : signalHeadList) {
                int state;
                String head = sh.getAttribute("name").getValue();
                SignalHead sigHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(head);
                sg.addSignalHead(sigHead);
                String yesno = sh.getAttribute("sensorTurnoutLogic").getValue();
                boolean inverse = false;
                if (yesno != null && !yesno.isEmpty() && yesno.equals("AND")) {
                    inverse = true;
                }
                sg.setSensorTurnoutOper(sigHead, inverse);
                try {
                    sg.setHeadOnState(sigHead, this.getIntFromColour(sh.getAttribute("onAppearance").getValue()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    sg.setHeadOffState(sigHead, this.getIntFromColour(sh.getAttribute("offAppearance").getValue()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                List signalTurnoutList = sh.getChildren("turnout");
                for (Element sgt : signalTurnoutList) {
                    String tName = sgt.getAttribute("name").getValue();
                    Turnout turnout = InstanceManager.turnoutManagerInstance().getTurnout(tName);
                    state = 0;
                    try {
                        state = sgt.getAttribute("state").getIntValue();
                    }
                    catch (DataConversionException ex) {
                        log.warn("invalid state attribute value");
                    }
                    sg.setHeadAlignTurnout(sigHead, turnout, state);
                }
                List signalSensorList = sh.getChildren("sensor");
                for (Element sgs : signalSensorList) {
                    String sName = sgs.getAttribute("name").getValue();
                    Sensor sensor = InstanceManager.sensorManagerInstance().getSensor(sName);
                    state = 0;
                    try {
                        state = sgs.getAttribute("state").getIntValue();
                    }
                    catch (DataConversionException ex) {
                        log.warn("invalid style attribute value");
                    }
                    sg.setHeadAlignSensor(sigHead, sensor, state);
                }
            }
        }
        return true;
    }

    private int getIntFromColour(String color) {
        switch (color) {
            case "RED": {
                return 1;
            }
            case "YELLOW": {
                return 4;
            }
            case "GREEN": {
                return 16;
            }
            case "LUNAR": {
                return 64;
            }
            case "DARK": {
                return 0;
            }
            case "FLASHRED": {
                return 2;
            }
            case "FLASHYELLOW": {
                return 8;
            }
            case "FLASHGREEN": {
                return 32;
            }
            case "FLASHLUNAR": {
                return 128;
            }
        }
        log.warn("Unexpected appearance: {}", (Object)color);
        return 0;
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(SignalGroupManager.class).getXMLOrder();
    }
}

